/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.edc.internal.symbols.files;

import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteOrder;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.cdt.core.IAddress;
import org.eclipse.cdt.debug.edc.internal.symbols.ISection;
import org.eclipse.cdt.debug.edc.internal.symbols.Section;
import org.eclipse.cdt.debug.edc.internal.symbols.Symbol;
import org.eclipse.cdt.debug.edc.internal.symbols.files.BaseExecutableSymbolicsReader;
import org.eclipse.cdt.debug.edc.internal.symbols.files.ExecutableSection;
import org.eclipse.cdt.debug.edc.internal.symbols.files.SectionInfo;
import org.eclipse.cdt.debug.edc.internal.symbols.files.SectionMapper;
import org.eclipse.cdt.debug.edc.internal.symbols.files.UnmanglerEABI;
import org.eclipse.cdt.debug.edc.internal.symbols.files.UnmanglerWin32;
import org.eclipse.cdt.debug.edc.internal.symbols.files.UnmanglerWin32EABI;
import org.eclipse.cdt.debug.edc.symbols.ISymbol;
import org.eclipse.cdt.utils.Addr32;
import org.eclipse.cdt.utils.Addr64;
import org.eclipse.cdt.utils.coff.Coff;
import org.eclipse.cdt.utils.coff.PE;
import org.eclipse.core.runtime.IPath;

public class PEFileExecutableSymbolicsReader
extends BaseExecutableSymbolicsReader {
    public static final String CODEVIEW_SECTION_NAME = "CodeView_Data";
    public static final String _CRT = ".CRT";
    protected boolean isLE = true;
    protected Map<Integer, ISection> sectionsByPEID = new HashMap<Integer, ISection>();

    public PEFileExecutableSymbolicsReader(IPath binaryFile, PE peFile) throws IOException {
        super(binaryFile);
        this.exeBaseAddress = new Addr32((long)peFile.getNTOptionalHeader().ImageBase);
        this.modificationDate = binaryFile.toFile().lastModified();
        this.sectionMapper = new SectionMapper(binaryFile, this.isLE);
        this.recordSections(peFile);
        boolean isWin32 = false;
        boolean isEABI = false;
        for (ISymbol symbol : this.symbols) {
            String symname = symbol.getName();
            if (symname.startsWith("__Z") && symname.endsWith("v")) {
                isWin32 = true;
                isEABI = true;
                break;
            }
            if (symname.startsWith("_Z") && symname.endsWith("v")) {
                isEABI = true;
                break;
            }
            if (!symname.contains("@") || !symname.contains("?")) continue;
            isWin32 = true;
            break;
        }
        this.unmangler = isWin32 && isEABI ? new UnmanglerWin32EABI() : (isEABI ? new UnmanglerEABI() : new UnmanglerWin32());
    }

    private void recordSections(PE peFile) throws IOException {
        int id = 0;
        Coff.SectionHeader[] secHeaders = peFile.getSectionHeaders();
        long imageBase = (long)peFile.getNTOptionalHeader().ImageBase & 0xFFFFFFFFL;
        Coff.SectionHeader rDataHeader = null;
        int peSectionID = 0;
        Coff.SectionHeader[] sectionHeaderArray = secHeaders;
        int n = secHeaders.length;
        int n2 = 0;
        while (n2 < n) {
            block14: {
                String name;
                Coff.SectionHeader s;
                block11: {
                    String sectionName;
                    block13: {
                        block12: {
                            block10: {
                                s = sectionHeaderArray[n2];
                                ++peSectionID;
                                name = new String(s.s_name).trim();
                                if (name.startsWith("/")) {
                                    int stringTableOffset = Integer.parseInt(name.substring(1));
                                    name = peFile.getStringTableEntry(stringTableOffset);
                                }
                                if (this.executableSections.containsKey(name)) {
                                    throw new IllegalStateException("duplicate section " + name);
                                }
                                ExecutableSection exeSection = new ExecutableSection(this.sectionMapper, name, new SectionInfo(s.s_scnptr, s.s_paddr));
                                this.executableSections.put(name, exeSection);
                                sectionName = name;
                                if (!sectionName.equals(".text")) break block10;
                                name = ".text";
                                break block11;
                            }
                            if (!sectionName.equals(".data") && !sectionName.equals(_CRT)) break block12;
                            name = ".data";
                            break block11;
                        }
                        if (!sectionName.equals(".rdata")) break block13;
                        name = ".rodata";
                        rDataHeader = s;
                        break block11;
                    }
                    if (!sectionName.equals(".bss")) break block14;
                    name = ".bss";
                }
                long size = s.s_paddr;
                HashMap<String, Object> props = new HashMap<String, Object>();
                props.put("name", name);
                Section newSection = new Section(id++, size, (IAddress)new Addr64(Long.toString(imageBase + (long)s.s_vaddr)), props);
                this.sections.add(newSection);
                this.sectionsByPEID.put(peSectionID, newSection);
            }
            ++n2;
        }
        Coff.Symbol[] rawSymbols = peFile.getSymbols();
        int i = 0;
        while (i < rawSymbols.length) {
            Coff.Symbol symbol = rawSymbols[i];
            if (symbol.n_type != 0) {
                String symName = symbol.getName(peFile.getStringTable());
                this.symbols.add(new Symbol(symName, (IAddress)new Addr32((long)symbol.n_value), 1L));
            }
            if (symbol.n_numaux > 0) {
                i += symbol.n_numaux;
            }
            ++i;
        }
        if (rDataHeader != null) {
            this.checkForCodeView(peFile, rDataHeader, imageBase, id);
        }
        Collections.sort(this.symbols);
    }

    private void checkForCodeView(PE peFile, Coff.SectionHeader rDataHeader, long imageBase, int id) throws IOException {
        PE.NTOptionalHeader ntHeader = peFile.getNTOptionalHeader();
        if (ntHeader == null || ntHeader.NumberOfRvaAndSizes < 6) {
            return;
        }
        int debugDir = ntHeader.DataDirectory[6].VirtualAddress;
        if (debugDir == 0) {
            return;
        }
        int debugFormats = ntHeader.DataDirectory[6].Size / 28;
        if (debugFormats == 0) {
            return;
        }
        int offsetInto_rdata = debugDir - rDataHeader.s_vaddr;
        int fileOffset = rDataHeader.s_scnptr + offsetInto_rdata;
        RandomAccessFile accessFile = new RandomAccessFile(this.binaryFile.toOSString(), "r");
        int j = 0;
        while (j < debugFormats) {
            PE.IMAGE_DEBUG_DIRECTORY dir = new PE.IMAGE_DEBUG_DIRECTORY(accessFile, (long)fileOffset);
            if (dir.Type == 2 && dir.SizeOfData > 0) {
                int debugBase = dir.PointerToRawData;
                accessFile.seek(debugBase);
                String s2 = accessFile.readLine();
                if (s2.startsWith("NB11")) {
                    long start = debugBase;
                    long size = accessFile.length() - start;
                    String name = CODEVIEW_SECTION_NAME;
                    ExecutableSection exeSection = new ExecutableSection(this.sectionMapper, name, new SectionInfo(start, size));
                    this.executableSections.put(name, exeSection);
                }
            }
            fileOffset += 28;
            ++j;
        }
    }

    @Override
    public ByteOrder getByteOrder() {
        return this.isLE ? ByteOrder.LITTLE_ENDIAN : ByteOrder.BIG_ENDIAN;
    }

    @Override
    public ISymbol getSymbolAtAddress(IAddress linkAddress) {
        int insertion = Collections.binarySearch(this.symbols, linkAddress);
        if (insertion >= 0) {
            return (ISymbol)this.symbols.get(insertion++);
        }
        if (insertion == -1) {
            return null;
        }
        if ((insertion = -insertion - 1) == this.symbols.size()) {
            return null;
        }
        return (ISymbol)this.symbols.get(insertion - 1);
    }

    public ISection getSectionByPEID(int peID) {
        return this.sectionsByPEID.get(peID);
    }
}

