/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.console.common;

import java.io.UnsupportedEncodingException;
import java.util.Arrays;

public class HistoryHolder {
    private static final int MAX = 100;
    private final byte[][] history = new byte[100][];
    private int size;
    private int pos;

    public synchronized void reset() {
        this.size = 0;
        this.pos = 0;
        int i = 0;
        while (i < 100) {
            this.history[i] = null;
            ++i;
        }
    }

    public synchronized void add(byte[] data) {
        try {
            data = new String(data, "US-ASCII").trim().getBytes("US-ASCII");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {}
        if (data.length == 0) {
            this.pos = this.size;
            return;
        }
        int i = 0;
        while (i < this.size) {
            if (Arrays.equals(this.history[i], data)) {
                System.arraycopy(this.history, i + 1, this.history, i, this.size - i - 1);
                this.history[this.size - 1] = data;
                this.pos = this.size;
                return;
            }
            ++i;
        }
        if (this.size >= 100) {
            System.arraycopy(this.history, 1, this.history, 0, this.size - 1);
            --this.size;
        }
        this.history[this.size++] = data;
        this.pos = this.size;
    }

    public synchronized byte[] next() {
        if (this.pos >= this.size - 1) {
            return null;
        }
        return this.history[++this.pos];
    }

    public synchronized byte[] last() {
        if (this.size > 0) {
            this.pos = this.size - 1;
            return this.history[this.pos];
        }
        return null;
    }

    public synchronized byte[] first() {
        if (this.size > 0) {
            this.pos = 0;
            return this.history[this.pos];
        }
        return null;
    }

    public synchronized byte[] prev() {
        if (this.size == 0) {
            return null;
        }
        if (this.pos == 0) {
            return this.history[this.pos];
        }
        return this.history[--this.pos];
    }
}

