/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.edc.disassembler;

import java.math.BigInteger;
import java.util.StringTokenizer;
import org.eclipse.cdt.debug.edc.disassembler.IDisassembledInstruction;
import org.eclipse.cdt.dsf.debug.service.AbstractInstruction;

public class EDCInstruction
extends AbstractInstruction {
    private final IDisassembledInstruction instruction;
    private String functionName;
    private int offset;

    public EDCInstruction(IDisassembledInstruction instruction) {
        this.instruction = instruction;
        this.functionName = null;
        this.offset = 0;
    }

    public BigInteger getAdress() {
        return this.instruction.getAddress().getValue();
    }

    public String getArgs() {
        String ret = null;
        String asm = this.instruction.getMnemonics();
        StringTokenizer tzer = new StringTokenizer(asm);
        if (tzer.countTokens() == 1) {
            return ret;
        }
        tzer.nextToken();
        ret = tzer.nextToken();
        while (tzer.hasMoreTokens()) {
            ret = String.valueOf(ret) + " " + tzer.nextToken();
        }
        return ret;
    }

    public void setFunctionName(String functionName) {
        this.functionName = functionName;
    }

    public String getFuntionName() {
        return this.functionName;
    }

    public String getFunctionName() {
        return this.functionName;
    }

    public String getInstruction() {
        return this.instruction.getMnemonics();
    }

    public void setOffset(int offset) {
        this.offset = offset;
    }

    public long getOffset() {
        return this.offset;
    }

    public String getOpcode() {
        return null;
    }

    public Integer getSize() {
        return this.instruction.getSize();
    }

    public String toString() {
        return this.instruction.toString();
    }
}

