/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.edc.internal.eval.ast.engine.instructions;

import java.math.BigInteger;
import java.text.MessageFormat;
import org.eclipse.cdt.debug.edc.internal.EDCDebugger;
import org.eclipse.cdt.debug.edc.internal.eval.ast.engine.ASTEvalMessages;
import org.eclipse.cdt.debug.edc.internal.eval.ast.engine.instructions.Interpreter;
import org.eclipse.cdt.debug.edc.internal.eval.ast.engine.instructions.OperandValue;
import org.eclipse.cdt.debug.edc.internal.symbols.IArrayType;
import org.eclipse.cdt.debug.edc.internal.symbols.ICPPBasicType;
import org.eclipse.cdt.debug.edc.internal.symbols.ICompositeType;
import org.eclipse.cdt.debug.edc.internal.symbols.IEnumeration;
import org.eclipse.cdt.debug.edc.symbols.IType;
import org.eclipse.cdt.debug.edc.symbols.TypeUtils;
import org.eclipse.cdt.dsf.datamodel.IDMContext;
import org.eclipse.core.runtime.CoreException;

public abstract class Instruction {
    protected static BigInteger Mask8Bytes = new BigInteger("ffffffffffffffff", 16);
    protected Interpreter fInterpreter;
    public static final int T_undefined = 0;
    public static final int T_Object = 1;
    public static final int T_char = 2;
    public static final int T_byte = 3;
    public static final int T_short = 4;
    public static final int T_boolean = 5;
    public static final int T_void = 6;
    public static final int T_long = 7;
    public static final int T_double = 8;
    public static final int T_float = 9;
    public static final int T_int = 10;
    public static final int T_String = 11;
    public static final int T_null = 12;
    public static final int T_BigInt = 13;
    private static final int[][] fTypeTable;

    static {
        int[][] nArrayArray = new int[14][];
        nArrayArray[0] = new int[14];
        int[] nArray = new int[14];
        nArray[11] = 11;
        nArrayArray[1] = nArray;
        int[] nArray2 = new int[14];
        nArray2[2] = 10;
        nArray2[3] = 10;
        nArray2[4] = 10;
        nArray2[7] = 7;
        nArray2[8] = 8;
        nArray2[9] = 9;
        nArray2[10] = 10;
        nArray2[11] = 11;
        nArray2[13] = 13;
        nArrayArray[2] = nArray2;
        int[] nArray3 = new int[14];
        nArray3[2] = 10;
        nArray3[3] = 10;
        nArray3[4] = 10;
        nArray3[7] = 7;
        nArray3[8] = 8;
        nArray3[9] = 9;
        nArray3[10] = 10;
        nArray3[11] = 11;
        nArray3[13] = 13;
        nArrayArray[3] = nArray3;
        int[] nArray4 = new int[14];
        nArray4[2] = 10;
        nArray4[3] = 10;
        nArray4[4] = 10;
        nArray4[7] = 7;
        nArray4[8] = 8;
        nArray4[9] = 9;
        nArray4[10] = 10;
        nArray4[11] = 11;
        nArray4[13] = 13;
        nArrayArray[4] = nArray4;
        int[] nArray5 = new int[14];
        nArray5[5] = 5;
        nArray5[11] = 11;
        nArrayArray[5] = nArray5;
        nArrayArray[6] = new int[14];
        int[] nArray6 = new int[14];
        nArray6[2] = 7;
        nArray6[3] = 7;
        nArray6[4] = 7;
        nArray6[7] = 7;
        nArray6[8] = 8;
        nArray6[9] = 9;
        nArray6[10] = 7;
        nArray6[11] = 11;
        nArray6[13] = 13;
        nArrayArray[7] = nArray6;
        int[] nArray7 = new int[14];
        nArray7[2] = 8;
        nArray7[3] = 8;
        nArray7[4] = 8;
        nArray7[7] = 8;
        nArray7[8] = 8;
        nArray7[9] = 8;
        nArray7[10] = 8;
        nArray7[11] = 11;
        nArray7[13] = 8;
        nArrayArray[8] = nArray7;
        int[] nArray8 = new int[14];
        nArray8[2] = 9;
        nArray8[3] = 9;
        nArray8[4] = 9;
        nArray8[7] = 9;
        nArray8[8] = 8;
        nArray8[9] = 9;
        nArray8[10] = 9;
        nArray8[11] = 11;
        nArray8[13] = 9;
        nArrayArray[9] = nArray8;
        int[] nArray9 = new int[14];
        nArray9[2] = 10;
        nArray9[3] = 10;
        nArray9[4] = 10;
        nArray9[7] = 7;
        nArray9[8] = 8;
        nArray9[9] = 9;
        nArray9[10] = 10;
        nArray9[11] = 11;
        nArray9[13] = 13;
        nArrayArray[10] = nArray9;
        int[] nArray10 = new int[14];
        nArray10[1] = 11;
        nArray10[2] = 11;
        nArray10[3] = 11;
        nArray10[4] = 11;
        nArray10[5] = 11;
        nArray10[7] = 11;
        nArray10[8] = 11;
        nArray10[9] = 11;
        nArray10[10] = 11;
        nArray10[11] = 11;
        nArray10[12] = 11;
        nArrayArray[11] = nArray10;
        int[] nArray11 = new int[14];
        nArray11[11] = 11;
        nArrayArray[12] = nArray11;
        int[] nArray12 = new int[14];
        nArray12[2] = 13;
        nArray12[3] = 13;
        nArray12[4] = 13;
        nArray12[7] = 13;
        nArray12[8] = 8;
        nArray12[9] = 9;
        nArray12[10] = 13;
        nArray12[13] = 13;
        nArrayArray[13] = nArray12;
        fTypeTable = nArrayArray;
    }

    public abstract int getSize();

    public void setInterpreter(Interpreter interpreter) {
        this.fInterpreter = interpreter;
    }

    public void stop() {
        this.fInterpreter.stop();
    }

    public abstract void execute() throws CoreException;

    protected IDMContext getContext() {
        return this.fInterpreter.getContext();
    }

    protected void jump(int offset) {
        this.fInterpreter.jump(offset);
    }

    protected OperandValue push(OperandValue op) {
        this.fInterpreter.push(op);
        return op;
    }

    protected OperandValue pop() {
        return this.fInterpreter.pop();
    }

    protected OperandValue popValue() throws CoreException {
        OperandValue value = null;
        if (!this.fInterpreter.isEmpty()) {
            value = this.fInterpreter.pop();
        }
        if (value == null) {
            throw EDCDebugger.newCoreException(ASTEvalMessages.Instruction_EmptyStack);
        }
        return value;
    }

    protected OperandValue pushNewValue(IType type, boolean value) {
        OperandValue op = new OperandValue(value ? 1 : 0, type);
        this.fInterpreter.push(op);
        return op;
    }

    protected OperandValue pushNewValue(IType type, Number value) {
        OperandValue op = new OperandValue(value, type);
        this.fInterpreter.push(op);
        return op;
    }

    protected OperandValue pushNewValue(IType type, String value) {
        OperandValue op = new OperandValue(value, type);
        this.fInterpreter.push(op);
        return op;
    }

    protected OperandValue convertForPromotion(OperandValue operand) throws CoreException {
        IType type = this.getBasicType(operand.getValueType());
        if (type instanceof ICompositeType) {
            throw EDCDebugger.newCoreException(ASTEvalMessages.Instruction_CannotUseCompositeType);
        }
        if (type instanceof IArrayType && operand.getValueLocation() != null) {
            return new OperandValue(operand.getValueLocationAddress(), this.fInterpreter.getTypeEngine().getPointerSizeType());
        }
        return operand;
    }

    public int getJavaBinaryPromotionType(OperandValue left, OperandValue right) throws CoreException {
        int leftType = this.getValueType(left);
        int rightType = this.getValueType(right);
        return fTypeTable[leftType][rightType];
    }

    public int getBinaryPromotionType(int left, int right) {
        return fTypeTable[left][right];
    }

    public int getValueType(OperandValue op) throws CoreException {
        Number value = op.getValue();
        if (value == null && op.getStringValue() != null) {
            return 11;
        }
        if (value instanceof Integer) {
            return 10;
        }
        if (value instanceof Short) {
            return 4;
        }
        if (value instanceof Byte) {
            return 3;
        }
        if (value instanceof Long) {
            return 7;
        }
        if (value instanceof Float) {
            return 9;
        }
        if (value instanceof Double) {
            return 8;
        }
        if (value instanceof BigInteger) {
            return 13;
        }
        return this.getJavaValueType(op.getValueType());
    }

    public int getCValueType(OperandValue op) throws CoreException {
        if (op.getStringValue() != null) {
            return 11;
        }
        IType type_ = this.getBasicType(op.getValueType());
        if (!(type_ instanceof ICPPBasicType)) {
            return 0;
        }
        ICPPBasicType type = (ICPPBasicType)type_;
        switch (type.getBaseType()) {
            case 6: {
                return 5;
            }
            case 2: {
                return 2;
            }
            case 4: {
                return 9;
            }
            case 5: {
                if (type.isLong()) assert (false);
                return 8;
            }
            case 3: {
                if (type.isLongLong()) {
                    return 13;
                }
                if (type.isLong()) {
                    return 7;
                }
                if (type.isShort()) {
                    return 4;
                }
                return 10;
            }
            case 0: {
                return 0;
            }
            case 1: {
                return 6;
            }
        }
        return 0;
    }

    public IType getBinaryPromotionType(OperandValue leftOp, OperandValue rightOp) throws CoreException {
        int rightType;
        int leftType = this.getCValueType(leftOp);
        int promoted = this.getBinaryPromotionType(leftType, rightType = this.getCValueType(rightOp));
        if (promoted == 12 || promoted == 0 || promoted == 6) {
            throw EDCDebugger.newCoreException(MessageFormat.format(ASTEvalMessages.Instruction_UnhandledTypeCombination, leftOp.getValueType().getName(), rightOp.getValueType().getName()));
        }
        if (leftType == promoted) {
            return this.getBasicType(leftOp.getValueType());
        }
        if (rightType == promoted) {
            return this.getBasicType(rightOp.getValueType());
        }
        boolean isSigned = true;
        switch (promoted) {
            case 2: {
                return this.fInterpreter.getTypeEngine().getIntegerTypeFor(1, isSigned);
            }
            case 4: {
                return this.fInterpreter.getTypeEngine().getIntegerTypeFor(4, isSigned);
            }
            case 10: {
                return this.fInterpreter.getTypeEngine().getIntegerTypeFor(6, isSigned);
            }
            case 7: {
                return this.fInterpreter.getTypeEngine().getIntegerTypeFor(8, isSigned);
            }
            case 9: {
                return this.fInterpreter.getTypeEngine().getFloatTypeOfSize(12);
            }
            case 8: {
                return this.fInterpreter.getTypeEngine().getFloatTypeOfSize(14);
            }
        }
        assert (false);
        throw EDCDebugger.newCoreException(String.valueOf(ASTEvalMessages.UnhandledTypeCode) + promoted);
    }

    private IType getBasicType(IType type) {
        if ((type = TypeUtils.getStrippedType(type)) instanceof IEnumeration) {
            int byteSize = ((IEnumeration)type).getByteSize();
            type = this.fInterpreter.getTypeEngine().getIntegerTypeOfSize(byteSize, true);
        }
        return type;
    }

    public int getJavaValueType(IType type_) {
        if (!((type_ = this.getBasicType(type_)) instanceof ICPPBasicType)) {
            if (type_ instanceof IArrayType && type_.getType() instanceof ICPPBasicType && (((ICPPBasicType)type_.getType()).getBaseType() == 2 || ((ICPPBasicType)type_.getType()).getBaseType() == 7)) {
                return 11;
            }
            return 0;
        }
        ICPPBasicType type = (ICPPBasicType)type_;
        switch (type.getBaseType()) {
            case 6: {
                return 5;
            }
            case 2: {
                return 2;
            }
            case 4: {
                return 9;
            }
            case 5: {
                if (type.isLong()) assert (false);
                return 8;
            }
            case 0: {
                return 0;
            }
            case 1: {
                return 6;
            }
            case 3: {
                if (type.isLongLong()) {
                    if (type.getByteSize() > 8 || type.getByteSize() == 8 && type.isUnsigned()) {
                        return 13;
                    }
                    return 7;
                }
                if (type.isLong()) {
                    if (type.getByteSize() > 8 || type.getByteSize() == 8 && type.isUnsigned()) {
                        return 13;
                    }
                    return 7;
                }
                switch (type.getByteSize()) {
                    case 1: {
                        if (type.isUnsigned()) {
                            return 4;
                        }
                        return 3;
                    }
                    case 2: {
                        if (type.isUnsigned()) {
                            return 10;
                        }
                        return 4;
                    }
                    case 4: {
                        if (type.isUnsigned()) {
                            return 10;
                        }
                        return 4;
                    }
                }
                if (!type.isLong()) break;
                if (type.isUnsigned() && type.getByteSize() > 8) {
                    return 13;
                }
                return 7;
            }
        }
        return 0;
    }
}

