/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.edc.internal.eval.ast.engine.instructions;

import java.math.BigInteger;
import org.eclipse.cdt.debug.edc.internal.eval.ast.engine.instructions.BinaryOperator;
import org.eclipse.cdt.debug.edc.internal.eval.ast.engine.instructions.Instruction;
import org.eclipse.core.runtime.CoreException;

public class OperatorShiftLeft
extends BinaryOperator {
    public OperatorShiftLeft(int start) {
        this(0, false, start);
    }

    protected OperatorShiftLeft(int resultId, boolean isAssignmentOperator, int start) {
        super(resultId, isAssignmentOperator, start);
    }

    @Override
    protected int getIntResult(int leftOperand, int rightOperand) throws CoreException {
        return leftOperand << rightOperand;
    }

    @Override
    protected long getLongResult(long leftOperand, long rightOperand) throws CoreException {
        return leftOperand << (int)rightOperand;
    }

    @Override
    protected BigInteger getBigIntegerResult(BigInteger leftOperand, BigInteger rightOperand, int length) throws CoreException {
        return leftOperand.shiftLeft(rightOperand.intValue()).and(Instruction.Mask8Bytes);
    }

    @Override
    protected float getFloatResult(float leftOperand, float rightOperand) {
        return 0.0f;
    }

    @Override
    protected double getDoubleResult(double leftOperand, double rightOperand) {
        return 0.0;
    }

    @Override
    protected boolean getBooleanResult(boolean leftOperand, boolean rightOperand) {
        return false;
    }
}

