/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.edc.internal.eval.ast.engine.instructions;

import org.eclipse.cdt.debug.edc.internal.eval.ast.engine.instructions.SimpleInstruction;
import org.eclipse.cdt.debug.edc.symbols.IType;

public class PushString
extends SimpleInstruction {
    private String fValue;
    private boolean isWide;
    private IType stringType;

    public PushString(String value) {
        if (value.startsWith("L")) {
            this.isWide = true;
            value = value.substring(1);
        }
        this.fValue = value.substring(1, value.length() - 1);
    }

    @Override
    public void execute() {
        if (this.stringType == null) {
            int size = this.fInterpreter.getTypeEngine().getTypeSize(this.isWide ? 20 : 1);
            IType charType = this.fInterpreter.getTypeEngine().getBasicType(2, 0, size);
            this.stringType = this.fInterpreter.getTypeEngine().getCharArrayType(charType, this.fValue.length() + 1);
        }
        this.pushNewValue(this.stringType, this.fValue);
    }

    public String toString() {
        return this.fValue;
    }
}

