/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.edc.internal.symbols;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.SortedMap;
import java.util.TreeMap;
import org.eclipse.cdt.core.IAddress;
import org.eclipse.cdt.debug.edc.internal.PathUtils;
import org.eclipse.cdt.debug.edc.internal.services.dsf.Modules;
import org.eclipse.cdt.debug.edc.internal.symbols.CompileUnitScope;
import org.eclipse.cdt.debug.edc.internal.symbols.dwarf.DwarfCompileUnit;
import org.eclipse.cdt.debug.edc.symbols.ICompileUnitScope;
import org.eclipse.cdt.debug.edc.symbols.IFunctionScope;
import org.eclipse.cdt.debug.edc.symbols.ILineEntry;
import org.eclipse.cdt.debug.edc.symbols.ILineEntryProvider;
import org.eclipse.cdt.debug.edc.symbols.IScope;
import org.eclipse.core.runtime.IPath;

class FileLineEntryProvider
implements ILineEntryProvider {
    private List<ILineEntry> lineEntries = new ArrayList<ILineEntry>();
    private List<ILineEntry> cuEntries = null;
    private TreeMap<Integer, List<ILineEntry>> lineEntriesByLine = new TreeMap();
    private TreeMap<IAddress, ILineEntry> lineEntriesByAddress = new TreeMap();
    private IPath filePath;
    private final ICompileUnitScope compileUnitScope;
    private boolean sorted;

    public FileLineEntryProvider(ICompileUnitScope compileUnitScope, IPath path) {
        this.compileUnitScope = compileUnitScope;
        this.filePath = path;
        this.sorted = true;
    }

    protected void setCULineEntries(Collection<ILineEntry> entries) {
        this.cuEntries = new ArrayList<ILineEntry>(entries);
    }

    protected List<ILineEntry> getCULineEntries() {
        if (this.cuEntries == null) {
            this.setCULineEntries(this.compileUnitScope.getLineEntries());
        }
        return this.cuEntries;
    }

    public ICompileUnitScope getCU() {
        return this.compileUnitScope;
    }

    public String toString() {
        return this.filePath + " at " + ((CompileUnitScope)this.compileUnitScope).lowAddress + ": " + this.lineEntries.size() + " entries";
    }

    public void addLineEntry(ILineEntry entry) {
        this.lineEntries.add(entry);
        List<ILineEntry> currentMappings = this.lineEntriesByLine.get(entry.getLineNumber());
        if (currentMappings == null) {
            currentMappings = new ArrayList<ILineEntry>();
            this.lineEntriesByLine.put(entry.getLineNumber(), currentMappings);
        }
        currentMappings.add(entry);
        ILineEntry currentByAddress = this.lineEntriesByAddress.get(entry.getLowAddress());
        if (currentByAddress == null || entry.getHighAddress().compareTo((Object)currentByAddress.getHighAddress()) > 0) {
            this.lineEntriesByAddress.put(entry.getLowAddress(), entry);
        }
        this.sorted = false;
    }

    @Override
    public ILineEntry getLineEntryAtAddress(IAddress linkAddress) {
        int insertion;
        if (!this.sorted) {
            Collections.sort(this.lineEntries);
            this.sorted = true;
        }
        if (-1 != (insertion = this.getLineEntryInsertionForAddress(linkAddress, this.lineEntries))) {
            return this.lineEntries.get(insertion);
        }
        return null;
    }

    private int getLineEntryInsertionForAddress(IAddress linkAddress, List<? extends ILineEntry> entriesToSearch) {
        int insertion = Collections.binarySearch(entriesToSearch, linkAddress);
        if (insertion >= 0) {
            ILineEntry newEntry;
            int newInsertion;
            ILineEntry entry = entriesToSearch.get(insertion);
            if (entry.getHighAddress().compareTo((Object)entry.getLowAddress()) != 0) {
                return insertion;
            }
            if (insertion > 0) {
                newInsertion = insertion - 1;
                newEntry = entriesToSearch.get(newInsertion);
                while (newEntry.getLowAddress().compareTo((Object)entry.getLowAddress()) == 0) {
                    if (newEntry.getHighAddress().compareTo((Object)newEntry.getLowAddress()) != 0) {
                        return newInsertion;
                    }
                    if (--newInsertion < 0) break;
                    newEntry = entriesToSearch.get(newInsertion);
                }
            }
            if (insertion < entriesToSearch.size() - 1) {
                newInsertion = insertion + 1;
                newEntry = entriesToSearch.get(newInsertion);
                while (newEntry.getLowAddress().compareTo((Object)entry.getLowAddress()) == 0) {
                    if (newEntry.getHighAddress().compareTo((Object)newEntry.getLowAddress()) != 0) {
                        return newInsertion;
                    }
                    if (++newInsertion == entriesToSearch.size()) break;
                    newEntry = this.lineEntries.get(newInsertion);
                }
            }
            return insertion;
        }
        if (insertion == -1) {
            return -1;
        }
        insertion = -insertion - 2;
        ILineEntry entry = entriesToSearch.get(insertion);
        if (insertion > 0 && entry.getHighAddress().compareTo((Object)entry.getLowAddress()) == 0) {
            int newInsertion = insertion - 1;
            ILineEntry newEntry = entriesToSearch.get(newInsertion);
            while (newEntry.getLowAddress().compareTo((Object)entry.getLowAddress()) == 0) {
                if (newEntry.getHighAddress().compareTo((Object)newEntry.getLowAddress()) != 0 && linkAddress.compareTo((Object)newEntry.getHighAddress()) < 0) {
                    return newInsertion;
                }
                if (--newInsertion < 0) break;
                newEntry = entriesToSearch.get(newInsertion);
            }
        }
        if (linkAddress.compareTo((Object)entry.getHighAddress()) < 0) {
            return insertion;
        }
        return -1;
    }

    @Override
    public Collection<ILineEntry> getLineEntriesForLines(IPath path, int startLineNumber, int endLineNumber) {
        List<ILineEntry> startMappings;
        if (!this.filePath.setDevice(null).equals((Object)path.setDevice(null)) && !PathUtils.isCaseSensitive() && this.filePath.toOSString().compareToIgnoreCase(path.toOSString()) != 0) {
            return Collections.emptyList();
        }
        int lntSize = this.lineEntries.size();
        int endLine = endLineNumber != -1 ? endLineNumber : this.lineEntriesByLine.lastKey();
        List<ILineEntry> entries = new ArrayList<ILineEntry>();
        while ((startMappings = this.lineEntriesByLine.get(startLineNumber)) == null && startLineNumber < endLine) {
            ++startLineNumber;
        }
        if (startMappings != null) {
            if (startLineNumber == endLineNumber) {
                entries.addAll(startMappings);
            } else {
                List<ILineEntry> endMappings;
                entries = endLineNumber == -1 ? this.lineEntries.subList(this.lineEntries.indexOf(startMappings.get(0)), lntSize) : ((endMappings = this.lineEntriesByLine.get(endLineNumber)) != null ? this.lineEntries.subList(this.lineEntries.indexOf(startMappings.get(0)), this.lineEntries.indexOf(endMappings.get(endMappings.size() - 1)) + 1) : this.lineEntries.subList(this.lineEntries.indexOf(startMappings.get(0)), lntSize));
            }
        }
        return Collections.unmodifiableCollection(entries);
    }

    @Override
    public ILineEntry getNextLineEntry(ILineEntry entry, boolean collapseInlineFunctions) {
        IFunctionScope foundFn;
        ILineEntry next;
        IAddress foundAddr;
        SortedMap<IAddress, ILineEntry> tailAddrs;
        IAddress desiredAddr;
        if (entry == null || this.isLastEntryInCU(entry)) {
            return null;
        }
        IFunctionScope entryFn = this.compileUnitScope.getFunctionAtAddress(entry.getLowAddress());
        IFunctionScope container = FileLineEntryProvider.ignoreInlineFunctions(entryFn);
        if (container == null) {
            return null;
        }
        while (true) {
            if ((desiredAddr = entry.getHighAddress()).compareTo((Object)container.getHighAddress()) > 0) {
                return null;
            }
            SortedMap<IAddress, ILineEntry> sortedMap = tailAddrs = desiredAddr.equals((Object)entry.getLowAddress()) ? null : this.lineEntriesByAddress.tailMap(desiredAddr);
            if (tailAddrs == null || tailAddrs.isEmpty()) {
                if (collapseInlineFunctions && entryFn != container && entry.getLowAddress().equals((Object)entryFn.getLowAddress()) && entryFn.getParent().equals(container)) {
                    return this.getDifferentLineEntryInCU(container, entry, entryFn.getHighAddress(), collapseInlineFunctions);
                }
                return this.getDifferentLineEntryInCU(entryFn, entry, desiredAddr, collapseInlineFunctions);
            }
            foundAddr = tailAddrs.firstKey();
            next = (ILineEntry)tailAddrs.get(foundAddr);
            foundFn = this.compileUnitScope.getFunctionAtAddress(foundAddr);
            if (!entryFn.equals(foundFn)) break;
            if (next.getLineNumber() != entry.getLineNumber()) {
                return next;
            }
            entry = next;
        }
        if (foundAddr.equals((Object)desiredAddr) && foundFn != null) {
            if (entryFn.getParent().equals(foundFn) || entryFn.getParent().equals(foundFn.getParent())) {
                return (ILineEntry)tailAddrs.get(foundAddr);
            }
            if (foundFn.getParent().equals(entryFn) && this.areEntriesAdjacentLines(entry, next)) {
                return next;
            }
        } else if (collapseInlineFunctions && (entryFn.getParent().equals(foundFn) || entryFn.getParent().equals(container)) && this.areEntriesAdjacentLines(entry, next)) {
            return next;
        }
        return this.getDifferentLineEntryInCU(entryFn, entry, desiredAddr, collapseInlineFunctions);
    }

    private static boolean isAncestorFunction(IFunctionScope c, IFunctionScope x) {
        IScope p = c.getParent();
        while (p != null) {
            if (p.equals(x)) {
                return true;
            }
            p = p.getParent();
        }
        return false;
    }

    static boolean isInlinedFunction(IFunctionScope function) {
        return function != null && function.getParent() instanceof IFunctionScope;
    }

    /*
     * Unable to fully structure code
     */
    private static IFunctionScope ignoreInlineFunctions(IFunctionScope function) {
        if (function != null) ** GOTO lbl4
        return null;
lbl-1000:
        // 1 sources

        {
            function = (IFunctionScope)function.getParent();
lbl4:
            // 2 sources

            ** while (function.getParent() instanceof IFunctionScope)
        }
lbl5:
        // 1 sources

        return function;
    }

    private boolean areEntriesAdjacentLines(ILineEntry entry, ILineEntry next) {
        int entryIdx;
        List entries;
        if (entry.getLineNumber() == next.getLineNumber()) {
            return false;
        }
        SortedMap<Integer, List<ILineEntry>> tailLines = this.lineEntriesByLine.tailMap(entry.getLineNumber());
        return tailLines != null && (entries = (List)tailLines.get(entry.getLineNumber())) != null && -1 != (entryIdx = entries.indexOf(entry)) && entry.equals(entries.get(0)) && ++entryIdx == entries.size() && (entries = (List)tailLines.get(next.getLineNumber())) != null && next.equals(entries.get(0));
    }

    private ILineEntry getDifferentLineEntryInCU(IFunctionScope entryFn, ILineEntry origEntry, IAddress desiredAddr, boolean collapseInlineFunctions) {
        block5: {
            block4: {
                if (!(this.compileUnitScope instanceof DwarfCompileUnit)) break block4;
                if (this.getCULineEntries().isEmpty()) {
                    return null;
                }
                int insertion = this.getLineEntryInsertionForAddress(desiredAddr, this.cuEntries);
                if (-1 == insertion) break block5;
                while (insertion < this.cuEntries.size()) {
                    ILineEntry next = this.cuEntries.get(insertion);
                    if (this.isGoodEntry(next, entryFn, origEntry, collapseInlineFunctions)) {
                        return next;
                    }
                    ++insertion;
                }
                break block5;
            }
            boolean firstFound = false;
            for (ILineEntry next : this.getCULineEntries()) {
                if (!firstFound && desiredAddr.compareTo((Object)next.getLowAddress()) < 0) continue;
                firstFound = true;
                if (!this.isGoodEntry(next, entryFn, origEntry, collapseInlineFunctions)) continue;
                return next;
            }
        }
        return null;
    }

    private boolean isGoodEntry(ILineEntry e, IFunctionScope origFn, ILineEntry origEntry, boolean collapseInlineFunctions) {
        IFunctionScope nextFn = this.compileUnitScope.getFunctionAtAddress(e.getLowAddress());
        if (origFn.equals(nextFn) && e.getLineNumber() != origEntry.getLineNumber()) {
            return true;
        }
        return !collapseInlineFunctions || !FileLineEntryProvider.isAncestorFunction(nextFn, origFn);
    }

    private boolean isFirstEntryInCU(ILineEntry e) throws IllegalArgumentException {
        if (e == null) {
            throw new IllegalArgumentException("isFirstEntryInCU() called with null");
        }
        int cuEntriesSize = this.getCULineEntries().size();
        return cuEntriesSize > 0 && e.equals(this.cuEntries.get(0));
    }

    private boolean isLastEntryInCU(ILineEntry e) throws IllegalArgumentException {
        if (e == null) {
            throw new IllegalArgumentException("isFirstEntryInCU() called with null");
        }
        int cuEntriesSize = this.getCULineEntries().size();
        return cuEntriesSize > 0 && e.equals(this.cuEntries.get(cuEntriesSize - 1));
    }

    @Override
    public ILineEntry getPreviousLineEntry(ILineEntry entry, boolean collapseInlineFunctions) {
        boolean prevInline;
        if (entry == null || this.isFirstEntryInCU(entry)) {
            return null;
        }
        IAddress entryAddr = entry.getLowAddress();
        IFunctionScope func = this.compileUnitScope.getFunctionAtAddress(entryAddr);
        IFunctionScope container = FileLineEntryProvider.ignoreInlineFunctions(func);
        if (container == null) {
            return null;
        }
        SortedMap<IAddress, ILineEntry> headAddrs = this.lineEntriesByAddress.headMap(entryAddr);
        if (headAddrs.isEmpty()) {
            return null;
        }
        if (!collapseInlineFunctions) {
            return this.getPreviousLineEntryByAddress(entry, container.getLowAddress(), headAddrs);
        }
        IFunctionScope prevFunc = this.compileUnitScope.getFunctionAtAddress(entryAddr);
        IFunctionScope prevContainer = FileLineEntryProvider.ignoreInlineFunctions(prevFunc);
        if (prevContainer == null || !prevContainer.equals(container)) {
            return null;
        }
        boolean inline = !func.equals(container);
        boolean bl = prevInline = !prevFunc.equals(prevContainer);
        if (inline && prevInline) {
            ILineEntry testPrev = (ILineEntry)headAddrs.get(headAddrs.lastKey());
            if (func.equals(prevFunc) || testPrev.getHighAddress().equals((Object)entryAddr) && (prevFunc.getParent().equals(func) || prevFunc.getParent().equals(func.getParent()))) {
                return testPrev;
            }
            if (!this.filePath.equals((Object)this.compileUnitScope.getFilePath())) {
                return null;
            }
        }
        SortedMap<Integer, List<ILineEntry>> headLines = inline ? this.lineEntriesByLine.headMap(((ILineEntry)headAddrs.get(headAddrs.lastKey())).getLineNumber() + 1) : this.lineEntriesByLine.headMap(entry.getLineNumber());
        while (!headLines.isEmpty()) {
            List entries = (List)headLines.get(headLines.lastKey());
            int i = entries.size() - 1;
            while (i >= 0) {
                ILineEntry prev = (ILineEntry)entries.get(i);
                if (!prev.equals(entry) && prev.getHighAddress().compareTo((Object)entryAddr) <= 0 && prev.getLowAddress().compareTo((Object)container.getLowAddress()) >= 0 && prev.getLineNumber() != entry.getLineNumber()) {
                    return prev;
                }
                --i;
            }
            headLines = headLines.headMap(headLines.lastKey());
        }
        return null;
    }

    private ILineEntry getPreviousLineEntryByAddress(ILineEntry entry, IAddress bottom, SortedMap<IAddress, ILineEntry> addrEntries) {
        while (!addrEntries.isEmpty()) {
            ILineEntry prev = (ILineEntry)addrEntries.get(addrEntries.lastKey());
            if (prev == null || prev.getLowAddress().compareTo((Object)bottom) < 0) break;
            if (prev.getLineNumber() != entry.getLineNumber()) {
                return prev;
            }
            addrEntries = addrEntries.headMap(prev.getLowAddress());
        }
        return null;
    }

    @Override
    public ILineEntry getLineEntryInFunction(IAddress linkAddress, IFunctionScope parentFunction) {
        SortedMap<IAddress, ILineEntry> subMap = this.lineEntriesByAddress.headMap(linkAddress.add(1L));
        if (subMap.isEmpty()) {
            if (parentFunction.getLowAddress().compareTo((Object)linkAddress) >= 0 && parentFunction.getHighAddress().compareTo((Object)linkAddress) < 0) {
                return this.lineEntriesByAddress.values().iterator().next();
            }
            return null;
        }
        ILineEntry entry = (ILineEntry)subMap.get(subMap.lastKey());
        if (entry.getHighAddress().compareTo((Object)linkAddress) >= 0 || subMap.size() < this.lineEntriesByAddress.size()) {
            return entry;
        }
        return null;
    }

    protected ILineEntry getPreviousLineEntryInCU(ILineEntry entry) {
        IAddress desiredEndAddress = entry.getLowAddress();
        for (ILineEntry testEntry : this.getCULineEntries()) {
            if (!desiredEndAddress.equals((Object)testEntry.getHighAddress())) continue;
            IFunctionScope entryFn = this.compileUnitScope.getFunctionAtAddress(entry.getLowAddress());
            IScope entryParent = entryFn.getParent();
            IFunctionScope prevFn = this.compileUnitScope.getFunctionAtAddress(testEntry.getLowAddress());
            if (FileLineEntryProvider.isInlinedFunction(entryFn) && (FileLineEntryProvider.isAncestorFunction(entryFn, prevFn) || entryParent != null && entryParent.equals(prevFn.getParent()))) {
                return testEntry;
            }
            FileLineEntryProvider.isAncestorFunction(prevFn, entryFn);
            break;
        }
        return null;
    }

    @Override
    public List<ILineEntryProvider.ILineAddresses> findClosestLineWithCode(IPath sourceFile, int anchorLine, int neighbor_limit) {
        int limit;
        ArrayList<ILineEntryProvider.ILineAddresses> ret = new ArrayList<ILineEntryProvider.ILineAddresses>(1);
        if (!this.filePath.setDevice(null).equals((Object)sourceFile.setDevice(null)) && !PathUtils.isCaseSensitive() && this.filePath.toOSString().compareToIgnoreCase(sourceFile.toOSString()) != 0) {
            return ret;
        }
        Modules.EDCLineAddresses codeLine = null;
        codeLine = this.getLineAddresses(anchorLine);
        if (codeLine != null) {
            ret.add(codeLine);
            return ret;
        }
        Modules.EDCLineAddresses candidate_above = null;
        if (anchorLine > this.lineEntriesByLine.firstKey()) {
            if (neighbor_limit == -1) {
                limit = this.lineEntriesByLine.firstKey();
            } else {
                limit = anchorLine - neighbor_limit;
                if (limit < this.lineEntriesByLine.firstKey()) {
                    limit = this.lineEntriesByLine.firstKey();
                }
            }
            int i = anchorLine - 1;
            while (i >= limit) {
                candidate_above = this.getLineAddresses(i);
                if (candidate_above != null) break;
                --i;
            }
        }
        Modules.EDCLineAddresses candidate_below = null;
        if (anchorLine < this.lineEntriesByLine.lastKey()) {
            if (neighbor_limit == -1) {
                limit = this.lineEntriesByLine.lastKey();
            } else {
                limit = anchorLine + neighbor_limit;
                if (limit > this.lineEntriesByLine.lastKey()) {
                    limit = this.lineEntriesByLine.lastKey();
                }
            }
            int i = anchorLine + 1;
            while (i <= limit) {
                candidate_below = this.getLineAddresses(i);
                if (candidate_below != null) break;
                ++i;
            }
        }
        if (candidate_above == null) {
            codeLine = candidate_below;
        } else if (candidate_below == null) {
            codeLine = candidate_above;
        } else {
            int distance_below;
            int distance_above = anchorLine - candidate_above.getLineNumber();
            if (distance_above == (distance_below = candidate_below.getLineNumber() - anchorLine)) {
                codeLine = candidate_below;
            } else {
                Modules.EDCLineAddresses eDCLineAddresses = codeLine = distance_above < distance_below ? candidate_above : candidate_below;
            }
        }
        if (codeLine != null) {
            ret.add(codeLine);
        }
        return ret;
    }

    private Modules.EDCLineAddresses getLineAddresses(int line) {
        if (!this.lineEntriesByLine.containsKey(line)) {
            return null;
        }
        ArrayList<IAddress> line_addrs = new ArrayList<IAddress>();
        int lastColumn = -2;
        for (ILineEntry e : this.lineEntriesByLine.get(line)) {
            int entryColumn = e.getColumnNumber();
            if (line_addrs.size() == 0 || lastColumn == entryColumn) {
                line_addrs.add(e.getLowAddress());
            }
            lastColumn = entryColumn;
        }
        return new Modules.EDCLineAddresses(line, line_addrs);
    }
}

