/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.dom.parser.cpp.semantics;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum CVQualifier {
    CONST_VOLATILE_RESTRICT(7),
    CONST_VOLATILE(3),
    CONST_RESTRICT(5),
    CONST(1),
    VOLATILE_RESTRICT(6),
    VOLATILE(2),
    RESTRICT(4),
    NONE(0);

    private static final int C = 1;
    private static final int V = 2;
    private static final int R = 4;
    private final int fQualifiers;

    private CVQualifier(int qualifiers) {
        this.fQualifiers = qualifiers;
    }

    public boolean isConst() {
        return (this.fQualifiers & 1) != 0;
    }

    public boolean isVolatile() {
        return (this.fQualifiers & 2) != 0;
    }

    public boolean isRestrict() {
        return (this.fQualifiers & 4) != 0;
    }

    public boolean isAtLeastAsQualifiedAs(CVQualifier other) {
        return (this.fQualifiers | other.fQualifiers) == this.fQualifiers;
    }

    public boolean isMoreQualifiedThan(CVQualifier other) {
        return this != other && this.isAtLeastAsQualifiedAs(other);
    }

    public CVQualifier add(CVQualifier cvq) {
        return this.fromQualifier(this.fQualifiers | cvq.fQualifiers);
    }

    public CVQualifier remove(CVQualifier cvq) {
        return this.fromQualifier(this.fQualifiers & ~cvq.fQualifiers);
    }

    private CVQualifier fromQualifier(int q) {
        switch (q) {
            case 7: {
                return CONST_VOLATILE_RESTRICT;
            }
            case 6: {
                return VOLATILE_RESTRICT;
            }
            case 5: {
                return CONST_RESTRICT;
            }
            case 4: {
                return RESTRICT;
            }
            case 3: {
                return CONST_VOLATILE;
            }
            case 2: {
                return VOLATILE;
            }
            case 1: {
                return CONST;
            }
        }
        return NONE;
    }

    public int partialComparison(CVQualifier cv2) {
        if (this == cv2) {
            return 0;
        }
        if (!this.isAtLeastAsQualifiedAs(cv2)) {
            return -1;
        }
        return this.fQualifiers - cv2.fQualifiers;
    }
}

