/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.model;

import org.eclipse.cdt.core.model.ILibraryEntry;
import org.eclipse.cdt.internal.core.model.APathEntry;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;

public class LibraryEntry
extends APathEntry
implements ILibraryEntry {
    IPath libraryPath;
    IPath sourceAttachmentPath;
    IPath sourceAttachmentRootPath;
    IPath sourceAttachmentPrefixMapping;

    public LibraryEntry(IPath resourcePath, IPath basePath, IPath baseRef, IPath libraryPath, IPath sourceAttachmentPath, IPath sourceAttachmentRootPath, IPath sourceAttachmentPrefixMapping, boolean isExported) {
        super(1, basePath, baseRef, resourcePath, APathEntry.NO_EXCLUSION_PATTERNS, isExported);
        this.libraryPath = libraryPath == null ? Path.EMPTY : libraryPath;
        this.sourceAttachmentPath = sourceAttachmentPath;
        this.sourceAttachmentRootPath = sourceAttachmentRootPath;
        this.sourceAttachmentPrefixMapping = sourceAttachmentPrefixMapping;
    }

    public IPath getSourceAttachmentPath() {
        return this.sourceAttachmentPath;
    }

    public IPath getSourceAttachmentRootPath() {
        return this.sourceAttachmentRootPath;
    }

    public IPath getSourceAttachmentPrefixMapping() {
        return this.sourceAttachmentPrefixMapping;
    }

    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + (this.libraryPath == null ? 0 : this.libraryPath.hashCode());
        result = 31 * result + (this.sourceAttachmentPath == null ? 0 : this.sourceAttachmentPath.hashCode());
        result = 31 * result + (this.sourceAttachmentRootPath == null ? 0 : this.sourceAttachmentRootPath.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (obj instanceof ILibraryEntry) {
            ILibraryEntry otherEntry = (ILibraryEntry)obj;
            if (!super.equals(obj)) {
                return false;
            }
            IPath otherPath = otherEntry.getLibraryPath();
            if (this.libraryPath == null ? otherPath != null : !this.libraryPath.equals((Object)otherPath)) {
                return false;
            }
            otherPath = otherEntry.getSourceAttachmentPath();
            if (this.sourceAttachmentPath == null ? otherPath != null : !this.sourceAttachmentPath.equals((Object)otherPath)) {
                return false;
            }
            otherPath = otherEntry.getSourceAttachmentRootPath();
            return !(this.sourceAttachmentRootPath == null ? otherPath != null : !this.sourceAttachmentRootPath.equals((Object)otherPath));
        }
        return super.equals(obj);
    }

    public IPath getFullLibraryPath() {
        IPath lib = this.getLibraryPath();
        if (!this.basePath.isEmpty()) {
            IResource res;
            IPath loc = this.basePath;
            if (!loc.isAbsolute() && (res = ResourcesPlugin.getWorkspace().getRoot().findMember(loc)) != null) {
                loc = res.getLocation();
            }
            IPath p = loc.append(lib);
            return p;
        }
        IPath p = lib;
        if (!p.isAbsolute()) {
            IPath resPath = this.getPath();
            IResource res = ResourcesPlugin.getWorkspace().getRoot().findMember(resPath);
            if (res != null) {
                IPath location;
                if (res.getType() == 1) {
                    res = res.getParent();
                }
                if ((location = res.getLocation()) != null) {
                    p = location.append(p);
                }
            }
        }
        return p;
    }

    public IPath getLibraryPath() {
        return this.libraryPath;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append(super.toString());
        if (this.libraryPath != null && !this.libraryPath.isEmpty()) {
            sb.append(" librarypath:").append(this.libraryPath.toString());
        }
        return sb.toString();
    }
}

