/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.settings.model.xml;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.cdt.core.settings.model.ICSettingsStorage;
import org.eclipse.cdt.core.settings.model.ICStorageElement;
import org.eclipse.cdt.internal.core.settings.model.ExceptionFactory;
import org.eclipse.cdt.internal.core.settings.model.xml.InternalXmlStorageElement;
import org.eclipse.cdt.internal.core.settings.model.xml.XmlStorageElement;
import org.eclipse.core.runtime.CoreException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class XmlStorage
implements ICSettingsStorage {
    public static final String MODULE_ELEMENT_NAME = "storageModule";
    public static final String MODULE_ID_ATTRIBUTE = "moduleId";
    final Object fLock;
    public Element fElement;
    private Map<String, InternalXmlStorageElement> fStorageElementMap = new HashMap<String, InternalXmlStorageElement>();
    private volatile boolean fChildrenInited;
    private boolean fIsReadOnly;
    private boolean fIsDirty;

    public XmlStorage(Element element, boolean isReadOnly) {
        this.fElement = element;
        this.fLock = element.getOwnerDocument();
        this.fIsReadOnly = isReadOnly;
    }

    public XmlStorage(InternalXmlStorageElement element) throws CoreException {
        this.fElement = element.fElement;
        this.fLock = this.fElement.getOwnerDocument();
        this.fIsReadOnly = element.isReadOnly();
        element.storageCreated(this);
        this.sanityCheck(element);
    }

    public void sanityCheck(ICStorageElement element) throws CoreException {
        if (element.getValue() != null && element.getValue().trim().length() > 0) {
            throw ExceptionFactory.createCoreException("XmlStorage '" + element.getName() + "' has unexpected child Value: " + element.getValue());
        }
        ICStorageElement[] iCStorageElementArray = element.getChildren();
        int n = iCStorageElementArray.length;
        int n2 = 0;
        while (n2 < n) {
            ICStorageElement child = iCStorageElementArray[n2];
            if (!MODULE_ELEMENT_NAME.equals(child.getName())) {
                throw ExceptionFactory.createCoreException("XmlStorage '" + element.getName() + "' has unexpected child element: " + child.getName());
            }
            if (child.getAttribute(MODULE_ID_ATTRIBUTE) == null) {
                throw ExceptionFactory.createCoreException("XmlStorage '" + element.getName() + "' has storageModule child without moduleId");
            }
            ++n2;
        }
    }

    public boolean isReadOnly() {
        return this.fIsReadOnly;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initChildren() {
        if (this.fChildrenInited) {
            return;
        }
        Object object = this.fLock;
        synchronized (object) {
            if (this.fChildrenInited) {
                return;
            }
            NodeList children = this.fElement.getChildNodes();
            int size = children.getLength();
            int i = 0;
            while (i < size) {
                Element element;
                String moduleId;
                Node node = children.item(i);
                if (node.getNodeType() == 1 && MODULE_ELEMENT_NAME.equals(node.getNodeName()) && (moduleId = (element = (Element)node).getAttribute(MODULE_ID_ATTRIBUTE).trim()).length() != 0) {
                    this.createAddStorageElement(moduleId, element);
                }
                ++i;
            }
            this.fChildrenInited = true;
        }
    }

    private InternalXmlStorageElement createAddStorageElement(String id, Element element) {
        InternalXmlStorageElement se = XmlStorage.createStorageElement(element, this.fIsReadOnly);
        this.fStorageElementMap.put(id, se);
        return se;
    }

    public static InternalXmlStorageElement createStorageElement(Element el, boolean isReadOnly) {
        return new InternalXmlStorageElement(el, null, new String[]{MODULE_ID_ATTRIBUTE}, null, isReadOnly);
    }

    public boolean containsStorage(String id) throws CoreException {
        return this.getStorage(id, false) != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ICStorageElement importStorage(String id, ICStorageElement el) throws UnsupportedOperationException {
        if (this.fIsReadOnly) {
            throw ExceptionFactory.createIsReadOnlyException();
        }
        this.removeStorage(id);
        Object object = this.fLock;
        synchronized (object) {
            Document thisDoc = this.fElement.getOwnerDocument();
            Element newEl = thisDoc.createElement(MODULE_ELEMENT_NAME);
            this.fIsDirty = true;
            if (el instanceof XmlStorageElement) {
                XmlStorageElement xmlStEl = (XmlStorageElement)el;
                Object object2 = xmlStEl.fLock;
                synchronized (object2) {
                    Element xmlEl = xmlStEl.fElement;
                    Document otherDoc = xmlEl.getOwnerDocument();
                    if (!thisDoc.equals(otherDoc)) {
                        xmlEl = (Element)thisDoc.importNode(xmlEl, true);
                    }
                    NodeList nl = xmlEl.getChildNodes();
                    int i = 0;
                    while (i < nl.getLength()) {
                        Node child = nl.item(i).cloneNode(true);
                        newEl.appendChild(child);
                        ++i;
                    }
                    newEl = (Element)this.fElement.appendChild(newEl);
                    newEl.setAttribute(MODULE_ID_ATTRIBUTE, id);
                    return this.createAddStorageElement(id, newEl);
                }
            }
            ICStorageElement storageEl = this.getStorage(id, true);
            Object[] objectArray = el.getAttributeNames();
            int n = objectArray.length;
            int n2 = 0;
            while (n2 < n) {
                String attrName = objectArray[n2];
                storageEl.setAttribute(attrName, el.getAttribute(attrName));
                ++n2;
            }
            objectArray = el.getChildren();
            n = objectArray.length;
            n2 = 0;
            while (n2 < n) {
                Object child = objectArray[n2];
                storageEl.importChild((ICStorageElement)child);
                ++n2;
            }
            return storageEl;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ICStorageElement getStorage(String id, boolean create) {
        this.initChildren();
        InternalXmlStorageElement se = this.fStorageElementMap.get(id);
        if (se == null && create) {
            this.fIsDirty = true;
            Object object = this.fLock;
            synchronized (object) {
                Document doc = this.fElement.getOwnerDocument();
                Element child = XmlStorage.createStorageXmlElement(doc, id);
                this.fElement.appendChild(child);
                se = this.createAddStorageElement(id, child);
            }
        }
        return se;
    }

    public static Element createStorageXmlElement(Document doc, String storageId) {
        Element child = doc.createElement(MODULE_ELEMENT_NAME);
        child.setAttribute(MODULE_ID_ATTRIBUTE, storageId);
        return child;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeStorage(String id) {
        this.initChildren();
        InternalXmlStorageElement se = this.fStorageElementMap.remove(id);
        if (se != null) {
            if (this.fIsReadOnly) {
                throw ExceptionFactory.createIsReadOnlyException();
            }
            Object object = this.fLock;
            synchronized (object) {
                Object object2 = se.fLock;
                synchronized (object2) {
                    String value;
                    this.fIsDirty = true;
                    Node nextSibling = se.fElement.getNextSibling();
                    this.fElement.removeChild(se.fElement);
                    if (nextSibling != null && nextSibling.getNodeType() == 3 && (value = nextSibling.getNodeValue()) != null && value.trim().length() == 0) {
                        this.fElement.removeChild(nextSibling);
                    }
                }
            }
        }
    }

    public boolean isModified() {
        if (this.fIsDirty) {
            return true;
        }
        for (InternalXmlStorageElement el : this.fStorageElementMap.values()) {
            if (!el.isModified()) continue;
            return true;
        }
        return false;
    }

    public void setReadOnly(boolean readOnly, boolean keepModify) {
        this.fIsReadOnly = readOnly;
        this.fIsDirty &= keepModify;
        for (InternalXmlStorageElement el : this.fStorageElementMap.values()) {
            el.setReadOnly(readOnly, keepModify);
        }
    }

    public void setDirty(boolean isDirty) {
        this.fIsDirty = isDirty;
        if (!this.fIsDirty) {
            for (InternalXmlStorageElement el : this.fStorageElementMap.values()) {
                el.setDirty(false);
            }
        }
    }

    public void save() throws CoreException {
        throw new UnsupportedOperationException();
    }
}

