/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.sdb.command;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import org.json.simple.parser.ParseException;
import org.tizen.sdb.Buffer;
import org.tizen.sdb.Channel;
import org.tizen.sdb.CommandRequest;
import org.tizen.sdb.CommandResponse;
import org.tizen.sdb.command.receiver.OutputReceiver;
import org.tizen.sdb.item.DeviceItem;

public class Command {
    protected static String UTF_DECODING = "UTF-8";
    private CommandRequest request = new CommandRequest();
    private CommandResponse response;

    public Command(String command) {
        this.request.setCommand(command);
    }

    public void addParameter(String parameter) {
        this.request.addParameter(parameter);
    }

    public void addExtraOption(String option) {
        this.request.addExtraOption(option);
    }

    public String getCommnad() {
        return this.request.getCommand();
    }

    public void execute(DeviceItem device, OutputReceiver receiver) throws IOException {
        this.execute(device == null ? "" : device.getSerial(), receiver);
    }

    public void execute(String deviceSerial, OutputReceiver receiver) throws IOException {
        Channel channel = new Channel();
        channel.connect();
        this.request.setTarget(deviceSerial);
        this.sendRequest(channel);
        this.receiveResponse(channel, receiver);
        channel.close();
        if (receiver != null) {
            receiver.close();
        }
    }

    protected void receiveResponse(Channel channel, OutputReceiver receiver) throws IOException {
        CommandResponse response;
        block10: while (true) {
            if (!channel.isConnected()) {
                throw new IOException();
            }
            Buffer buffer = channel.read();
            if (buffer == null) {
                throw new IOException();
            }
            if (buffer.getType() == Buffer.BufferType.DATA) {
                int length = buffer.getLength();
                if (length <= 0 || receiver == null) continue;
                ByteArrayOutputStream byteOut = new ByteArrayOutputStream();
                byteOut.write(buffer.get(), 0, length);
                try {
                    receiver.append(new String(byteOut.toByteArray(), UTF_DECODING));
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    throw new IOException();
                }
            }
            response = null;
            try {
                response = new CommandResponse(new String(buffer.get(), UTF_DECODING));
            }
            catch (ParseException e) {
                e.printStackTrace();
                response = new CommandResponse();
            }
            int code = response.getStatusCode();
            switch (code) {
                case 204: {
                    if (receiver == null) continue block10;
                    receiver.append("\rpulled \t" + response.getResult() + "\t");
                    continue block10;
                }
                case 201: {
                    if (receiver == null) continue block10;
                    receiver.append("\rpushed \t" + response.getResult() + "\t");
                    continue block10;
                }
                case 202: {
                    if (receiver == null) continue block10;
                    receiver.append("\n");
                    continue block10;
                }
                case 205: {
                    if (receiver == null) continue block10;
                    receiver.append("\n" + response.getResult() + "\n");
                    continue block10;
                }
            }
            break;
        }
        this.setResponse(response);
        if (receiver != null) {
            receiver.append(response.getResult());
        }
    }

    protected void sendRequest(Channel channel) {
        String json = this.request.makeJson();
        if (!channel.writeCommand(json)) {
            System.out.println("Error: failed to send command to server");
        }
    }

    public CommandResponse getResponse() {
        return this.response;
    }

    protected void setResponse(CommandResponse response) {
        this.response = response;
    }
}

