/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.dynamicanalyzer.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.channels.FileChannel;
import java.util.ArrayList;
import java.util.List;
import org.tizen.dynamicanalyzer.util.CommonUtil;
import org.tizen.dynamicanalyzer.util.Logger;

public class FileUtil {
    public static boolean deleteFile(File file) {
        String[] children;
        if (file.isDirectory() && (children = file.list()) != null) {
            int i = 0;
            while (i < children.length) {
                boolean success = FileUtil.deleteFile(new File(file, children[i]));
                if (!success) {
                    return false;
                }
                ++i;
            }
        }
        return file.delete();
    }

    public static List<String> getFilesInDir(String dirPath) {
        File dir = new File(dirPath);
        if (!dir.isDirectory()) {
            return null;
        }
        String[] fileList = dir.list();
        ArrayList<String> list = new ArrayList<String>();
        if (fileList != null) {
            int fileListLength = fileList.length;
            int i = 0;
            while (i < fileListLength) {
                File file = new File(String.valueOf(dirPath) + File.separator + fileList[i]);
                if (!file.isDirectory()) {
                    list.add(fileList[i]);
                }
                ++i;
            }
        }
        return list;
    }

    private static String convertGlobToRegex(String pattern) {
        StringBuilder sb = new StringBuilder(pattern.length());
        int inGroup = 0;
        int inClass = 0;
        int firstIndexInClass = -1;
        char[] arr = pattern.toCharArray();
        int i = 0;
        while (i < arr.length) {
            char ch = arr[i];
            switch (ch) {
                case '\\': {
                    if (++i >= arr.length) {
                        sb.append('\\');
                        break;
                    }
                    char next = arr[i];
                    switch (next) {
                        case ',': {
                            break;
                        }
                        case 'E': 
                        case 'Q': {
                            sb.append('\\');
                            sb.append('\\');
                            break;
                        }
                        default: {
                            sb.append('\\');
                        }
                    }
                    sb.append(next);
                    break;
                }
                case '*': {
                    if (inClass == 0) {
                        sb.append(".*");
                        break;
                    }
                    sb.append('*');
                    break;
                }
                case '?': {
                    if (inClass == 0) {
                        sb.append('.');
                        break;
                    }
                    sb.append('?');
                    break;
                }
                case '[': {
                    ++inClass;
                    firstIndexInClass = i + 1;
                    sb.append('[');
                    break;
                }
                case ']': {
                    --inClass;
                    sb.append(']');
                    break;
                }
                case '$': 
                case '%': 
                case '(': 
                case ')': 
                case '+': 
                case '.': 
                case '@': 
                case '^': 
                case '|': {
                    if (inClass == 0 || firstIndexInClass == i && ch == '^') {
                        sb.append('\\');
                    }
                    sb.append(ch);
                    break;
                }
                case '!': {
                    if (firstIndexInClass == i) {
                        sb.append('^');
                        break;
                    }
                    sb.append('!');
                    break;
                }
                case '{': {
                    ++inGroup;
                    sb.append('(');
                    break;
                }
                case '}': {
                    --inGroup;
                    sb.append(')');
                    break;
                }
                case ',': {
                    if (inGroup > 0) {
                        sb.append('|');
                        break;
                    }
                    sb.append(',');
                    break;
                }
                default: {
                    sb.append(ch);
                }
            }
            ++i;
        }
        return sb.toString();
    }

    private static void findFileRecursive(File rootPath, String regex, boolean recursive, boolean isFile, List<String> result) throws FileNotFoundException, IOException {
        File[] filesAndDirs = rootPath.listFiles();
        if (filesAndDirs == null) {
            return;
        }
        File[] fileArray = filesAndDirs;
        int n = filesAndDirs.length;
        int n2 = 0;
        while (n2 < n) {
            File file = fileArray[n2];
            if (file.isFile()) {
                if (isFile && file.getName().matches(regex)) {
                    result.add(file.getCanonicalPath());
                }
            } else {
                if (!isFile && file.getName().matches(regex)) {
                    result.add(file.getCanonicalPath());
                }
                if (recursive) {
                    FileUtil.findFileRecursive(file, regex, recursive, isFile, result);
                }
            }
            ++n2;
        }
    }

    public static List<String> findFilesInDir(String dirPath, String fileToken, boolean isFile) {
        ArrayList<String> resultFiles = new ArrayList<String>();
        String regex = FileUtil.convertGlobToRegex(fileToken);
        File startingDir = new File(dirPath);
        if (startingDir.exists()) {
            try {
                FileUtil.findFileRecursive(startingDir, regex, true, isFile, resultFiles);
            }
            catch (FileNotFoundException e) {
                Logger.exception(e);
            }
            catch (IOException e) {
                Logger.exception(e);
            }
        }
        return resultFiles;
    }

    public static String copyFileToDir(String src, String destDir) throws IOException {
        File srcfile = new File(src);
        if (srcfile.isFile()) {
            String srcfilename = srcfile.getName();
            String dest = destDir.endsWith(File.separator) ? String.valueOf(destDir) + srcfilename : String.valueOf(destDir) + File.separator + srcfilename;
            File destfile = new File(dest);
            if (srcfile.getCanonicalPath().equals(destfile.getCanonicalPath())) {
                throw new IOException("File copy error. Destination directory is the parent directory of source file");
            }
            File destdir = new File(destDir);
            if (!destdir.exists() && !destdir.mkdirs()) {
                throw new IOException("File copy error. Cannot create directory - " + destdir.getAbsolutePath());
            }
            FileUtil.copyFile(srcfile, destfile);
            return dest;
        }
        return null;
    }

    public static void copyFile(File source, File dest) throws IOException {
        FileChannel inputChannel = null;
        FileChannel outputChannel = null;
        try {
            inputChannel = new FileInputStream(source).getChannel();
            outputChannel = new FileOutputStream(dest).getChannel();
            outputChannel.transferFrom(inputChannel, 0L, inputChannel.size());
        }
        catch (Throwable throwable) {
            CommonUtil.tryClose(inputChannel, outputChannel);
            throw throwable;
        }
        CommonUtil.tryClose(inputChannel, outputChannel);
    }
}

