/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.dynamicanalyzer.project;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.tizen.dynamicanalyzer.collection.IndexedHashMap;
import org.tizen.dynamicanalyzer.constant.CommonConstants;
import org.tizen.dynamicanalyzer.database.DBTable;
import org.tizen.dynamicanalyzer.project.BinaryInfo;
import org.tizen.dynamicanalyzer.util.Logger;

public class DeviceStatusInfo {
    private static final String SYSMEM = "SystemMemory";
    private static final String STORAGE = "StorageSize";
    private static final String BLUETOOTH = "BluetoothSupport";
    private static final String GPS = "GpsSupport";
    private static final String WIFI = "WifiSupport";
    private static final String CAMERA = "CameraCount";
    private static final String NETWORK = "NetworkType";
    private static final String BRIGHTNESS = "MaxBrightness";
    private static final String CORECOUNT = "CpuCoreCount";
    private static final String DEVICECOUNT = "DeviceCount";
    private static final String DEVICES = "Devices";
    private long systemMemorySize = 0L;
    private long storageSize = 0L;
    private int bluetoothSupport = -1;
    private int gpsSupport = -1;
    private int wifiSupport = -1;
    private int cameraCount = 0;
    private String networkType = null;
    private int maxBrightness = 0;
    private int cpuCount = 0;
    private int deviceCount = 0;
    private String devices = null;
    private Map<Integer, String> apiNameMap = null;
    private IndexedHashMap<String, BinaryInfo> binaryInfos = new IndexedHashMap();

    public long getSystemMemorySize() {
        return this.systemMemorySize;
    }

    public void setSystemMemorySize(long systemMemorySize) {
        this.systemMemorySize = systemMemorySize;
    }

    public long getStorageSize() {
        return this.storageSize;
    }

    public void setStorageSize(long storageSize) {
        this.storageSize = storageSize;
    }

    public int getBluetoothSupport() {
        return this.bluetoothSupport;
    }

    public void setBluetoothSupport(int bluetoothSupport) {
        this.bluetoothSupport = bluetoothSupport;
    }

    public int getGpsSupport() {
        return this.gpsSupport;
    }

    public void setGpsSupport(int gpsSupport) {
        this.gpsSupport = gpsSupport;
    }

    public int getWifiSupport() {
        return this.wifiSupport;
    }

    public void setWifiSupport(int wifiSupport) {
        this.wifiSupport = wifiSupport;
    }

    public int getCameraCount() {
        return this.cameraCount;
    }

    public void setCameraCount(int cameraCount) {
        this.cameraCount = cameraCount;
    }

    public String getNetworkType() {
        return this.networkType;
    }

    public void setNetworkType(String networkType) {
        this.networkType = networkType;
    }

    public int getMaxBrightness() {
        return this.maxBrightness;
    }

    public void setMaxBrightness(int maxBrightness) {
        this.maxBrightness = maxBrightness;
    }

    public int getCpuCount() {
        return this.cpuCount;
    }

    public void setCpuCount(int cpuCount) {
        this.cpuCount = cpuCount;
    }

    public int getDeviceCount() {
        return this.deviceCount;
    }

    public void setDeviceCount(int deviceCount) {
        this.deviceCount = deviceCount;
    }

    public String getDevices() {
        return this.devices;
    }

    public void setDevices(String devices) {
        this.devices = devices;
    }

    public void savePrimitive(BufferedWriter writer) throws IOException {
        writer.write("SystemMemory=" + this.getSystemMemorySize() + CommonConstants.NEW_LINE);
        writer.write("StorageSize=" + this.getStorageSize() + CommonConstants.NEW_LINE);
        writer.write("BluetoothSupport=" + this.getBluetoothSupport() + CommonConstants.NEW_LINE);
        writer.write("GpsSupport=" + this.getGpsSupport() + CommonConstants.NEW_LINE);
        writer.write("WifiSupport=" + this.getWifiSupport() + CommonConstants.NEW_LINE);
        writer.write("CameraCount=" + this.getCameraCount() + CommonConstants.NEW_LINE);
        writer.write("NetworkType=" + this.getNetworkType() + CommonConstants.NEW_LINE);
        writer.write("MaxBrightness=" + this.getMaxBrightness() + CommonConstants.NEW_LINE);
        writer.write("CpuCoreCount=" + this.getCpuCount() + CommonConstants.NEW_LINE);
        writer.write("DeviceCount=" + this.getDeviceCount() + CommonConstants.NEW_LINE);
        writer.write("Devices=" + this.getDevices() + CommonConstants.NEW_LINE);
    }

    public void openPrimitive(BufferedReader in) throws IOException {
        String content;
        while ((content = in.readLine()) != null) {
            if (content.trim().isEmpty()) break;
            String[] splitData = content.split("=");
            if (2 != splitData.length) continue;
            String infoKey = splitData[0];
            String val = splitData[1];
            if (infoKey.equals(SYSMEM)) {
                this.setSystemMemorySize(Long.parseLong(val));
                continue;
            }
            if (infoKey.equals(STORAGE)) {
                this.setStorageSize(Long.parseLong(val));
                continue;
            }
            if (infoKey.equals(BLUETOOTH)) {
                this.setBluetoothSupport(Integer.parseInt(val));
                continue;
            }
            if (infoKey.equals(GPS)) {
                this.setGpsSupport(Integer.parseInt(val));
                continue;
            }
            if (infoKey.equals(WIFI)) {
                this.setWifiSupport(Integer.parseInt(val));
                continue;
            }
            if (infoKey.equals(CAMERA)) {
                this.setCameraCount(Integer.parseInt(val));
                continue;
            }
            if (infoKey.equals(NETWORK)) {
                this.setNetworkType(val);
                continue;
            }
            if (infoKey.equals(BRIGHTNESS)) {
                this.setMaxBrightness(Integer.parseInt(val));
                continue;
            }
            if (infoKey.equals(CORECOUNT)) {
                this.setCpuCount(Integer.parseInt(val));
                continue;
            }
            if (infoKey.equals(DEVICECOUNT)) {
                this.setDeviceCount(Integer.parseInt(val));
                continue;
            }
            if (!infoKey.equals(DEVICES)) continue;
            this.setDevices(val);
        }
    }

    @Deprecated
    public void loadSaveFormat(List<String> info) {
        this.systemMemorySize = Long.parseLong(info.get(0));
        this.storageSize = Long.parseLong(info.get(1));
        this.bluetoothSupport = Integer.parseInt(info.get(2));
        this.gpsSupport = Integer.parseInt(info.get(3));
        this.wifiSupport = Integer.parseInt(info.get(4));
        this.cameraCount = Integer.parseInt(info.get(5));
        this.networkType = info.get(6);
        this.maxBrightness = Integer.parseInt(info.get(7));
        this.cpuCount = Integer.parseInt(info.get(8));
        this.deviceCount = Integer.parseInt(info.get(9));
        this.devices = info.get(10);
    }

    public Map<Integer, String> getApiNameMap() {
        if (this.apiNameMap != null) {
            return Collections.unmodifiableMap(this.apiNameMap);
        }
        return null;
    }

    public void setApiNameMap(Map<Integer, String> functionMap) {
        this.apiNameMap = functionMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BinaryInfo getBinaryInfo(String targetpath) {
        BinaryInfo binInfo = this.binaryInfos.getByKey(targetpath);
        if (binInfo == null) {
            binInfo = new BinaryInfo(targetpath);
            IndexedHashMap<String, BinaryInfo> indexedHashMap = this.binaryInfos;
            synchronized (indexedHashMap) {
                this.binaryInfos.put(targetpath, binInfo);
            }
        }
        return binInfo;
    }

    public BinaryInfo getBinaryInfo(int binaryID) {
        return this.binaryInfos.getByIndex(binaryID);
    }

    public BinaryInfo getBinaryInfoByName(String name) {
        return null;
    }

    public void saveBinaryInfo(DBTable table) {
        ArrayList<List<Object>> datas = new ArrayList<List<Object>>();
        List<BinaryInfo> binaryInfoArray = this.binaryInfos.getDataArray();
        int size = binaryInfoArray.size();
        int i = 0;
        while (i < size) {
            ArrayList<Object> data = new ArrayList<Object>();
            BinaryInfo binfo = binaryInfoArray.get(i);
            data.add(i);
            data.add(binfo.getType());
            data.add(binfo.getTargetBinaryPath());
            data.add(binfo.getTempBinaryPath());
            data.add(binfo.getMd5sumValue());
            datas.add(data);
            ++i;
        }
        table.insertData(datas);
    }

    public void openBinaryInfo(DBTable table) {
        List<List<Object>> datas = table.selectAllColumnData(null);
        ArrayList<String> keylist = new ArrayList<String>();
        ArrayList<BinaryInfo> valuelist = new ArrayList<BinaryInfo>();
        int maxindex = -1;
        int rowsize = datas.size();
        int i = 0;
        while (i < rowsize) {
            List<Object> data = datas.get(i);
            int id = (Integer)data.get(0);
            int type = (Integer)data.get(1);
            String targetpath = (String)data.get(2);
            String temppath = (String)data.get(3);
            String md5sum = (String)data.get(4);
            BinaryInfo binfo = new BinaryInfo(targetpath);
            binfo.setID(id);
            binfo.setType(type);
            binfo.setTempBinaryPath(temppath);
            binfo.setMd5sumValue(md5sum);
            keylist.add(targetpath);
            valuelist.add(binfo);
            if (maxindex < id) {
                maxindex = id;
            }
            ++i;
        }
        if (!this.binaryInfos.buildFrom(keylist, valuelist, maxindex)) {
            Logger.error((Object)"failed to build binary info map");
        }
    }
}

