/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.dynamicanalyzer.ui.network;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.eclipse.swt.graphics.Color;
import org.tizen.dynamicanalyzer.common.Global;
import org.tizen.dynamicanalyzer.nl.NetworkPageLabels;
import org.tizen.dynamicanalyzer.resources.ColorResources;
import org.tizen.dynamicanalyzer.ui.network.data.NetworkDataManager;
import org.tizen.dynamicanalyzer.ui.network.data.StatusSeriesListSortComparator;
import org.tizen.dynamicanalyzer.ui.network.data.type.NetworkAPIType;
import org.tizen.dynamicanalyzer.ui.network.data.type.NetworkSeriesType;
import org.tizen.dynamicanalyzer.widgets.chart.DAChart;
import org.tizen.dynamicanalyzer.widgets.chart.DAChartSeries;
import org.tizen.dynamicanalyzer.widgets.chart.DAChartSeriesItem;
import org.tizen.dynamicanalyzer.widgets.chartBoard.DAChartBoardItem;

public class NetworkChart {
    protected DAChartBoardItem item;
    protected DAChart chart;
    private List<NetworkChart> children = new ArrayList<NetworkChart>();
    private DAChartSeries statusSeries;
    private DAChartSeries apiSeries;
    private DAChartSeries accessSeries;
    private String chartName = "";
    private String destinationAddress = "";
    private String fdValue = "";
    private int parentChartIndex = -1;
    private int childChartIndex = -1;
    private int pId = -1;

    public NetworkChart(String chartName, String destinationAddress, String fdValue, DAChartBoardItem item, DAChart chart, int parentChartIndex, int childChartIndex) {
        this.setChartName(chartName);
        this.setDestinationAddress(destinationAddress);
        this.setFdValue(fdValue);
        this.setItem(item);
        this.setChart(chart);
        this.setParentChartIndex(parentChartIndex);
        this.setChildChartIndex(childChartIndex);
    }

    public String getChartName() {
        return this.chartName.trim();
    }

    public void setChartName(String chartName) {
        this.chartName = chartName;
    }

    public String getDestinationAddress() {
        return this.destinationAddress.trim();
    }

    public void setDestinationAddress(String destinationAddress) {
        this.destinationAddress = destinationAddress;
    }

    public String getFdValue() {
        return this.fdValue.trim();
    }

    public void setFdValue(String fdValue) {
        this.fdValue = fdValue;
    }

    public boolean isParentChartRow() {
        return this.children.size() > 0;
    }

    public void pushChild(NetworkChart data) {
        this.children.add(data);
    }

    public void setItem(DAChartBoardItem item) {
        this.item = item;
        this.setChart(item.getChart());
        this.apiSeries = this.chart.getSeries(NetworkPageLabels.NETWORK_CHART_API);
        this.accessSeries = this.chart.getSeries(NetworkPageLabels.NETWORK_CHART_ACCESS);
        this.statusSeries = this.chart.getSeries(NetworkPageLabels.NETWORK_CHART_SERIES);
    }

    public DAChartBoardItem getItem() {
        return this.item;
    }

    public DAChart getChart() {
        return this.chart;
    }

    public void setChart(DAChart chart) {
        this.chart = chart;
    }

    public void clearSeries() {
        this.apiSeries.clear();
        this.statusSeries.clear();
    }

    public void updateApiSeries(List<NetworkAPIType> apiList) {
        int i = 0;
        while (i < apiList.size()) {
            if (this.getDestinationAddress().equals(apiList.get(i).getDestinationAddress()) && (this.isParentChartRow() || this.getFdValue().equals(apiList.get(i).getFdStr()))) {
                NetworkAPIType data = apiList.get(i);
                DAChartSeriesItem seriesItem = null;
                double time = this.getConvertTime(data.getTime());
                Color color = ColorResources.NETWORK_API_USED;
                String apiName = Global.getFunctionName(data.getApiId());
                if (data.getErrno() != 0L) {
                    color = ColorResources.NETWORK_API_FAILED;
                }
                seriesItem = new DAChartSeriesItem(time, 0.0, color, apiName);
                this.apiSeries.addSeriesItem(seriesItem);
                if (!this.isParentChartRow() && data.getErrno() != 0L) {
                    this.setChartIndexOfSeq(data.getSeq());
                }
            }
            ++i;
        }
        this.chart.redraw();
    }

    private void setChartIndexOfSeq(long seq) {
        NetworkDataManager.getInstance().setParentIndexOfSeq(seq, this.getParentChartIndex());
        NetworkDataManager.getInstance().setChildIndexOfSeq(seq, this.getChildChartIndex());
    }

    private void sortStatusSeriesByStartTime(List<NetworkSeriesType> statusList) {
        Collections.sort(statusList, new StatusSeriesListSortComparator());
    }

    public void updateParentChartStatusSeries(List<NetworkSeriesType> statusList) {
        if (statusList.size() == 0) {
            return;
        }
        boolean isFirstChildChart = true;
        NetworkSeriesType data = null;
        ConcurrentHashMap<Double, Double> statusRangeHashMap = new ConcurrentHashMap<Double, Double>();
        int i = 0;
        while (i < statusList.size()) {
            if (this.getDestinationAddress().equals(statusList.get(i).getDestinationAddress()) && !this.isAccessEvent((data = statusList.get(i)).getAPIType())) {
                double startTime = this.getConvertTime(data.getStartTime());
                double endTime = this.getConvertTime(data.getEndTime());
                if (isFirstChildChart) {
                    statusRangeHashMap.put(startTime, endTime);
                    isFirstChildChart = false;
                } else {
                    this.setParentStatusSeriesRangeData(statusRangeHashMap, startTime, endTime);
                }
            }
            ++i;
        }
        this.addSeriesItemAtParentChartStatusSeries(statusRangeHashMap);
    }

    private void addSeriesItemAtParentChartStatusSeries(ConcurrentHashMap<Double, Double> statuesRangeHashMap) {
        for (Map.Entry<Double, Double> e : statuesRangeHashMap.entrySet()) {
            double start = e.getKey();
            double end = e.getValue();
            this.addSeriesItemAtParentChartStatusSeries(start, end);
        }
        this.chart.redraw();
    }

    private void setParentStatusSeriesRangeData(ConcurrentHashMap<Double, Double> statuesRangeHashMap, double startTime, double endTime) {
        for (Map.Entry<Double, Double> e : statuesRangeHashMap.entrySet()) {
            double start = e.getKey();
            double end = e.getValue();
            if (start < startTime && startTime <= end) {
                e.setValue(endTime);
            }
            if (!(end < startTime)) continue;
            statuesRangeHashMap.put(startTime, endTime);
        }
    }

    private void addSeriesItemAtParentChartStatusSeries(double startTime, double endTime) {
        double openTimeOfNotClosed = 9.99999999E8;
        if (startTime < openTimeOfNotClosed && 0.0 < endTime) {
            this.updateStateSeriesToClose(startTime, endTime);
        } else {
            DAChartSeriesItem seriesItem = new DAChartSeriesItem(startTime, 1.0, ColorResources.NETWORK_AREA_FD_USED_END, ColorResources.NETWORK_AREA_FD_USED_START, NetworkPageLabels.NETWORK_CHART_TOOLTIP_FD_OPEND);
            this.statusSeries.addSeriesItem(seriesItem);
        }
    }

    private void updateStateSeriesToClose(double startTime, double endTime) {
        DAChartSeriesItem seriesItem = new DAChartSeriesItem(startTime, 1.0, ColorResources.NETWORK_AREA_CLOSED_END, ColorResources.NETWORK_AREA_CLOSED_START, NetworkPageLabels.NETWORK_CHART_TOOLTIP_CLOSED);
        this.statusSeries.addSeriesItem(seriesItem);
        DAChartSeriesItem endSeriesItem = new DAChartSeriesItem(endTime, 0.0, ColorResources.NETWORK_AREA_CLOSED_END, ColorResources.NETWORK_AREA_CLOSED_START, NetworkPageLabels.NETWORK_CHART_TOOLTIP_CLOSED);
        seriesItem.setBarWidth(0.0);
        this.statusSeries.addSeriesItem(endSeriesItem);
        this.chart.redraw();
    }

    public void updateStatusSeries(List<NetworkSeriesType> statusList) {
        if (this.isParentChartRow()) {
            this.sortStatusSeriesByStartTime(statusList);
            this.updateParentChartStatusSeries(statusList);
            return;
        }
        if (statusList.size() == 0) {
            return;
        }
        NetworkSeriesType data = null;
        int i = 0;
        while (i < statusList.size()) {
            data = statusList.get(i);
            if (data != null && this.getDestinationAddress().equals(data.getDestinationAddress()) && this.getFdValue().equals(data.getFdValue()) && !this.isAccessEvent(data.getAPIType())) {
                this.addStatusItem(data);
            }
            ++i;
        }
        this.chart.redraw();
    }

    private void addStatusItem(NetworkSeriesType data) {
        double startTime = this.getConvertTime(data.getStartTime());
        double endTime = this.getConvertTime(data.getEndTime());
        this.addOpenStatus(startTime);
        if (endTime > 0.0) {
            this.addCloseStatus(endTime);
        }
    }

    private void addOpenStatus(double startTime) {
        DAChartSeriesItem seriesItem = new DAChartSeriesItem(startTime, 1.0, ColorResources.NETWORK_AREA_FD_USED_END, ColorResources.NETWORK_AREA_FD_USED_START, NetworkPageLabels.NETWORK_CHART_TOOLTIP_FD_OPEND);
        this.statusSeries.addSeriesItem(seriesItem);
    }

    private void addCloseStatus(double endTime) {
        int nStatusLastIndex = this.statusSeries.getSeriesItemList().size() - 1;
        DAChartSeriesItem lastSeriesItem = (DAChartSeriesItem)this.statusSeries.getSeriesItemList().get(nStatusLastIndex);
        lastSeriesItem.setColor(ColorResources.NETWORK_AREA_CLOSED_END);
        lastSeriesItem.setGradationForegroundColor(ColorResources.NETWORK_AREA_CLOSED_START);
        lastSeriesItem.setTooltipText(NetworkPageLabels.NETWORK_CHART_TOOLTIP_CLOSED);
        DAChartSeriesItem endSeriesItem = new DAChartSeriesItem(endTime, 0.0, ColorResources.NETWORK_AREA_CLOSED_END, ColorResources.NETWORK_AREA_CLOSED_START, NetworkPageLabels.NETWORK_CHART_TOOLTIP_CLOSED);
        endSeriesItem.setBarWidth(0.0);
        this.statusSeries.addSeriesItem(endSeriesItem);
    }

    public void updateAccessSeries(List<NetworkSeriesType> accessList) {
        NetworkSeriesType data = null;
        double startTime = -1.0;
        double endTime = -1.0;
        int i = 0;
        while (i < accessList.size()) {
            if (this.getDestinationAddress().equals(accessList.get(i).getDestinationAddress()) && (this.isParentChartRow() || this.getFdValue().equals(accessList.get(i).getFdValue())) && (data = accessList.get(i)) != null && this.isAccessEvent(data.getAPIType())) {
                startTime = this.getConvertTime(data.getStartTime());
                endTime = this.getConvertTime(data.getEndTime());
                DAChartSeriesItem seriesItem = new DAChartSeriesItem(startTime, endTime, this.getAccessSeriesColor(data.getAPIType()), Global.getFunctionName(data.getApiID()));
                this.accessSeries.addSeriesItem(seriesItem);
                startTime = -1.0;
                endTime = -1.0;
            }
            ++i;
        }
        this.chart.redraw();
    }

    private Color getAccessSeriesColor(int status) {
        if (status == 4) {
            return ColorResources.NETWORK_ACCESS_SEND;
        }
        if (status == 3) {
            return ColorResources.NETWORK_ACCESS_RECV;
        }
        return ColorResources.NETWORK_ACCESS_WAIT;
    }

    private double getConvertTime(double logTime) {
        return logTime / 1000000.0;
    }

    private boolean isAccessEvent(int apiType) {
        return apiType == 2 || apiType == 3 || apiType == 4;
    }

    public int getParentChartIndex() {
        return this.parentChartIndex;
    }

    public void setParentChartIndex(int parentChartIndex) {
        this.parentChartIndex = parentChartIndex;
    }

    public int getChildChartIndex() {
        return this.childChartIndex;
    }

    public void setChildChartIndex(int childChartIndex) {
        this.childChartIndex = childChartIndex;
    }

    public int getpId() {
        return this.pId;
    }

    public void setpId(int pId) {
        this.pId = pId;
    }
}

