/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.dynamicanalyzer.ui.notification;

import java.util.ArrayList;
import java.util.ListIterator;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.tizen.dynamicanalyzer.util.WorkbenchUtil;
import org.tizen.dynamicanalyzer.widgets.notification.DAPopupNotification;

public class NotificationManager {
    private static final int MAX_NOTIFICATIONS_CAPACITY = 3;
    private static final int VERTICAL_SPACING = 10;
    private static ArrayList<DAPopupNotification> notifications = new ArrayList();
    private static final DisposeListener listener = e -> {
        Shell disposedShell = (Shell)e.widget;
        DAPopupNotification disposedNotification = (DAPopupNotification)disposedShell.getData();
        NotificationManager.removeNotification(disposedNotification);
    };

    private NotificationManager() {
        throw new IllegalAccessError();
    }

    public static void showNotification(String title) {
        NotificationManager.showNotification(title, null, null);
    }

    public static void showNotification(String title, String message) {
        NotificationManager.showNotification(title, message, null);
    }

    public static void showNotification(String title, String message, String details) {
        Display.getDefault().syncExec(() -> {
            Shell shell = WorkbenchUtil.getWorkbenchWindow().getShell();
            DAPopupNotification newNotification = new DAPopupNotification(shell, title, message, details);
            NotificationManager.addNotification(newNotification);
            newNotification.addDisposeListener(listener);
            newNotification.open();
        });
    }

    private static synchronized void addNotification(DAPopupNotification added) {
        if (notifications.size() == 3) {
            DAPopupNotification first = notifications.get(0);
            first.removeDisposeListener(listener);
            first.close();
            notifications.remove(first);
        }
        notifications.listIterator().forEachRemaining(notification -> {
            Point newLocation = notification.getLocation();
            newLocation.y -= notification.getSize().y + 10;
            notification.setLocation(newLocation);
        });
        notifications.add(added);
    }

    private static synchronized void removeNotification(DAPopupNotification removed) {
        int index = notifications.indexOf(removed);
        if (index < 0) {
            return;
        }
        ListIterator<DAPopupNotification> it = notifications.listIterator(index);
        while (it.hasPrevious()) {
            DAPopupNotification notification = it.previous();
            Point newLocation = notification.getLocation();
            newLocation.y += notification.getSize().y + 10;
            notification.setLocation(newLocation);
        }
        notifications.remove(removed);
    }
}

