/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.dynamicanalyzer.ui.opengl.data.DB;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.tizen.dynamicanalyzer.database.DBColumn;
import org.tizen.dynamicanalyzer.database.DBTable;
import org.tizen.dynamicanalyzer.database.SqlConnectionManager;
import org.tizen.dynamicanalyzer.ui.opengl.data.DB.GLChartDBType;
import org.tizen.dynamicanalyzer.ui.opengl.data.type.GLFrameRateInfo;
import org.tizen.dynamicanalyzer.ui.toolbar.Toolbar;
import org.tizen.dynamicanalyzer.util.Logger;

public class GLFrameRateDBTableManager
extends DBTable {
    private static final String TABLENAME = "GL_FRAME_RATE";
    public static final String CHART_TIME = "CHART_TIME";
    public static final String FRAME_COUNT = "FRAME_COUNT";
    public static final String FRAME_INDEX = "FRAME_INDEX";
    public static final String ERROR_INFO = "ERROR_INFO";
    public static final String PID = "PID";
    public static final int TABLE_CHART_TIME_INDEX = 0;
    public static final int TABLE_FRAME_COUNT_INDEX = 1;
    public static final int TABLE_FRAME_INDEX_INDEX = 2;
    public static final int TABLE_ERROR_INFO_INDEX = 3;
    public static final int TABLE_PID_INDEX = 4;
    private static final String SELECT_FRAME_RATE_TABLE_QUERY = "select CHART_TIME,FRAME_COUNT,FRAME_INDEX,ERROR_INFO,PID from GL_FRAME_RATE WHERE CHART_TIME BETWEEN '%s' and '%s'";
    private static final String SELECT_PID_FRAME_RATE_TABLE_QUERY = "select CHART_TIME,FRAME_COUNT,FRAME_INDEX,ERROR_INFO,PID from GL_FRAME_RATE where +CHART_TIME BETWEEN ' %s'and '%s' and PID = '%s'";

    @Override
    public String getTableName() {
        return TABLENAME;
    }

    public GLFrameRateDBTableManager() {
        this.addColumn(new DBColumn(CHART_TIME, "PRIMARY KEY", "INTEGER"));
        this.addColumn(new DBColumn(FRAME_COUNT, "NOT NULL", "INTEGER"));
        this.addColumn(new DBColumn(FRAME_INDEX, "NOT NULL", "INTEGER"));
        this.addColumn(new DBColumn(ERROR_INFO, "NOT NULL", "BOOLEAN"));
        this.addColumn(new DBColumn(PID, "NOT NULL", "INTEGER"));
    }

    public final void insert(List<List<Object>> data) {
        this.insertData(data);
    }

    public GLFrameRateInfo selectFrameCountInfo(int startIndex, int endIndex) {
        String query = String.format(SELECT_FRAME_RATE_TABLE_QUERY, startIndex, endIndex);
        List<List<Object>> result = SqlConnectionManager.executeQuery(query);
        if (result == null || result.size() == 0 || result.get(0).size() == 0) {
            return null;
        }
        GLFrameRateInfo returnData = new GLFrameRateInfo();
        int startFrameIndex = -1;
        int endFrameIndex = -1;
        int i = 0;
        while (i < result.size()) {
            if (i == 0) {
                startFrameIndex = (Integer)result.get(i).get(2);
            }
            if (i == result.size() - 1) {
                endFrameIndex = startFrameIndex + (Integer)result.get(i).get(1);
            }
            ++i;
        }
        returnData.setStartFrameIndex(startFrameIndex);
        returnData.setEndFrameIndex(endFrameIndex);
        return returnData;
    }

    public List<GLChartDBType> selectFrameRate(double startIndex, double endIndex) {
        ResultSet rs;
        String query = String.format(SELECT_FRAME_RATE_TABLE_QUERY, startIndex, endIndex);
        int pid = Toolbar.INSTANCE.getSelectedPid();
        if (pid != 0) {
            query = String.format(SELECT_PID_FRAME_RATE_TABLE_QUERY, startIndex, endIndex, pid);
        }
        if ((rs = SqlConnectionManager.executeQueryRS(query)) == null) {
            SqlConnectionManager.releaseResultSet(rs);
            return null;
        }
        ArrayList<GLChartDBType> returnValue = new ArrayList<GLChartDBType>();
        try {
            while (rs.next()) {
                GLChartDBType chartData = new GLChartDBType();
                chartData.setChartTime(rs.getInt(1));
                chartData.setFrameCount(rs.getInt(2));
                chartData.setFrameIndex(rs.getInt(3));
                chartData.setErrno(rs.getBoolean(4));
                returnValue.add(chartData);
            }
            SqlConnectionManager.releaseResultSet(rs);
        }
        catch (SQLException e) {
            Logger.exception((Throwable)e);
        }
        return returnValue;
    }

    @Override
    public boolean prepare(PreparedStatement prep, List<Object> rowData) {
        boolean isPrepared = true;
        int columnsize = this.getColumnSize();
        if (columnsize != rowData.size()) {
            isPrepared = false;
        } else {
            try {
                prep.setInt(1, (Integer)rowData.get(0));
                prep.setInt(2, (Integer)rowData.get(1));
                prep.setInt(3, (Integer)rowData.get(2));
                prep.setBoolean(4, (Boolean)rowData.get(3));
                prep.setInt(5, (Integer)rowData.get(4));
            }
            catch (SQLException e) {
                Logger.exception((Throwable)e);
                isPrepared = false;
            }
        }
        return isPrepared;
    }
}

