/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.dynamicanalyzer.ui.opengl.data;

import java.util.ArrayList;
import java.util.List;
import org.tizen.dynamicanalyzer.swap.model.data.GLES20LogData;
import org.tizen.dynamicanalyzer.ui.opengl.data.GLContextDataManager;
import org.tizen.dynamicanalyzer.ui.opengl.data.GLDataManager;
import org.tizen.dynamicanalyzer.ui.opengl.data.GLStateDataManager;
import org.tizen.dynamicanalyzer.ui.opengl.data.type.GLConstantDefine;
import org.tizen.dynamicanalyzer.ui.opengl.data.type.GLContextNameEnum;
import org.tizen.dynamicanalyzer.util.Logger;
import org.tizen.dynamicanalyzer.utils.AnalyzerUtil;

public class GLCommonStateDataMaker {
    private final int GL_ARRAY_BUFFER = 34962;
    private final int CONTEXT_VALUE_PARSER_TYPE_INDEX = 0;
    private final int CONTEXT_VALUE_PARSER_SIZE_INDEX = 1;
    private final int CONTEXT_VALUE_PARSER_USAGE_INDEX = 2;
    private GLStateDataManager glStateDataManager = null;
    private int arrayBufferSize = 0;
    private int arrayBufferUsage = 0;
    private int elementArrayBufferSize = 0;
    private int elementArrayBufferUsage = 0;

    public GLCommonStateDataMaker(GLStateDataManager glStateDataManager) {
        this.glStateDataManager = glStateDataManager;
    }

    private GLStateDataManager getStateDataManager() {
        return this.glStateDataManager;
    }

    public void extractGLCommonAPIParameter(GLES20LogData logData) {
        int apiType = logData.getApiType();
        String apiName = logData.getApiName();
        if (apiType == 0) {
            this.initContextValue(logData);
        } else if (this.glStateDataManager.isNormalAPIStatusForExtractParameter(logData)) {
            this.getStateDataManager().updateStateAtCurrentContext(GLContextNameEnum.CONTEXT_ID.ordinal(), logData.getCurrentContextID());
            if (apiName.equals("glBlendColor") || apiName.equals("glBlendEquation") || apiName.equals("glBlendEquationSeparate") || apiName.equals("glBlendFunc") || apiName.equals("glBlendFuncSeparate")) {
                this.extractBlendGLAPIParameter(logData);
            } else if (apiName.equals("glGenBuffers") || apiName.equals("glDeleteBuffers") || apiName.equals("glBindBuffer") || apiName.equals("glBufferData")) {
                this.extractVBOGLAPIParameter(logData);
            } else if (apiName.equals("glCullFace") || apiName.equals("glFrontFace")) {
                this.extractCullingGLAPIParameter(logData);
            } else if (apiName.equals("glDepthFunc") || apiName.equals("glDepthRangef")) {
                this.extractDepthGLAPIParameter(logData);
            } else if (apiName.equals("glEnable")) {
                this.extractEnableGLAPIParameter(logData);
            } else if (apiName.equals("glDisableVertexAttribArray") || apiName.equals("glEnableVertexAttribArray")) {
                this.extractGVAGLAPIParameter(logData);
            } else if (apiName.equals("glLineWidth")) {
                this.extractLineGLAPIParameter(logData);
            } else if (apiName.equals("glPixelStorei")) {
                this.extractPackAPIParameter(logData);
            } else if (apiName.equals("glPolygonOffset")) {
                this.extractPolyGLAPIPrameter(logData);
            } else if (apiName.equals("glScissor")) {
                this.extractSissorGLAPIParameter(logData);
            } else if (apiName.equals("glStencilFunc") || apiName.equals("glStencilFuncSeparate") || apiName.equals("glStencilOp") || apiName.equals("glStencilOpSeparate")) {
                this.extractStencilGLAPIParameter(logData);
            } else if (apiName.equals("glVertexAttrib1f") || apiName.equals("glVertexAttrib2f") || apiName.equals("glVertexAttrib3f") || apiName.equals("glVertexAttrib4f") || apiName.equals("glVertexAttrib1fv") || apiName.equals("glVertexAttrib2fv") || apiName.equals("glVertexAttrib3fv") || apiName.equals("glVertexAttrib4fv") || apiName.equals("glVertexAttribPointer")) {
                this.extractVertexGLAPIParameter(logData);
            } else if (apiName.equals("glViewport")) {
                this.extractViewPortGLAPIParameter(logData);
            }
        }
    }

    private void initContextValue(GLES20LogData logData) {
        String contextValue = logData.getContextValue().trim();
        GLContextDataManager currentContextValue = this.getStateDataManager().getGLContextDataManager(logData.getCurrentContextID());
        if (logData.getApiType() != 0) {
            return;
        }
        if (!contextValue.contains(",")) {
            return;
        }
        String[] contextValues = contextValue.split(",");
        if (contextValues.length != 2) {
            Logger.error((Object)"GL context init API - size of the parameter of the context log column is not 2");
            return;
        }
        currentContextValue.setTextureUnits(Integer.parseInt(contextValues[0].trim()));
        currentContextValue.setVertexAttribs(Integer.parseInt(contextValues[1].trim()));
    }

    private void extractLineGLAPIParameter(GLES20LogData logData) {
        String[] parameters = logData.getArgs().split(", ");
        if (!logData.getApiName().equals("glLineWidth")) {
            return;
        }
        if (parameters.length != 1) {
            Logger.error((Object)"GL extract API parameter  : glLineWidth");
            return;
        }
        this.getStateDataManager().updateStateAtCurrentContext(GLContextNameEnum.LINE_WIDTH.ordinal(), Integer.parseInt(parameters[0]));
    }

    private void extractPackAPIParameter(GLES20LogData logData) {
        String[] parameters = logData.getArgs().split(", ");
        if (!logData.getApiName().equals("glPixelStorei")) {
            return;
        }
        if (parameters.length != 2) {
            Logger.error((Object)"GL extract API parameter  : glPixelStorei");
            return;
        }
        if (parameters[0].equals(Long.toString(AnalyzerUtil.addrToLong("d05")))) {
            this.getStateDataManager().updateStateAtCurrentContext(GLContextNameEnum.PACK_ALIGN.ordinal(), Integer.parseInt(parameters[1]));
        } else if (parameters[0].equals(Long.toString(AnalyzerUtil.addrToLong("cf5")))) {
            this.getStateDataManager().updateStateAtCurrentContext(GLContextNameEnum.UNPACK_ALIGN.ordinal(), Integer.parseInt(parameters[1]));
        } else {
            Logger.error((Object)("GL extract API parameter undefine : " + logData.getApiName()));
        }
    }

    private void extractGVAGLAPIParameter(GLES20LogData logData) {
        GLContextDataManager currentContextValue = this.getStateDataManager().getGLContextDataManager(logData.getCurrentContextID());
        if (logData.getApiName().equals("glDisableVertexAttribArray")) {
            currentContextValue.gvaEnabledValueList.set(Integer.parseInt(logData.getArgs()), false);
            this.getStateDataManager().updateStateAtCurrentContext(GLContextNameEnum.GVA_ENABLED.ordinal(), currentContextValue.gvaEnabledValueList);
        } else if (logData.getApiName().equals("glEnableVertexAttribArray")) {
            currentContextValue.gvaEnabledValueList.set(Integer.parseInt(logData.getArgs()), true);
            this.getStateDataManager().updateStateAtCurrentContext(GLContextNameEnum.GVA_ENABLED.ordinal(), currentContextValue.gvaEnabledValueList);
        }
    }

    private void extractEnableGLAPIParameter(GLES20LogData logData) {
        String parameter = logData.getArgs().trim();
        if (!logData.getApiName().equals("glEnable")) {
            return;
        }
        if (parameter.equals("be2")) {
            this.getStateDataManager().updateStateAtCurrentContext(GLContextNameEnum.BLEND_ENABLED.ordinal(), true);
        } else if (parameter.equals("b44")) {
            this.getStateDataManager().updateStateAtCurrentContext(GLContextNameEnum.CULLING_ENABLED.ordinal(), true);
        } else if (parameter.equals("b71")) {
            this.getStateDataManager().updateStateAtCurrentContext(GLContextNameEnum.DEPTH_ENABLED.ordinal(), true);
        } else if (parameter.equals("bd0")) {
            this.getStateDataManager().updateStateAtCurrentContext(GLContextNameEnum.DITHER_ENABLED.ordinal(), true);
        } else if (parameter.equals("8037")) {
            this.getStateDataManager().updateStateAtCurrentContext(GLContextNameEnum.POLY_ENABLED.ordinal(), true);
        } else if (parameter.equals("c11")) {
            this.getStateDataManager().updateStateAtCurrentContext(GLContextNameEnum.SCISSOR_ENABLED.ordinal(), true);
        } else if (parameter.equals("b90")) {
            this.getStateDataManager().updateStateAtCurrentContext(GLContextNameEnum.STENCIL_ENABLED.ordinal(), true);
        }
    }

    private void extractPolyGLAPIPrameter(GLES20LogData logData) {
        String[] parameters = logData.getArgs().split(", ");
        logData.getApiName().equals("glPolygonOffset");
        this.getStateDataManager().updateStateAtCurrentContext(GLContextNameEnum.POLY_FACTOR.ordinal(), Integer.parseInt(parameters[0]));
        this.getStateDataManager().updateStateAtCurrentContext(GLContextNameEnum.POLY_UNITS.ordinal(), Integer.parseInt(parameters[1]));
    }

    private void extractSissorGLAPIParameter(GLES20LogData logData) {
        String[] parameters = logData.getArgs().split(", ");
        if (!logData.getApiName().equals("glScissor")) {
            return;
        }
        if (parameters.length != 4) {
            Logger.error((Object)"GL extract API parameter  : glScissor");
            return;
        }
        StringBuffer scissor = new StringBuffer();
        scissor.append(parameters[0]).append(",").append(parameters[1]).append(",").append(parameters[2]).append(",").append(parameters[3]);
        this.getStateDataManager().updateStateAtCurrentContext(GLContextNameEnum.SCISSOR.ordinal(), scissor.toString());
    }

    private void extractViewPortGLAPIParameter(GLES20LogData logData) {
        String[] parameters = logData.getArgs().split(", ");
        if (!logData.getApiName().equals("glViewport")) {
            return;
        }
        if (parameters.length != 4) {
            Logger.error((Object)"GL extract API parameter  : glViewport");
            return;
        }
        StringBuffer viewPort = new StringBuffer();
        viewPort.append(parameters[0].trim()).append(",").append(parameters[1].trim()).append(",").append(parameters[2].trim()).append(",").append(parameters[3].trim());
        this.getStateDataManager().updateStateAtCurrentContext(GLContextNameEnum.VIEWPORT.ordinal(), viewPort.toString());
    }

    private void extractDepthGLAPIParameter(GLES20LogData logData) {
        String[] parameters = logData.getArgs().split(", ");
        if (logData.getApiName().equals("glDepthFunc")) {
            if (parameters.length != 1) {
                Logger.error((Object)("GL extract API parameter  : " + logData.getApiName()));
                return;
            }
            this.getStateDataManager().updateStateAtCurrentContext(GLContextNameEnum.DEPTH_FUNC.ordinal(), Integer.parseInt(parameters[0]));
        } else if (logData.getApiName().equals("glDepthRangef")) {
            if (parameters.length != 2) {
                Logger.error((Object)("GL extract API parameter  : " + logData.getApiName()));
                return;
            }
            this.getStateDataManager().updateStateAtCurrentContext(GLContextNameEnum.DEPTH_RANGE_N.ordinal(), Integer.parseInt(parameters[0]));
            this.getStateDataManager().updateStateAtCurrentContext(GLContextNameEnum.DEPTH_RANGE_F.ordinal(), Integer.parseInt(parameters[1]));
        }
    }

    private void extractCullingGLAPIParameter(GLES20LogData logData) {
        String[] parameters = logData.getArgs().split(", ");
        if (logData.getApiName().equals("glCullFace")) {
            if (parameters.length != 1) {
                Logger.error((Object)"GL extract API parameter  : glCullFace");
                return;
            }
            this.getStateDataManager().updateStateAtCurrentContext(GLContextNameEnum.CULLING_MODE.ordinal(), Integer.parseInt(parameters[0]));
        } else if (logData.getApiName().equals("glFrontFace")) {
            if (parameters.length != 1) {
                Logger.error((Object)"GL extract API parameter  : glFrontFace");
                return;
            }
            this.getStateDataManager().updateStateAtCurrentContext(GLContextNameEnum.CULLING_ORIENTATION.ordinal(), Integer.parseInt(parameters[0]));
        }
    }

    private void extractVBOGLAPIParameter(GLES20LogData logData) {
        long contextId = logData.getCurrentContextID();
        GLContextDataManager currentContextValue = this.getStateDataManager().getGLContextDataManager(contextId);
        String[] parameters = logData.getArgs().split(", ");
        if (logData.getApiName().equals("glDeleteBuffers")) {
            if (Integer.parseInt(parameters[0]) == currentContextValue.vboArrayBinding) {
                currentContextValue.vboArrayBinding = 0;
                currentContextValue.vboArrayID = 0;
                currentContextValue.vboArraySize = 0;
                currentContextValue.vboArrayData = 0L;
                currentContextValue.vboArrayUsage = 0;
                this.getStateDataManager().updateStateAtCurrentContext(GLContextNameEnum.VBO_ARRAY_BINDING.ordinal(), currentContextValue.vboArrayBinding);
                this.getStateDataManager().updateStateAtCurrentContext(GLContextNameEnum.VBO_ARRAY_ID.ordinal(), currentContextValue.vboArrayID);
                this.getStateDataManager().updateStateAtCurrentContext(GLContextNameEnum.VBO_ARRAY_SIZE.ordinal(), currentContextValue.vboArraySize);
                this.getStateDataManager().updateStateAtCurrentContext(GLContextNameEnum.VBO_ARRAY_DATA.ordinal(), currentContextValue.vboArrayData);
                this.getStateDataManager().updateStateAtCurrentContext(GLContextNameEnum.VBO_ARRAY_USAGE.ordinal(), currentContextValue.vboArrayUsage);
            } else {
                currentContextValue.vboElementBinding = 0;
                currentContextValue.vboElementID = 0;
                currentContextValue.vboElementSize = 0;
                currentContextValue.vboElementData = 0L;
                currentContextValue.vboElementUsage = 0;
                this.getStateDataManager().updateStateAtCurrentContext(GLContextNameEnum.VBO_ELEMENT_BINDING.ordinal(), currentContextValue.vboElementBinding);
                this.getStateDataManager().updateStateAtCurrentContext(GLContextNameEnum.VBO_ELEMENT_ID.ordinal(), currentContextValue.vboElementID);
                this.getStateDataManager().updateStateAtCurrentContext(GLContextNameEnum.VBO_ELEMENT_SIZE.ordinal(), currentContextValue.vboElementSize);
                this.getStateDataManager().updateStateAtCurrentContext(GLContextNameEnum.VBO_ELEMENT_DATA.ordinal(), currentContextValue.vboElementData);
                this.getStateDataManager().updateStateAtCurrentContext(GLContextNameEnum.VBO_ELEMENT_USAGE.ordinal(), currentContextValue.vboElementUsage);
            }
            this.insertToBufferSizeDB(logData);
        } else if (logData.getApiName().equals("glBindBuffer")) {
            if (parameters.length != 2) {
                Logger.error((Object)"GL extract API parameter  : glBindBuffer");
                return;
            }
            if (Integer.parseInt(parameters[1]) == 0) {
                this.insertToBufferSizeDB(logData);
                return;
            }
            if (GLConstantDefine.getConstantString(Integer.parseInt(parameters[0])).equals("GL_ARRAY_BUFFER")) {
                currentContextValue.vboArrayBinding = Integer.parseInt(parameters[1]);
                this.getStateDataManager().updateStateAtCurrentContext(GLContextNameEnum.VBO_ARRAY_BINDING.ordinal(), currentContextValue.vboArrayBinding);
            } else {
                currentContextValue.vboElementBinding = Integer.parseInt(parameters[1]);
                this.getStateDataManager().updateStateAtCurrentContext(GLContextNameEnum.VBO_ELEMENT_BINDING.ordinal(), currentContextValue.vboElementBinding);
            }
            this.insertToBufferSizeDB(logData);
        } else if (logData.getApiName().equals("glBufferData")) {
            if (parameters.length != 4) {
                Logger.error((Object)"GL extract API parameter  : glBufferData");
                return;
            }
            if (GLConstantDefine.getConstantString(Integer.parseInt(parameters[0])).equals("GL_ARRAY_BUFFER")) {
                currentContextValue.vboArraySize = Integer.parseInt(parameters[1]);
                currentContextValue.vboArrayData = AnalyzerUtil.addrToLong(parameters[2]);
                currentContextValue.vboArrayUsage = Integer.parseInt(parameters[3]);
                this.getStateDataManager().updateStateAtCurrentContext(GLContextNameEnum.VBO_ARRAY_SIZE.ordinal(), currentContextValue.vboArraySize);
                this.getStateDataManager().updateStateAtCurrentContext(GLContextNameEnum.VBO_ARRAY_DATA.ordinal(), currentContextValue.vboArrayData);
                this.getStateDataManager().updateStateAtCurrentContext(GLContextNameEnum.VBO_ARRAY_USAGE.ordinal(), currentContextValue.vboArrayUsage);
            } else {
                currentContextValue.vboElementSize = Integer.parseInt(parameters[1]);
                currentContextValue.vboElementData = AnalyzerUtil.addrToLong(parameters[2]);
                currentContextValue.vboElementUsage = Integer.parseInt(parameters[3]);
                this.getStateDataManager().updateStateAtCurrentContext(GLContextNameEnum.VBO_ELEMENT_SIZE.ordinal(), currentContextValue.vboElementSize);
                this.getStateDataManager().updateStateAtCurrentContext(GLContextNameEnum.VBO_ELEMENT_DATA.ordinal(), currentContextValue.vboElementData);
                this.getStateDataManager().updateStateAtCurrentContext(GLContextNameEnum.VBO_ELEMENT_USAGE.ordinal(), currentContextValue.vboElementUsage);
            }
            this.insertToBufferSizeDB(logData);
        }
    }

    private void extractBlendGLAPIParameter(GLES20LogData logData) {
        String[] parameters = logData.getArgs().split(", ");
        if (logData.getApiName().equals("glBlendColor")) {
            if (parameters.length != 4) {
                Logger.error((Object)"GL extract API parameter  : glBlendColor");
                return;
            }
            this.getStateDataManager().updateStateAtCurrentContext(GLContextNameEnum.BLEND_COLOR.ordinal(), String.valueOf(parameters[0]) + "," + parameters[1] + "," + parameters[2] + "," + parameters[3]);
        } else if (logData.getApiName().equals("glBlendEquation")) {
            if (parameters.length != 1) {
                Logger.error((Object)"GL extract API parameter  : glBlendEquation");
                return;
            }
            this.getStateDataManager().updateStateAtCurrentContext(GLContextNameEnum.BLEND_EQUATION_RGB.ordinal(), Integer.parseInt(parameters[0]));
            this.getStateDataManager().updateStateAtCurrentContext(GLContextNameEnum.BLEND_EQUATION_ALPHA.ordinal(), Integer.parseInt(parameters[0]));
        } else if (logData.getApiName().equals("glBlendEquationSeparate")) {
            if (parameters.length != 2) {
                Logger.error((Object)"GL extract API parameter  : glBlendEquationSeparate");
                return;
            }
            this.getStateDataManager().updateStateAtCurrentContext(GLContextNameEnum.BLEND_EQUATION_RGB.ordinal(), Integer.parseInt(parameters[0]));
            this.getStateDataManager().updateStateAtCurrentContext(GLContextNameEnum.BLEND_EQUATION_ALPHA.ordinal(), Integer.parseInt(parameters[1]));
        } else if (logData.getApiName().equals("glBlendFunc")) {
            if (parameters.length != 2) {
                Logger.error((Object)"GL extract API parameter  : glBlendFunc");
                return;
            }
            this.getStateDataManager().updateStateAtCurrentContext(GLContextNameEnum.BLEND_SRC_RGB.ordinal(), Integer.parseInt(parameters[0]));
            this.getStateDataManager().updateStateAtCurrentContext(GLContextNameEnum.BLEND_SRC_ALPHA.ordinal(), Integer.parseInt(parameters[1]));
            this.getStateDataManager().updateStateAtCurrentContext(GLContextNameEnum.BLEND_DEST_RGB.ordinal(), Integer.parseInt(parameters[0]));
            this.getStateDataManager().updateStateAtCurrentContext(GLContextNameEnum.BLEND_DEST_ALPHA.ordinal(), Integer.parseInt(parameters[1]));
        } else if (logData.getApiName().equals("glBlendFuncSeparate")) {
            if (parameters.length != 4) {
                Logger.error((Object)"GL extract API parameter  : glBlendFuncSeparate");
                return;
            }
            this.getStateDataManager().updateStateAtCurrentContext(GLContextNameEnum.BLEND_SRC_RGB.ordinal(), Integer.parseInt(parameters[0]));
            this.getStateDataManager().updateStateAtCurrentContext(GLContextNameEnum.BLEND_DEST_RGB.ordinal(), Integer.parseInt(parameters[1]));
            this.getStateDataManager().updateStateAtCurrentContext(GLContextNameEnum.BLEND_SRC_ALPHA.ordinal(), Integer.parseInt(parameters[2]));
            this.getStateDataManager().updateStateAtCurrentContext(GLContextNameEnum.BLEND_DEST_ALPHA.ordinal(), Integer.parseInt(parameters[3]));
        }
    }

    private void extractStencilGLAPIParameter(GLES20LogData logData) {
        String[] parameters = logData.getArgs().split(", ");
        if (logData.getApiName().equals("glStencilFunc")) {
            if (parameters.length != 3) {
                Logger.error((Object)"GL extract API parameter  : glStencilFunc");
                return;
            }
            this.getStateDataManager().updateStateAtCurrentContext(GLContextNameEnum.STENCIL_FRONT_FUNC.ordinal(), Integer.parseInt(parameters[0]));
            this.getStateDataManager().updateStateAtCurrentContext(GLContextNameEnum.STENCIL_FRONT_REF.ordinal(), Integer.parseInt(parameters[1]));
            this.getStateDataManager().updateStateAtCurrentContext(GLContextNameEnum.STENCIL_FRONT_MASK.ordinal(), Integer.parseInt(parameters[2]));
            this.getStateDataManager().updateStateAtCurrentContext(GLContextNameEnum.STENCIL_BACK_FUNC.ordinal(), Integer.parseInt(parameters[0]));
            this.getStateDataManager().updateStateAtCurrentContext(GLContextNameEnum.STENCIL_BACK_REF.ordinal(), Integer.parseInt(parameters[1]));
            this.getStateDataManager().updateStateAtCurrentContext(GLContextNameEnum.STENCIL_BACK_MASK.ordinal(), Integer.parseInt(parameters[2]));
        } else if (logData.getApiName().equals("glStencilFuncSeparate")) {
            if (parameters.length != 3) {
                Logger.error((Object)"GL extract API parameter  : glStencilFuncSeparate");
                return;
            }
            if (parameters[0].equals("404")) {
                this.getStateDataManager().updateStateAtCurrentContext(GLContextNameEnum.STENCIL_FRONT_FUNC.ordinal(), Integer.parseInt(parameters[0]));
                this.getStateDataManager().updateStateAtCurrentContext(GLContextNameEnum.STENCIL_FRONT_REF.ordinal(), Integer.parseInt(parameters[1]));
                this.getStateDataManager().updateStateAtCurrentContext(GLContextNameEnum.STENCIL_FRONT_MASK.ordinal(), Integer.parseInt(parameters[2]));
            } else if (parameters[0].equals("405")) {
                this.getStateDataManager().updateStateAtCurrentContext(GLContextNameEnum.STENCIL_BACK_FUNC.ordinal(), Integer.parseInt(parameters[0]));
                this.getStateDataManager().updateStateAtCurrentContext(GLContextNameEnum.STENCIL_BACK_REF.ordinal(), Integer.parseInt(parameters[1]));
                this.getStateDataManager().updateStateAtCurrentContext(GLContextNameEnum.STENCIL_BACK_MASK.ordinal(), Integer.parseInt(parameters[2]));
            } else if (parameters[0].equals("408")) {
                this.getStateDataManager().updateStateAtCurrentContext(GLContextNameEnum.STENCIL_FRONT_FUNC.ordinal(), Integer.parseInt(parameters[0]));
                this.getStateDataManager().updateStateAtCurrentContext(GLContextNameEnum.STENCIL_FRONT_REF.ordinal(), Integer.parseInt(parameters[1]));
                this.getStateDataManager().updateStateAtCurrentContext(GLContextNameEnum.STENCIL_FRONT_MASK.ordinal(), Integer.parseInt(parameters[2]));
                this.getStateDataManager().updateStateAtCurrentContext(GLContextNameEnum.STENCIL_BACK_FUNC.ordinal(), Integer.parseInt(parameters[0]));
                this.getStateDataManager().updateStateAtCurrentContext(GLContextNameEnum.STENCIL_BACK_REF.ordinal(), Integer.parseInt(parameters[1]));
                this.getStateDataManager().updateStateAtCurrentContext(GLContextNameEnum.STENCIL_BACK_MASK.ordinal(), Integer.parseInt(parameters[2]));
            }
        } else if (logData.getApiName().equals("glStencilOp")) {
            if (parameters.length != 3) {
                Logger.error((Object)"GL extract API parameter  : glStencilOp");
                return;
            }
            this.getStateDataManager().updateStateAtCurrentContext(GLContextNameEnum.STENCIL_FRONT_S_FAIL.ordinal(), Integer.parseInt(parameters[0]));
            this.getStateDataManager().updateStateAtCurrentContext(GLContextNameEnum.STENCIL_FRONT_D_FAIL.ordinal(), Integer.parseInt(parameters[1]));
            this.getStateDataManager().updateStateAtCurrentContext(GLContextNameEnum.STENCIL_FRONT_D_PASS.ordinal(), Integer.parseInt(parameters[2]));
            this.getStateDataManager().updateStateAtCurrentContext(GLContextNameEnum.STENCIL_BACK_S_FAIL.ordinal(), Integer.parseInt(parameters[0]));
            this.getStateDataManager().updateStateAtCurrentContext(GLContextNameEnum.STENCIL_BACK_D_FAIL.ordinal(), Integer.parseInt(parameters[1]));
            this.getStateDataManager().updateStateAtCurrentContext(GLContextNameEnum.STENCIL_BACK_D_PASS.ordinal(), Integer.parseInt(parameters[2]));
        } else if (logData.getApiName().equals("glStencilOpSeparate")) {
            if (parameters.length != 4) {
                Logger.error((Object)("GL extract API parameter  : " + logData.getApiName()));
                return;
            }
            if (parameters[0].equals("404")) {
                this.getStateDataManager().updateStateAtCurrentContext(GLContextNameEnum.STENCIL_FRONT_S_FAIL.ordinal(), Integer.parseInt(parameters[1]));
                this.getStateDataManager().updateStateAtCurrentContext(GLContextNameEnum.STENCIL_FRONT_D_FAIL.ordinal(), Integer.parseInt(parameters[2]));
                this.getStateDataManager().updateStateAtCurrentContext(GLContextNameEnum.STENCIL_FRONT_D_PASS.ordinal(), Integer.parseInt(parameters[3]));
            } else if (parameters[0].equals("405")) {
                this.getStateDataManager().updateStateAtCurrentContext(GLContextNameEnum.STENCIL_BACK_S_FAIL.ordinal(), Integer.parseInt(parameters[1]));
                this.getStateDataManager().updateStateAtCurrentContext(GLContextNameEnum.STENCIL_BACK_D_FAIL.ordinal(), Integer.parseInt(parameters[2]));
                this.getStateDataManager().updateStateAtCurrentContext(GLContextNameEnum.STENCIL_BACK_D_PASS.ordinal(), Integer.parseInt(parameters[3]));
            } else if (parameters[0].equals("408")) {
                this.getStateDataManager().updateStateAtCurrentContext(GLContextNameEnum.STENCIL_FRONT_S_FAIL.ordinal(), Integer.parseInt(parameters[1]));
                this.getStateDataManager().updateStateAtCurrentContext(GLContextNameEnum.STENCIL_FRONT_D_FAIL.ordinal(), Integer.parseInt(parameters[2]));
                this.getStateDataManager().updateStateAtCurrentContext(GLContextNameEnum.STENCIL_FRONT_D_PASS.ordinal(), Integer.parseInt(parameters[3]));
                this.getStateDataManager().updateStateAtCurrentContext(GLContextNameEnum.STENCIL_BACK_S_FAIL.ordinal(), Integer.parseInt(parameters[1]));
                this.getStateDataManager().updateStateAtCurrentContext(GLContextNameEnum.STENCIL_BACK_D_FAIL.ordinal(), Integer.parseInt(parameters[2]));
                this.getStateDataManager().updateStateAtCurrentContext(GLContextNameEnum.STENCIL_BACK_D_PASS.ordinal(), Integer.parseInt(parameters[3]));
            }
        }
    }

    private void extractVertexGLAPIParameter(GLES20LogData logData) {
        GLContextDataManager currentContextValue = this.getStateDataManager().getGLContextDataManager(logData.getCurrentContextID());
        String[] parameters = logData.getArgs().split(", ");
        String[] contextValues = logData.getContextValue().trim().split(",");
        if (logData.getApiName().equals("glVertexAttrib1f") || logData.getApiName().equals("glVertexAttrib2f") || logData.getApiName().equals("glVertexAttrib3f") || logData.getApiName().equals("glVertexAttrib4f") || logData.getApiName().equals("glVertexAttrib1fv") || logData.getApiName().equals("glVertexAttrib2fv") || logData.getApiName().equals("glVertexAttrib3fv") || logData.getApiName().equals("glVertexAttrib4fv")) {
            if (parameters.length != 4) {
                Logger.error((Object)("GL extract API parameter  : " + logData.getApiName()));
                return;
            }
            int gvaIndex = Integer.parseInt(parameters[0]);
            currentContextValue.gvaV0ValueList.set(gvaIndex, Integer.parseInt(contextValues[0]));
            currentContextValue.gvaV1ValueList.set(gvaIndex, Integer.parseInt(contextValues[1]));
            currentContextValue.gvaV2ValueList.set(gvaIndex, Integer.parseInt(contextValues[2]));
            currentContextValue.gvaV3ValueList.set(gvaIndex, Integer.parseInt(contextValues[3]));
            this.getStateDataManager().updateStateAtCurrentContext(GLContextNameEnum.GVA_V0.ordinal(), currentContextValue.gvaV0ValueList);
            this.getStateDataManager().updateStateAtCurrentContext(GLContextNameEnum.GVA_V1.ordinal(), currentContextValue.gvaV1ValueList);
            this.getStateDataManager().updateStateAtCurrentContext(GLContextNameEnum.GVA_V2.ordinal(), currentContextValue.gvaV2ValueList);
            this.getStateDataManager().updateStateAtCurrentContext(GLContextNameEnum.GVA_V3.ordinal(), currentContextValue.gvaV3ValueList);
        } else if (logData.getApiName().equals("glVertexAttribPointer")) {
            if (parameters.length != 6) {
                Logger.error((Object)("GL extract API parameter  : " + logData.getApiName()));
                return;
            }
            int gvaIndex = Integer.parseInt(parameters[0]);
            currentContextValue.gvaSizeValueList.set(gvaIndex, Integer.parseInt(parameters[1]));
            currentContextValue.gvaTypeValueList.set(gvaIndex, Integer.parseInt(parameters[2]));
            currentContextValue.gvaNormalValueList.set(gvaIndex, Integer.parseInt(parameters[3]));
            currentContextValue.gvaStrideValueList.set(gvaIndex, Integer.parseInt(parameters[4]));
            currentContextValue.gvaPointerValueList.set(gvaIndex, AnalyzerUtil.addrToLong(parameters[5]));
            this.getStateDataManager().updateStateAtCurrentContext(GLContextNameEnum.GVA_SIZE.ordinal(), currentContextValue.gvaSizeValueList);
            this.getStateDataManager().updateStateAtCurrentContext(GLContextNameEnum.GVA_TYPE.ordinal(), currentContextValue.gvaTypeValueList);
            this.getStateDataManager().updateStateAtCurrentContext(GLContextNameEnum.GVA_NORMAL.ordinal(), currentContextValue.gvaNormalValueList);
            this.getStateDataManager().updateStateAtCurrentContext(GLContextNameEnum.GVA_STRIDE.ordinal(), currentContextValue.gvaStrideValueList);
            this.getStateDataManager().updateStateAtCurrentContext(GLContextNameEnum.GVA_POINTER.ordinal(), currentContextValue.gvaPointerValueList);
        }
    }

    public void insertToBufferSizeDB(GLES20LogData logData) {
        ArrayList<List<Object>> insertDataList = new ArrayList<List<Object>>();
        ArrayList<Number> data = new ArrayList<Number>();
        if (this.isBufferEqualZeroOfGLBindBuffer(logData) || this.updateChangedBufferSize(logData.getContextValue().trim())) {
            data.add(logData.getSeq());
            data.add(logData.getCurrentContextID());
            data.add(this.arrayBufferSize);
            data.add(this.arrayBufferUsage);
            data.add(this.elementArrayBufferSize);
            data.add(this.elementArrayBufferUsage);
            insertDataList.add(data);
            GLDataManager.getInstance().getBufferSizeDBTable().insertData(insertDataList);
        }
    }

    private boolean isBufferEqualZeroOfGLBindBuffer(GLES20LogData logData) {
        if (!logData.getApiName().equals("glBindBuffer")) {
            return false;
        }
        if (!logData.getArgs().contains(",")) {
            return false;
        }
        String[] argsSplit = logData.getArgs().split(",");
        if (argsSplit.length != 2) {
            return false;
        }
        int target = Integer.parseInt(argsSplit[0].trim());
        int buffer = Integer.parseInt(argsSplit[1].trim());
        if (buffer == 0) {
            if (target == 34962) {
                this.arrayBufferSize = 0;
                this.arrayBufferUsage = 0;
            } else {
                this.elementArrayBufferSize = 0;
                this.elementArrayBufferUsage = 0;
            }
            return true;
        }
        return false;
    }

    private boolean updateChangedBufferSize(String memorySize) {
        boolean isChanged = false;
        if (!memorySize.contains(",")) {
            return isChanged;
        }
        String[] contextValues = memorySize.split(",");
        if (contextValues.length != 3) {
            Logger.error((Object)"GL buffer API - size of the parameter of the context log column is not 2");
            return isChanged;
        }
        if (Integer.parseInt(contextValues[0]) == 34962) {
            if (this.arrayBufferSize != Integer.parseInt(contextValues[1])) {
                this.arrayBufferSize = Integer.parseInt(contextValues[1]);
                isChanged = true;
            }
            if (this.arrayBufferUsage != Integer.parseInt(contextValues[2])) {
                this.arrayBufferUsage = Integer.parseInt(contextValues[2]);
                isChanged = true;
            }
        } else {
            if (this.elementArrayBufferSize != Integer.parseInt(contextValues[1])) {
                this.elementArrayBufferSize = Integer.parseInt(contextValues[1]);
                isChanged = true;
            }
            if (this.elementArrayBufferUsage != Integer.parseInt(contextValues[2])) {
                this.elementArrayBufferUsage = Integer.parseInt(contextValues[2]);
                isChanged = true;
            }
        }
        return isChanged;
    }
}

