/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.dynamicanalyzer.ui.thread.data;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import org.tizen.dynamicanalyzer.nl.ThreadPageLabels;
import org.tizen.dynamicanalyzer.swap.model.data.LogData;
import org.tizen.dynamicanalyzer.swap.model.data.SyncData;
import org.tizen.dynamicanalyzer.ui.summary.SummaryDataManager;
import org.tizen.dynamicanalyzer.ui.thread.data.ThreadDataManager;
import org.tizen.dynamicanalyzer.ui.thread.type.ThreadPageSyncData;
import org.tizen.dynamicanalyzer.ui.thread.type.ThreadPageSyncDataEvent;
import org.tizen.dynamicanalyzer.ui.thread.type.ThreadPageThreadData;
import org.tizen.dynamicanalyzer.util.Logger;

public class ThreadSyncDataMaker {
    private List<ThreadPageSyncData> chartRowData = new ArrayList<ThreadPageSyncData>();
    private List<ThreadPageSyncDataEvent> noBlockEndTimeSyncEventQueue = new ArrayList<ThreadPageSyncDataEvent>();
    private List<ThreadPageSyncDataEvent> syncEventQueue = new ArrayList<ThreadPageSyncDataEvent>();
    private List<ThreadPageSyncDataEvent> syncEventQueueOfThread = new ArrayList<ThreadPageSyncDataEvent>();
    private HashMap<String, Integer> syncAttrMap = new HashMap();
    public static final int PTHREAD_MUTEX_NORMAL = 0;
    public static final int PTHREAD_MUTEX_RECURSIVE = 1;
    public static final int PTHREAD_MUTEX_ERRORCHECK = 2;
    public static final int PTHREAD_MUTEX_DEFAULT = 3;

    public void makeSyncData(List<LogData> syncInputs) {
        int logSize = syncInputs.size();
        int i = 0;
        while (i < logSize) {
            this.parseSync(syncInputs.get(i));
            ++i;
        }
        this.insertSyncData();
    }

    public void parseSync(LogData input) {
        if (input == null || !(input instanceof SyncData)) {
            return;
        }
        SyncData syncData = (SyncData)input;
        long time = syncData.getTime();
        int tID = syncData.getTid();
        int type = syncData.getSyncType();
        int apiType = syncData.getApiType();
        String apiName = syncData.getApiName();
        String name = Long.toString(syncData.getSyncValue());
        long errorNum = syncData.getErrno();
        if (errorNum != 0L) {
            SummaryDataManager.getInstance().getFailedApiDataMaker().makeData(syncData);
        }
        switch (type) {
            case 0: 
            case 1: 
            case 2: {
                ThreadPageSyncDataEvent event = new ThreadPageSyncDataEvent(name, type, apiType, time, tID, apiName, errorNum, input);
                this.syncEventQueue.add(event);
                this.syncEventQueueOfThread.add(event);
                break;
            }
            case 3: 
            case 4: {
                if (apiName.equals(ThreadPageLabels.SYNC_API_PTHREAD_MUTEXATTR_INIT)) {
                    this.syncAttrMap.put(syncData.getArgs(), 0);
                    break;
                }
                if (apiName.equals(ThreadPageLabels.SYNC_API_PTHREAD_MUTEXATTR_SETTYPE)) {
                    this.checkMutexAttrType(syncData.getArgs());
                    break;
                }
                if (apiName.equals(ThreadPageLabels.SYNC_API_PTHREAD_MUTEX_INIT)) {
                    this.checkMutexType(syncData.getArgs());
                }
                ThreadPageSyncDataEvent event = new ThreadPageSyncDataEvent(name, type, apiType, time, tID, apiName, errorNum, input);
                this.syncEventQueue.add(event);
                this.syncEventQueueOfThread.add(event);
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                ThreadPageSyncDataEvent event = new ThreadPageSyncDataEvent(name, type, apiType, time, tID, apiName, errorNum, input);
                this.syncEventQueue.add(event);
                this.syncEventQueueOfThread.add(event);
                Logger.error((Object)("sync parse - type = " + type));
                break;
            }
            default: {
                Logger.error((Object)("sync parse unknown - type = " + type));
            }
        }
    }

    public void insertSyncData() {
        this.makeSyncDataOfThread();
        this.makeSyncData();
    }

    private void makeSyncData() {
        int size = this.syncEventQueue.size();
        if (size == 0) {
            return;
        }
        ArrayList<ThreadPageSyncDataEvent> insertSyncEventQueue = new ArrayList<ThreadPageSyncDataEvent>();
        ArrayList<ThreadPageSyncData> insertSyncDataQueue = new ArrayList<ThreadPageSyncData>();
        int i = 0;
        while (i < size) {
            block9: {
                ThreadPageSyncDataEvent event = this.syncEventQueue.get(0);
                String syncVal = event.getSyncVal();
                String pid = Integer.toString(event.getContents().getPid());
                ThreadPageSyncData parent = this.findParentData(syncVal);
                if (parent == null) {
                    Integer syncAttrTypeInt = this.syncAttrMap.get(syncVal);
                    String syncAttrType = syncAttrTypeInt != null ? ThreadSyncDataMaker.getAttrTypeByTypeInt(syncAttrTypeInt) : ThreadSyncDataMaker.getAttrTypeString(event);
                    parent = new ThreadPageSyncData(event.getType(), syncVal, pid, event.getTid(), syncAttrType, 0);
                    this.chartRowData.add(parent);
                    insertSyncDataQueue.add(parent);
                }
                event.setSyncDataID(parent.getSyncDataID());
                ThreadPageSyncData data = parent.findChildData(event.getTid());
                insertSyncEventQueue.add(event);
                if (data == null) {
                    String attrType = parent.getAttrType();
                    data = new ThreadPageSyncData(event.getType(), syncVal, pid, event.getTid(), attrType, 1);
                    data.setParentID(parent.getSyncDataID());
                    parent.pushSync(data);
                    this.chartRowData.add(data);
                    insertSyncDataQueue.add(data);
                }
                try {
                    try {
                        ThreadPageSyncDataEvent cloneEvent = event.clone();
                        cloneEvent.setSyncDataID(data.getSyncDataID());
                        insertSyncEventQueue.add(cloneEvent);
                    }
                    catch (CloneNotSupportedException e) {
                        Logger.exception((Throwable)e);
                        this.syncEventQueue.remove(0);
                        break block9;
                    }
                }
                catch (Throwable throwable) {
                    this.syncEventQueue.remove(0);
                    throw throwable;
                }
                this.syncEventQueue.remove(0);
            }
            ++i;
        }
        this.insertSyncEvent(insertSyncEventQueue);
        ThreadDataManager.getInstance().insertSyncData(insertSyncDataQueue, true);
    }

    public void makeSyncDataOfThread() {
        int size = this.syncEventQueueOfThread.size();
        if (size == 0) {
            return;
        }
        ArrayList<ThreadPageSyncDataEvent> insertSyncEventQueue = new ArrayList<ThreadPageSyncDataEvent>();
        ArrayList<ThreadPageSyncData> insertSyncDataQueue = new ArrayList<ThreadPageSyncData>();
        ArrayList<SyncData> insertSyncAPIQueue = new ArrayList<SyncData>();
        int i = 0;
        while (i < size) {
            ThreadPageSyncDataEvent event = this.syncEventQueueOfThread.get(0);
            String pid = Integer.toString(event.getContents().getPid());
            ThreadPageThreadData data = ThreadDataManager.getInstance().getThreadDataMaker().findParentDataOfThread(event.getTid());
            if (data != null) {
                String syncVal = event.getSyncVal();
                ThreadPageSyncData sync = data.findSyncData(syncVal);
                if (sync == null) {
                    Integer syncAttrTypeInt = this.syncAttrMap.get(syncVal);
                    String syncAttrType = syncAttrTypeInt != null ? ThreadSyncDataMaker.getAttrTypeByTypeInt(syncAttrTypeInt) : ThreadSyncDataMaker.getAttrTypeString(event);
                    sync = new ThreadPageSyncData(event.getType(), syncVal, pid, event.getTid(), syncAttrType, 2);
                    sync.setParentID(data.getThreadDataID());
                    this.chartRowData.add(sync);
                    data.pushSync(sync);
                    insertSyncDataQueue.add(sync);
                }
                event.setSyncDataID(sync.getSyncDataID());
                insertSyncEventQueue.add(event);
                if (ThreadPageSyncData.isSyncApi(event.getApiType())) {
                    insertSyncAPIQueue.add((SyncData)event.getContents());
                }
            }
            this.syncEventQueueOfThread.remove(0);
            ++i;
        }
        this.insertSyncEvent(insertSyncEventQueue);
        ThreadDataManager.getInstance().insertSyncData(insertSyncDataQueue, true);
        ThreadDataManager.getInstance().insertSyncAPIData(insertSyncAPIQueue, true);
    }

    private ThreadPageSyncData findParentData(String name) {
        int size = this.chartRowData.size();
        int i = 0;
        while (i < size) {
            ThreadPageSyncData ret = this.chartRowData.get(i);
            if (ret.getKey().equals(name) && ret.getSyncDataType() == 0) {
                return ret;
            }
            ++i;
        }
        return null;
    }

    public ThreadPageSyncData findParentData(int syncDataID) {
        int size = this.chartRowData.size();
        int i = 0;
        while (i < size) {
            ThreadPageSyncData ret = this.chartRowData.get(i);
            if (ret.getSyncDataID() == syncDataID && ret.getSyncDataType() == 0) {
                return ret;
            }
            ++i;
        }
        return null;
    }

    public static String getAttrTypeByTypeInt(int typeInt) {
        if (typeInt == 0) {
            return ThreadPageLabels.SYNC_ATTR_TYPE_NORMAL;
        }
        if (typeInt == 1) {
            return ThreadPageLabels.SYNC_ATTR_TYPE_RECURSIVE;
        }
        if (typeInt == 2) {
            return ThreadPageLabels.SYNC_ATTR_TYPE_ERRORCHECK;
        }
        if (typeInt == 3) {
            return ThreadPageLabels.SYNC_ATTR_TYPE_DEFAULT;
        }
        return "";
    }

    public static String getAttrTypeString(ThreadPageSyncDataEvent event) {
        int type = event.getType();
        if (type == 0) {
            return ThreadPageLabels.SYNC_ATTR_TYPE_RECURSIVE;
        }
        if (type == 3) {
            return ThreadPageLabels.SYNC_ATTR_TYPE_DEFAULT;
        }
        return "";
    }

    private void checkMutexAttrType(String input) {
        String[] temp = input.split(",");
        if (temp.length != 2) {
            return;
        }
        String obj = temp[0];
        String type = temp[1].trim();
        if (this.syncAttrMap.get(obj) != null) {
            this.syncAttrMap.put(obj, Integer.valueOf(type));
        }
    }

    private void checkMutexType(String input) {
        String[] temp = input.split(",");
        if (temp.length != 2) {
            return;
        }
        String obj = temp[0];
        String attrObj = temp[1].trim();
        Integer attrType = this.syncAttrMap.get(attrObj);
        if (attrType != null) {
            this.syncAttrMap.put(obj, attrType);
        }
    }

    public void insertNoBlockEndTimeSyncEvent() {
        ThreadDataManager.getInstance().insertSyncEventData(this.noBlockEndTimeSyncEventQueue, false);
    }

    private void insertSyncEvent(List<ThreadPageSyncDataEvent> insertSyncEventQueue) {
        this.makeBlockEndTime(insertSyncEventQueue);
        ThreadDataManager.getInstance().insertSyncEventData(insertSyncEventQueue, true);
    }

    private void makeBlockEndTime(List<ThreadPageSyncDataEvent> insertSyncEventQueue) {
        this.setBlockEndTimeOfInsertList(insertSyncEventQueue);
        this.updateNoBlockEndTimeList(insertSyncEventQueue);
        this.addInsertListFromNoBlockEndTimeList(insertSyncEventQueue);
    }

    private void setBlockEndTimeOfInsertList(List<ThreadPageSyncDataEvent> list) {
        this.setBlockEndTime(list, list);
        this.setBlockEndTime(this.noBlockEndTimeSyncEventQueue, list);
    }

    private void setBlockEndTimeOfNoBlockEndTimeList(List<ThreadPageSyncDataEvent> insertSyncEventQueue) {
        for (ThreadPageSyncDataEvent event : insertSyncEventQueue) {
            this.updateBlockEndTimeOfNotReleaseSyncEventQueue(event);
        }
    }

    private void setBlockEndTime(List<ThreadPageSyncDataEvent> targetList, List<ThreadPageSyncDataEvent> refList) {
        this.sortListByTime(targetList);
        for (ThreadPageSyncDataEvent targerEvent : targetList) {
            this.setBlockEndTime(targerEvent, refList);
        }
    }

    private void updateBlockEndTimeOfNotReleaseSyncEventQueue(ThreadPageSyncDataEvent event) {
        this.setBlockEndTime(event, this.noBlockEndTimeSyncEventQueue);
    }

    private void setBlockEndTime(ThreadPageSyncDataEvent targetEvent, List<ThreadPageSyncDataEvent> refList) {
        for (ThreadPageSyncDataEvent refEvent : refList) {
            if (targetEvent.equals(refEvent) || targetEvent.getSyncDataID() != refEvent.getSyncDataID() || targetEvent.getBlockEndTime() != -1L || targetEvent.getTime() >= refEvent.getTime() || !this.isMappingBlockTimeLog(targetEvent.getApiType(), refEvent.getApiType()) || targetEvent.getErrorNum() != 0L) continue;
            targetEvent.setBlockEndTime(refEvent.getTime());
            return;
        }
    }

    private void sortListByTime(List<ThreadPageSyncDataEvent> list) {
        Comparator<ThreadPageSyncDataEvent> comparator = new Comparator<ThreadPageSyncDataEvent>(){

            @Override
            public int compare(ThreadPageSyncDataEvent arg0, ThreadPageSyncDataEvent arg1) {
                if (arg0.getTime() > arg1.getTime()) {
                    return 1;
                }
                if (arg0.getTime() < arg1.getTime()) {
                    return -1;
                }
                return 0;
            }
        };
        Collections.sort(list, comparator);
    }

    private void updateNoBlockEndTimeList(List<ThreadPageSyncDataEvent> insertSyncEventQueue) {
        ArrayList<ThreadPageSyncDataEvent> removeEveneList = new ArrayList<ThreadPageSyncDataEvent>();
        int size = insertSyncEventQueue.size();
        int i = 0;
        while (i < size) {
            ThreadPageSyncDataEvent event = insertSyncEventQueue.get(i);
            if (event.getBlockEndTime() == -1L) {
                try {
                    removeEveneList.add(event);
                    this.noBlockEndTimeSyncEventQueue.add(event.clone());
                }
                catch (CloneNotSupportedException e) {
                    Logger.exception((Throwable)e);
                }
            }
            ++i;
        }
        insertSyncEventQueue.removeAll(removeEveneList);
        this.setBlockEndTimeOfNoBlockEndTimeList(insertSyncEventQueue);
    }

    private void addInsertListFromNoBlockEndTimeList(List<ThreadPageSyncDataEvent> insertSyncEventQueue) {
        ArrayList<ThreadPageSyncDataEvent> removeEveneList = new ArrayList<ThreadPageSyncDataEvent>();
        int size = this.noBlockEndTimeSyncEventQueue.size();
        int i = 0;
        while (i < size) {
            ThreadPageSyncDataEvent event = this.noBlockEndTimeSyncEventQueue.get(i);
            if (event.getBlockEndTime() != -1L || this.isRequireOnlyEventTimeLog(event.getApiType())) {
                try {
                    removeEveneList.add(event);
                    insertSyncEventQueue.add(event.clone());
                }
                catch (CloneNotSupportedException e) {
                    Logger.exception((Throwable)e);
                }
            }
            ++i;
        }
        this.noBlockEndTimeSyncEventQueue.removeAll(removeEveneList);
    }

    private boolean isRequireOnlyEventTimeLog(int apiType) {
        return apiType == 0 || apiType == 7 || apiType == 8 || apiType == 9;
    }

    private boolean isMappingBlockTimeLog(int targetType, int refAPIType) {
        if (targetType == 1 && refAPIType == 2) {
            return true;
        }
        if (targetType == 2 && refAPIType == 3) {
            return true;
        }
        if (targetType == 3 && refAPIType == 1) {
            return true;
        }
        if (targetType == 5 && refAPIType == 6) {
            return true;
        }
        if (targetType == 6 && refAPIType == 3) {
            return true;
        }
        if (targetType == 3 && refAPIType == 5) {
            return true;
        }
        return targetType == 4 && refAPIType == 3;
    }

    public void setChartRowData(ThreadPageSyncData data) {
        this.chartRowData.add(data);
    }

    public List<ThreadPageSyncData> getChartRowData() {
        ArrayList<ThreadPageSyncData> returnList = new ArrayList<ThreadPageSyncData>();
        for (ThreadPageSyncData data : this.chartRowData) {
            returnList.add(data);
        }
        return returnList;
    }

    public List<ThreadPageSyncData> getSyncParentChartRowData() {
        ArrayList<ThreadPageSyncData> returnList = new ArrayList<ThreadPageSyncData>();
        for (ThreadPageSyncData data : this.chartRowData) {
            if (data.getSyncDataType() != 0) continue;
            returnList.add(data);
        }
        return returnList;
    }

    public List<ThreadPageSyncDataEvent> getNotInsertSyncEventList() {
        return this.noBlockEndTimeSyncEventQueue;
    }

    public void clear() {
        this.noBlockEndTimeSyncEventQueue.clear();
        this.chartRowData.clear();
        this.syncEventQueue.clear();
        this.syncEventQueueOfThread.clear();
        this.syncAttrMap.clear();
        ThreadPageSyncData.clear();
    }
}

