/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.dynamicanalyzer.ui.timeline.chart;

import java.util.List;
import org.tizen.dynamicanalyzer.constant.CommonConstants;
import org.tizen.dynamicanalyzer.nl.TimelineChartLabels;
import org.tizen.dynamicanalyzer.resources.ColorResources;
import org.tizen.dynamicanalyzer.resources.FontResources;
import org.tizen.dynamicanalyzer.resources.ImageResources;
import org.tizen.dynamicanalyzer.ui.common.UIEventChartContextMenuItem;
import org.tizen.dynamicanalyzer.ui.timeline.UIEventDBTable;
import org.tizen.dynamicanalyzer.ui.timeline.chart.TimelineChart;
import org.tizen.dynamicanalyzer.ui.timeline.uievent.UIEventListDialog;
import org.tizen.dynamicanalyzer.util.Logger;
import org.tizen.dynamicanalyzer.util.WorkbenchUtil;
import org.tizen.dynamicanalyzer.widgets.chart.DAChartSeries;
import org.tizen.dynamicanalyzer.widgets.chart.DAChartSeriesItem;
import org.tizen.dynamicanalyzer.widgets.chartBoard.DAChartBoard;
import org.tizen.dynamicanalyzer.widgets.chartBoard.DAChartBoardItem;
import org.tizen.dynamicanalyzer.widgets.popupMenu.DAPopupMenuItem;
import org.tizen.dynamicanalyzer.widgets.popupMenu.DAPopupMenuListener;

public class UIEventChart
extends TimelineChart {
    private DAChartSeries touchEventSeries;
    private DAChartSeries gestureEventSeries;
    private DAChartSeries orientationEventSeries;
    private static final int TYPE_TOUCH = 2;
    private static final int TYPE_ORIENTATION = 4;
    private static final int TYPE_GESTURE_N_TAPS = 6;
    private static final int TYPE_GESTURE_N_DOUBLE_TAPS = 7;
    private static final int TYPE_GESTURE_N_TRIPLE_TAPS = 8;
    private static final int TYPE_GESTURE_N_LONG_TAPS = 9;
    private static final int TYPE_GESTURE_N_FLICKS = 10;
    private static final int TYPE_GESTURE_N_LINES = 11;
    private static final int TYPE_GESTURE_ZOOM = 12;
    private static final int TYPE_GESTURE_ROTATE = 13;
    private static final String NEW_LINE = CommonConstants.NEW_LINE;
    private UIEventListDialog uiEventListDialog = new UIEventListDialog(WorkbenchUtil.getWorkbenchWindow().getShell());

    public UIEventChart(String pageID) {
        super(pageID);
        this.chartType = -109;
        this.chartStyle = 2;
        this.probeType = 259;
        this.chartName = TimelineChartLabels.UI_EVENT_CHART_TITLE;
        this.chartDescriptor = TimelineChartLabels.UI_EVENT_CHART_DESCRIPTOR;
        this.chartIcon = ImageResources.FEATURE_UIEVENT_SMALL_NOR;
        this.addIcon = ImageResources.FEATURE_UIEVENT_SMALL_NOR;
        this.touchEventSeries = new DAChartSeries(TimelineChartLabels.UI_EVENT_CHART_SERIES_NAME_TOUCH, 10, ColorResources.CHART_SERIES_EMERALD);
        this.gestureEventSeries = new DAChartSeries(TimelineChartLabels.UI_EVENT_CHART_SERIES_NAME_GESTURE, 10, ColorResources.CHART_SERIES_BLUE);
        this.orientationEventSeries = new DAChartSeries(TimelineChartLabels.UI_EVENT_CHART_SERIES_NAME_ORIENTATION, 10, ColorResources.CHART_SERIES_RED);
        this.touchEventSeries.setFont(FontResources.TIMELINE_UIEVENT_FONT);
        this.gestureEventSeries.setFont(FontResources.TIMELINE_UIEVENT_FONT);
        this.orientationEventSeries.setFont(FontResources.TIMELINE_UIEVENT_FONT);
    }

    @Override
    public DAChartBoardItem createBoardItem(DAChartBoard board) {
        DAChartBoardItem item = super.createBoardItem(board);
        UIEventChartContextMenuItem eventListItem = new UIEventChartContextMenuItem(this.popupMenu);
        eventListItem.setText(TimelineChartLabels.RANGE_CONTEXT_EVENT_LIST);
        eventListItem.addListener(new DAPopupMenuListener(){

            public void widgetSelected(DAPopupMenuItem menuItem) {
                UIEventChart.this.uiEventListDialog.setSelectedEventInfo(UIEventChart.this.chart.getSeriesList());
                UIEventChart.this.uiEventListDialog.open();
            }
        });
        item.useExpand(false);
        this.chart.addSeries(this.touchEventSeries);
        this.chart.addSeries(this.gestureEventSeries);
        this.chart.addSeries(this.orientationEventSeries);
        this.setChartStyle();
        return item;
    }

    @Override
    public void inputChartSeries(List<Object> dataList) {
        this.touchEventSeries.clear();
        this.gestureEventSeries.clear();
        this.orientationEventSeries.clear();
        List data = (List)dataList.get(0);
        int i = 0;
        while (i < data.size()) {
            List row = (List)data.get(i);
            double time = (double)((Long)row.get(UIEventDBTable.COLUMN.EVENT_TIME.ordinal())).longValue() / 1000000.0;
            int eventType = (Integer)row.get(UIEventDBTable.COLUMN.EVENT_TYPE.ordinal());
            int detailType = (Integer)row.get(UIEventDBTable.COLUMN.DETAIL_TYPE.ordinal());
            int pointX = (Integer)row.get(UIEventDBTable.COLUMN.POINT_X.ordinal());
            int pointY = (Integer)row.get(UIEventDBTable.COLUMN.POINT_Y.ordinal());
            String info1 = (String)row.get(UIEventDBTable.COLUMN.INFO_STRING.ordinal());
            int info2 = (Integer)row.get(UIEventDBTable.COLUMN.INFO_INTEGER.ordinal());
            switch (eventType) {
                case 2: {
                    String info = String.valueOf(EnumTouchStatus.values()[detailType].getStatus()) + NEW_LINE + "X : " + pointX + " Y : " + pointY;
                    this.touchEventSeries.addSeriesItem(new DAChartSeriesItem(time, 0.0, info));
                    break;
                }
                case 4: {
                    this.orientationEventSeries.addSeriesItem(new DAChartSeriesItem(time, 0.0, String.valueOf(TimelineChartLabels.UIEVENT_ORIENTATION) + "   " + EnumOrientationStatus.values()[info2].getStatus()));
                    break;
                }
                case 6: {
                    this.gestureEventSeries.addSeriesItem(new DAChartSeriesItem(time, 0.0, this.getTapGestureInfo(TimelineChartLabels.UIEVENT_GESTURE_TAP, detailType, pointX, pointY, info2)));
                    break;
                }
                case 7: {
                    this.gestureEventSeries.addSeriesItem(new DAChartSeriesItem(time, 0.0, this.getTapGestureInfo(TimelineChartLabels.UIEVENT_GESTURE_DOUBLE_TAP, detailType, pointX, pointY, info2)));
                    break;
                }
                case 8: {
                    this.gestureEventSeries.addSeriesItem(new DAChartSeriesItem(time, 0.0, this.getTapGestureInfo(TimelineChartLabels.UIEVENT_GESTURE_TRIPLE_TAP, detailType, pointX, pointY, info2)));
                    break;
                }
                case 9: {
                    this.gestureEventSeries.addSeriesItem(new DAChartSeriesItem(time, 0.0, this.getTapGestureInfo(TimelineChartLabels.UIEVENT_GESTURE_LONG_TAP, detailType, pointX, pointY, info2)));
                    break;
                }
                case 10: {
                    this.gestureEventSeries.addSeriesItem(new DAChartSeriesItem(time, 0.0, this.getFlickGestureInfo(TimelineChartLabels.UIEVENT_GESTURE_FLICK, detailType, pointX, pointY, info1, info2)));
                    break;
                }
                case 11: {
                    this.gestureEventSeries.addSeriesItem(new DAChartSeriesItem(time, 0.0, this.getFlickGestureInfo(TimelineChartLabels.UIEVENT_GESTURE_LINE, detailType, pointX, pointY, info1, info2)));
                    break;
                }
                case 12: {
                    this.gestureEventSeries.addSeriesItem(new DAChartSeriesItem(time, 0.0, this.getZoomGestureInfo(TimelineChartLabels.UIEVENT_GESTURE_ZOOM, detailType, pointX, pointY, info1, info2)));
                    break;
                }
                case 13: {
                    this.gestureEventSeries.addSeriesItem(new DAChartSeriesItem(time, 0.0, this.getRotateGestureInfo(TimelineChartLabels.UIEVENT_GESTURE_ROTATE, detailType, pointX, pointY, info1, info2)));
                    break;
                }
            }
            ++i;
        }
    }

    private String getTapGestureInfo(String eventType, int detailType, int pointX, int pointY, int info2) {
        return String.valueOf(eventType) + "  " + EnumGestureStatus.values()[detailType].getStatus() + NEW_LINE + "X : " + pointX + " Y : " + pointY + NEW_LINE + TimelineChartLabels.UIEVENT_INFO_FINGER_COUNT + " : " + info2;
    }

    private String getFlickGestureInfo(String eventType, int detailType, int startX, int startY, String info1, int info2) {
        String[] splitInfo = info1.split(", ");
        if (splitInfo == null || splitInfo.length != 4) {
            Logger.error((Object)("Flick Gesture info format is not correct : " + info1));
            return "";
        }
        int distanceX = Integer.parseInt(splitInfo[0]) - startX;
        int distanceY = Integer.parseInt(splitInfo[1]) - startY;
        return String.valueOf(eventType) + "  " + EnumGestureStatus.values()[detailType].getStatus() + NEW_LINE + TimelineChartLabels.UIEVENT_INFO_DISTANCE + "(X, Y) : (" + distanceX + " , " + distanceY + ")" + NEW_LINE + TimelineChartLabels.UIEVENT_INFO_MOMENTUM + "(X, Y) : (" + splitInfo[2] + " , " + splitInfo[3] + ")" + NEW_LINE + TimelineChartLabels.UIEVENT_INFO_ANGLE + " : " + info2;
    }

    private String getZoomGestureInfo(String eventType, int detailType, int pointX, int pointY, String info1, int info2) {
        String[] splitInfo = info1.split(", ");
        if (splitInfo == null || splitInfo.length != 2) {
            Logger.error((Object)("Zoom Gesture info format is not correct : " + info1));
            return "";
        }
        return String.valueOf(eventType) + "  " + EnumGestureStatus.values()[detailType].getStatus() + NEW_LINE + TimelineChartLabels.UIEVENT_INFO_CENTER + "(X, Y) : (" + pointX + " , " + pointY + ")" + NEW_LINE + TimelineChartLabels.UIEVENT_INFO_RADIUS + " : " + info2 + NEW_LINE + TimelineChartLabels.UIEVENT_INFO_ZOOM_VALUE + " : " + splitInfo[0] + NEW_LINE + TimelineChartLabels.UIEVENT_INFO_MOMENTUM + " : " + splitInfo[1];
    }

    private String getRotateGestureInfo(String eventType, int detailType, int pointX, int pointY, String info1, int info2) {
        String[] splitInfo = info1.split(", ");
        if (splitInfo == null || splitInfo.length != 3) {
            Logger.error((Object)("Rotate Gesture info format is not correct : " + info1));
            return "";
        }
        return String.valueOf(eventType) + "  " + EnumGestureStatus.values()[detailType].getStatus() + NEW_LINE + TimelineChartLabels.UIEVENT_INFO_CENTER + "(X, Y) : (" + pointX + " , " + pointY + ")" + NEW_LINE + TimelineChartLabels.UIEVENT_INFO_RADIUS + " : " + info2 + NEW_LINE + TimelineChartLabels.UIEVENT_INFO_ANGLE + " : " + splitInfo[1] + NEW_LINE + TimelineChartLabels.UIEVENT_INFO_MOMENTUM + " : " + splitInfo[2];
    }

    private static enum EnumGestureStatus {
        START(TimelineChartLabels.UIEVENT_GESTURE_STATUS_START),
        MOVE(TimelineChartLabels.UIEVENT_GESTURE_STATUS_MOVE),
        END(TimelineChartLabels.UIEVENT_GESTURE_STATUS_END),
        ABORT(TimelineChartLabels.UIEVENT_GESTURE_STATUS_ABORT);

        private String status;

        private EnumGestureStatus(String status) {
            this.status = status;
        }

        private String getStatus() {
            return this.status;
        }
    }

    private static enum EnumOrientationStatus {
        NONE(TimelineChartLabels.UIEVENT_ORIENTATION_NONE),
        PORTRAIT(TimelineChartLabels.UIEVENT_ORIENTATION_PORTRAIT),
        LANDSCAPE(TimelineChartLabels.UIEVENT_ORIENTATION_LANDSCAPE),
        PORTRAIT_REVERSE(TimelineChartLabels.UIEVENT_ORIENTATION_PORTRAIT_REVERSE),
        LANDSCAPE_REVERSE(TimelineChartLabels.UIEVENT_ORIENTATION_LANDSCAPE_REVERSE);

        private String status;

        private EnumOrientationStatus(String status) {
            this.status = status;
        }

        private String getStatus() {
            return this.status;
        }
    }

    private static enum EnumTouchStatus {
        PRESSED(TimelineChartLabels.UIEVENT_TOUCH_LONG_PRESSED),
        LONG_PRESSED(TimelineChartLabels.UIEVENT_TOUCH_LONG_PRESSED),
        RELEASED(TimelineChartLabels.UIEVENT_TOUCH_RELEASED),
        MOVED(TimelineChartLabels.UIEVENT_TOUCH_MOVED),
        DOUBLE_PRESSED(TimelineChartLabels.UIEVENT_TOUCH_DOUBLE_PRESSED),
        FOCUS_IN(TimelineChartLabels.UIEVENT_TOUCH_FOCUS_IN),
        FOCUS_OUT(TimelineChartLabels.UIEVENT_TOUCH_FOCUS_OUT),
        CANCELED(TimelineChartLabels.UIEVENT_TOUCH_CANCELED);

        private String status;

        private EnumTouchStatus(String status) {
            this.status = status;
        }

        private String getStatus() {
            return this.status;
        }
    }
}

