/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.dom.parser.c;

import org.eclipse.cdt.core.dom.ast.ASTVisitor;
import org.eclipse.cdt.core.dom.ast.IASTExpression;
import org.eclipse.cdt.core.dom.ast.IASTInitializerClause;
import org.eclipse.cdt.core.dom.ast.IASTNode;
import org.eclipse.cdt.core.dom.ast.IASTReturnStatement;
import org.eclipse.cdt.internal.core.dom.parser.ASTNode;
import org.eclipse.cdt.internal.core.dom.parser.IASTAmbiguityParent;

public class CASTReturnStatement
extends ASTNode
implements IASTReturnStatement,
IASTAmbiguityParent {
    private IASTExpression retValue;

    public CASTReturnStatement() {
    }

    public CASTReturnStatement(IASTExpression retValue) {
        this.setReturnValue(retValue);
    }

    public CASTReturnStatement copy() {
        return this.copy(IASTNode.CopyStyle.withoutLocations);
    }

    public CASTReturnStatement copy(IASTNode.CopyStyle style) {
        CASTReturnStatement copy = new CASTReturnStatement(this.retValue == null ? null : this.retValue.copy(style));
        copy.setOffsetAndLength(this);
        if (style == IASTNode.CopyStyle.withLocations) {
            copy.setCopyLocation(this);
        }
        return copy;
    }

    public IASTExpression getReturnValue() {
        return this.retValue;
    }

    public void setReturnValue(IASTExpression returnValue) {
        this.assertNotFrozen();
        this.retValue = returnValue;
        if (returnValue != null) {
            returnValue.setParent(this);
            returnValue.setPropertyInParent(RETURNVALUE);
        }
    }

    public IASTInitializerClause getReturnArgument() {
        return this.getReturnValue();
    }

    public void setReturnArgument(IASTInitializerClause returnValue) {
        if (returnValue instanceof IASTExpression) {
            this.setReturnValue((IASTExpression)returnValue);
        } else {
            this.setReturnValue(null);
        }
    }

    public boolean accept(ASTVisitor action) {
        if (action.shouldVisitStatements) {
            switch (action.visit(this)) {
                case 2: {
                    return false;
                }
                case 1: {
                    return true;
                }
            }
        }
        if (this.retValue != null && !this.retValue.accept(action)) {
            return false;
        }
        if (action.shouldVisitStatements) {
            switch (action.leave(this)) {
                case 2: {
                    return false;
                }
                case 1: {
                    return true;
                }
            }
        }
        return true;
    }

    public void replace(IASTNode child, IASTNode other) {
        if (child == this.retValue) {
            other.setPropertyInParent(child.getPropertyInParent());
            other.setParent(child.getParent());
            this.retValue = (IASTExpression)other;
        }
    }
}

