#!/bin/bash -x
## User Define for desktop menu
desktopfile=${HOME}/.local/share/applications/tizen-studio-dynamicanalyzer.desktop
iconfile=tizen-sdk-dynamicanalyzer.ico
da_path=tools/dynamic-analyzer
exefile=dynamic-analyzer
comment="Dynamic Analyzer of Tizen Studio"
name="Dynamic Analyzer"

## Do not modify the followings (Make desktop menu)
TIZEN_SDK_INSTALL_PATH=${INSTALLED_PATH}
exepath=$TIZEN_SDK_INSTALL_PATH/${da_path}/$exefile
da_resources_path=${TIZEN_SDK_INSTALL_PATH}/${da_path}/resources
da_icons_path=${da_resources_path}/icons
categoryfile=${MENU_DIRECTORY_PATH}

chmod 755 ${exepath}

## Register start menu
if [ -e "${MAKESHORTCUT_PATH}" ]
then
    "${MAKESHORTCUT_PATH}" -f "${desktopfile}" -e "${exepath}" -i "${da_icons_path}/${iconfile}" -n "${name}" -c "${comment}"
fi

exit 0
