/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.dynamicanalyzer.ui.info.appStartup;

import java.util.ArrayList;
import java.util.List;
import org.tizen.dynamicanalyzer.database.DBInserter;
import org.tizen.dynamicanalyzer.swap.logparser.LogPackage;
import org.tizen.dynamicanalyzer.swap.logparser.Logs;
import org.tizen.dynamicanalyzer.swap.logparser.PageDataManager;
import org.tizen.dynamicanalyzer.swap.model.data.AppStartupData;
import org.tizen.dynamicanalyzer.swap.model.data.LogData;
import org.tizen.dynamicanalyzer.ui.info.appStartup.AppStartupDBTable;
import org.tizen.dynamicanalyzer.util.Logger;

public class AppStartupDataManager
extends PageDataManager {
    private static AppStartupDataManager instance = null;
    private AppStartupDBTable appStartupDBTable = new AppStartupDBTable();
    private DBInserter appStartupDBInserter = this.makeInserter(this.appStartupDBTable);
    private DBInserter webAppStartupDBInserter = null;

    private AppStartupDataManager() {
    }

    public AppStartupDBTable getAppStartupDBTable() {
        return this.appStartupDBTable;
    }

    public static synchronized AppStartupDataManager getInstance() {
        if (instance == null) {
            instance = new AppStartupDataManager();
        }
        return instance;
    }

    @Override
    protected void makeData(LogPackage pack) {
        Logs entryLogs = pack.getLogs(25);
        this.makeNativeData(entryLogs);
    }

    private void makeNativeData(Logs entryLogs) {
        if (entryLogs != null && entryLogs.getRawLogs().size() != 0) {
            List<LogData> logList = entryLogs.getLogs();
            ArrayList insertDataList = new ArrayList();
            int size = logList.size();
            int i = 0;
            while (i < size) {
                AppStartupData data = (AppStartupData)logList.get(i);
                ArrayList<Number> insertRowData = new ArrayList<Number>();
                try {
                    insertRowData.add(new Long(data.getSeq()));
                    insertRowData.add(new Integer(data.getPid()));
                    insertRowData.add(new Integer(data.getstageID()));
                    insertRowData.add(new Long(data.getStartTime()));
                    insertRowData.add(new Long(data.getEndTime()));
                }
                catch (ArrayIndexOutOfBoundsException e) {
                    Logger.exception((Throwable)e);
                }
                insertDataList.add(insertRowData);
                ++i;
            }
            if (insertDataList.size() > 0) {
                this.appStartupDBInserter.pushData(insertDataList);
            }
        }
    }
}

