/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.dynamicanalyzer.ui.info.callstack;

import org.tizen.dynamicanalyzer.common.Global;

public class CallStackUnit {
    private long address;
    private long callerAddress;
    private int pid;
    private int tid;
    private long time;
    private int functionID;
    private int binaryID;
    private String path;
    private String functionName;

    public CallStackUnit(long addr, long callerAddr, int pid, int tid, long time, int functionID) {
        this.address = addr;
        this.callerAddress = callerAddr;
        this.pid = pid;
        this.tid = tid;
        this.time = time;
        this.functionID = functionID;
        this.binaryID = Global.getBinaryID(pid, time, addr);
        this.functionName = functionID > 0 ? Global.getFunctionName(functionID) : "~~ internal library ~~";
        this.path = Global.getLibraryName(this.binaryID);
    }

    public CallStackUnit(long addr, long callerAddr, int pid, int tid, long time, int functionID, int binaryID, String functionName, String path) {
        this.address = addr;
        this.callerAddress = callerAddr;
        this.pid = pid;
        this.tid = tid;
        this.time = time;
        this.functionID = functionID;
        this.binaryID = binaryID;
        this.functionName = functionName;
        this.path = path;
    }

    public CallStackUnit() {
        this.functionName = "~~ internal library ~~";
        this.path = "~~ internal library ~~";
    }

    public CallStackUnit(String symbol) {
        this.functionName = "";
        this.path = symbol;
    }

    public long getAddr() {
        return this.address;
    }

    public long getCallerAddress() {
        return this.callerAddress;
    }

    public String getSymbol() {
        return this.functionName.isEmpty() ? this.path : String.valueOf(this.path) + "(" + this.functionName;
    }

    public void setAddr(long addr) {
        this.address = addr;
    }

    public void setCallerAddress(long addr) {
        this.callerAddress = addr;
    }

    public String getFunctionName() {
        return this.functionName;
    }

    public int getFunctionId() {
        return this.functionID;
    }

    public String getPath() {
        return this.path;
    }

    public long getTime() {
        return this.time;
    }

    public void setTime(long time) {
        this.time = time;
    }

    public int getPid() {
        return this.pid;
    }

    public void setPid(int pid) {
        this.pid = pid;
    }

    public int getBinaryID() {
        return this.binaryID;
    }

    public int getTid() {
        return this.tid;
    }

    public void setTid(int tid) {
        this.tid = tid;
    }
}

