/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.dynamicanalyzer.ui.opengl.chart.listener;

import java.util.Timer;
import java.util.TimerTask;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.MouseMoveListener;
import org.eclipse.swt.events.MouseTrackListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Path;
import org.eclipse.swt.widgets.Display;
import org.tizen.dynamicanalyzer.resources.ColorResources;
import org.tizen.dynamicanalyzer.widgets.chart.DAChart;
import org.tizen.dynamicanalyzer.widgets.chart.DAChartPlot;

public class GLFrameTimeBoundMouseListener
implements MouseListener,
MouseMoveListener,
MouseTrackListener {
    private static final int POINT_MAX_SIZE = 12;
    private static final int HOLE_INIT_SIZE = -4;
    private static final int LINE_MAX_WIDTH = 4;
    private static final int LINE_INIT_WIDTH = 2;
    private static final double UPPER_LINE_INIT_POSITION = 0.01;
    private static final double UNDER_LINE_INIT_POSITION = 0.99;
    private static final Color LINE_COLOR = ColorResources.DARK_YELLOW;
    private DAChart chart;
    private DAChartPlot plot;
    private Timer timer;
    private int pointSize = 0;
    private int holeSize = -4;
    private int pointPositionX;
    private int pointPositionY;
    private int boundLineWidth = 2;
    private double boundValue = -1.0;
    private boolean isExpanded = false;
    private boolean isDirty = false;

    public GLFrameTimeBoundMouseListener(final DAChart chart, final DAChartPlot.BoundType boundType) {
        this.chart = chart;
        this.plot = chart.getPlot();
        this.plot.setBoundType(boundType);
        this.chart.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent e) {
                double max = GLFrameTimeBoundMouseListener.this.plot.getVisibleEndY();
                if (boundType == DAChartPlot.BoundType.UPPER && !GLFrameTimeBoundMouseListener.this.isDirty) {
                    GLFrameTimeBoundMouseListener.this.boundValue = max * 0.9;
                    GLFrameTimeBoundMouseListener.this.plot.setBoundValue(GLFrameTimeBoundMouseListener.this.boundValue);
                }
                if (!GLFrameTimeBoundMouseListener.this.isExpanded) {
                    GLFrameTimeBoundMouseListener.this.plot.setBoundExpanded(false);
                    GLFrameTimeBoundMouseListener.this.drawBoundLine(e.gc, LINE_COLOR, GLFrameTimeBoundMouseListener.this.boundLineWidth, GLFrameTimeBoundMouseListener.this.boundValue);
                    if (GLFrameTimeBoundMouseListener.this.pointSize == 12 && GLFrameTimeBoundMouseListener.this.boundLineWidth == 4) {
                        int chartHeight = chart.getBounds().height;
                        String boundText = String.valueOf(String.valueOf(GLFrameTimeBoundMouseListener.this.boundValue)) + GLFrameTimeBoundMouseListener.this.plot.getAxisUnit();
                        int boundTextHeight = e.gc.textExtent((String)boundText).y;
                        double linePosition = 1.0 - GLFrameTimeBoundMouseListener.this.boundValue / max;
                        int boundTextPosition = (double)chartHeight * linePosition > (double)(chartHeight - boundTextHeight) ? (int)Math.round((double)chartHeight * linePosition - (double)boundTextHeight) : (int)Math.round((double)chartHeight * linePosition);
                        e.gc.setForeground(LINE_COLOR);
                        if (boundTextPosition > 0) {
                            e.gc.drawString(boundText, 0, boundTextPosition, true);
                        } else {
                            e.gc.drawString("^" + boundText, 0, 0, true);
                        }
                    }
                } else {
                    GLFrameTimeBoundMouseListener.this.plot.setBoundExpanded(true);
                }
                e.gc.setBackground(ColorResources.RED);
                if (GLFrameTimeBoundMouseListener.this.pointSize > 3) {
                    Path path = new Path((Device)Display.getDefault());
                    path.addArc((float)(GLFrameTimeBoundMouseListener.this.pointPositionX - GLFrameTimeBoundMouseListener.this.pointSize / 2), (float)(GLFrameTimeBoundMouseListener.this.pointPositionY - GLFrameTimeBoundMouseListener.this.pointSize / 2), (float)GLFrameTimeBoundMouseListener.this.pointSize, (float)GLFrameTimeBoundMouseListener.this.pointSize, 0.0f, 360.0f);
                    path.addArc((float)(GLFrameTimeBoundMouseListener.this.pointPositionX - GLFrameTimeBoundMouseListener.this.holeSize / 2), (float)(GLFrameTimeBoundMouseListener.this.pointPositionY - GLFrameTimeBoundMouseListener.this.holeSize / 2), (float)GLFrameTimeBoundMouseListener.this.holeSize, (float)GLFrameTimeBoundMouseListener.this.holeSize, 0.0f, 360.0f);
                    e.gc.fillPath(path);
                    path.dispose();
                }
            }
        });
    }

    private void drawBoundLine(GC gc, Color lineColor, int lineWidth, double lineValue) {
        gc.setForeground(lineColor);
        gc.setLineWidth(lineWidth);
        int y = (int)Math.round((double)this.chart.getBounds().height * (1.0 - lineValue / this.plot.getVisibleEndY()));
        gc.drawLine(1, y, this.chart.getBounds().width - 1, y);
    }

    public void mouseDoubleClick(MouseEvent e) {
    }

    public void mouseDown(final MouseEvent e) {
        if (e.button == 3) {
            if (this.timer != null) {
                this.timer.cancel();
                this.pointSize = 0;
                this.holeSize = -4;
                this.boundLineWidth = 2;
            }
            return;
        }
        this.timer = new Timer("Animation timer");
        this.timer.schedule(new TimerTask(){

            @Override
            public void run() {
                if (GLFrameTimeBoundMouseListener.this.pointSize != 12) {
                    GLFrameTimeBoundMouseListener.this.pointPositionX = e.x;
                    GLFrameTimeBoundMouseListener.this.pointPositionY = e.y;
                    GLFrameTimeBoundMouseListener gLFrameTimeBoundMouseListener = GLFrameTimeBoundMouseListener.this;
                    gLFrameTimeBoundMouseListener.pointSize = gLFrameTimeBoundMouseListener.pointSize + 2;
                    GLFrameTimeBoundMouseListener gLFrameTimeBoundMouseListener2 = GLFrameTimeBoundMouseListener.this;
                    gLFrameTimeBoundMouseListener2.holeSize = gLFrameTimeBoundMouseListener2.holeSize + 2;
                    Display.getDefault().asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            double max = GLFrameTimeBoundMouseListener.this.plot.getVisibleEndY();
                            double linePosition = 1.0 - GLFrameTimeBoundMouseListener.this.boundValue / max;
                            int gap = (int)Math.round(Math.abs((double)e.y - (double)((GLFrameTimeBoundMouseListener)(this).GLFrameTimeBoundMouseListener.this).chart.getBounds().height * linePosition));
                            if (max != GLFrameTimeBoundMouseListener.this.plot.getVisibleStartY() && (gap < 5 || GLFrameTimeBoundMouseListener.this.boundValue > max && e.y <= 5)) {
                                GLFrameTimeBoundMouseListener.this.boundLineWidth = (int)(4.0 / (12.0 / (double)GLFrameTimeBoundMouseListener.this.pointSize));
                                GLFrameTimeBoundMouseListener.this.redrawLineArea();
                                if (GLFrameTimeBoundMouseListener.this.boundLineWidth == 4) {
                                    GLFrameTimeBoundMouseListener.this.isDirty = true;
                                }
                            }
                            GLFrameTimeBoundMouseListener.this.redrawPointArea();
                        }
                    });
                } else if (GLFrameTimeBoundMouseListener.this.boundLineWidth == 2 && GLFrameTimeBoundMouseListener.this.holeSize < 12) {
                    GLFrameTimeBoundMouseListener gLFrameTimeBoundMouseListener = GLFrameTimeBoundMouseListener.this;
                    gLFrameTimeBoundMouseListener.holeSize = gLFrameTimeBoundMouseListener.holeSize + 2;
                    Display.getDefault().asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            GLFrameTimeBoundMouseListener.this.redrawPointArea();
                        }
                    });
                }
            }
        }, 0L, 40L);
    }

    public void mouseUp(MouseEvent e) {
        if (this.timer != null) {
            this.timer.cancel();
            this.pointSize = 0;
            this.holeSize = -4;
            this.boundLineWidth = 2;
            this.redrawPointArea();
            this.redrawLineArea();
        }
    }

    public void mouseMove(MouseEvent e) {
        if (this.timer != null) {
            this.timer.cancel();
        }
        if (this.boundLineWidth == 4 && !this.isExpanded) {
            this.pointPositionX = e.x;
            this.pointPositionY = e.y;
            double position = (double)e.y / (double)this.chart.getBounds().height;
            if (this.boundLineWidth == 4) {
                if (position > 0.99) {
                    position = 0.99;
                } else if (position < 0.01) {
                    position = 0.02;
                }
                this.boundValue = Math.round(this.plot.getVisibleEndY() * (1.0 - position));
                this.plot.setBoundValue(this.boundValue);
            }
        } else {
            this.pointSize = 0;
            this.holeSize = -4;
            this.boundLineWidth = 2;
        }
        this.redrawPointArea();
        this.redrawLineArea();
    }

    public void mouseEnter(MouseEvent e) {
    }

    public void mouseExit(MouseEvent e) {
    }

    public void mouseHover(MouseEvent e) {
    }

    private void redrawPointArea() {
        this.chart.redraw(this.pointPositionX - 6, this.pointPositionY - 6, 12, 12, false);
    }

    private void redrawLineArea() {
        double linePosition = 1.0 - this.boundValue / this.plot.getVisibleEndY();
        this.chart.redraw(0, (int)Math.round((double)this.chart.getBounds().height * linePosition) - 4, this.chart.getBounds().width, (int)Math.round((double)this.chart.getBounds().height * linePosition) + 4, false);
    }
}

