/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.dynamicanalyzer.ui.toolbar;

import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.program.Program;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Shell;
import org.tizen.dynamicanalyzer.common.AboutInfo;
import org.tizen.dynamicanalyzer.nl.AnalyzerLabels;
import org.tizen.dynamicanalyzer.nl.WidgetLabels;
import org.tizen.dynamicanalyzer.resources.ColorResources;
import org.tizen.dynamicanalyzer.resources.FontResources;
import org.tizen.dynamicanalyzer.resources.ImageResources;
import org.tizen.dynamicanalyzer.shortcut.ShortCutManager;
import org.tizen.dynamicanalyzer.util.CommonUtil;
import org.tizen.dynamicanalyzer.util.Logger;
import org.tizen.dynamicanalyzer.widgets.da.base.DAMessageBox;

public class AboutDialog
extends DAMessageBox {
    private static boolean opened = false;
    private Composite mainContentsComp = null;
    private Composite buttonContentsComp = null;
    private Composite titleCotentsComp = null;
    private final int WIDTH = 430;
    private final int HEIGHT = 310;

    public AboutDialog(Shell parent) {
        super(parent);
    }

    protected boolean run() {
        if (opened) {
            return false;
        }
        int dialogLocationX = this.shell.getParent().getLocation().x + (this.shell.getParent().getSize().x - 430) / 2;
        int dialogLocationY = this.shell.getParent().getLocation().y + (this.shell.getParent().getSize().y - 310) / 2;
        this.shell.setLocation(dialogLocationX, dialogLocationY);
        this.shell.setSize(430, 310);
        this.shell.setLayout((Layout)new FormLayout());
        this.shell.setText(AnalyzerLabels.ABOUT_DIALOG_TITLE);
        this.shell.setImage(ImageResources.DYNANMIC_ANALYZER_ICON);
        this.shell.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent arg0) {
                opened = false;
                ShortCutManager.getInstance().setEnabled(!opened);
            }
        });
        this.titleCotentsComp = new Composite((Composite)this.shell, 0);
        this.mainContentsComp = new Composite((Composite)this.shell, 0);
        Composite marginMiddle = new Composite((Composite)this.shell, 0);
        this.buttonContentsComp = new Composite((Composite)this.shell, 0);
        this.titleCotentsComp.setLayout((Layout)new FormLayout());
        FormData form = new FormData();
        form.top = new FormAttachment(0, 0);
        form.left = new FormAttachment(0, 0);
        form.right = new FormAttachment(100, 0);
        form.height = 90;
        this.titleCotentsComp.setLayoutData((Object)form);
        this.titleCotentsComp.setBackground(ColorResources.DIALOG_TOP_LINE_COLOR);
        this.mainContentsComp.setLayout((Layout)new FormLayout());
        form = new FormData();
        form.top = new FormAttachment((Control)this.titleCotentsComp, 0);
        form.left = new FormAttachment(0, 0);
        form.right = new FormAttachment(100, 0);
        form.bottom = new FormAttachment(100, -61);
        this.mainContentsComp.setLayoutData((Object)form);
        this.mainContentsComp.setBackground(ColorResources.DIALOG_CONTENT_BACKGROUND);
        marginMiddle.setLayout((Layout)new FormLayout());
        form = new FormData();
        form.top = new FormAttachment((Control)this.mainContentsComp, 0);
        form.left = new FormAttachment(0, 0);
        form.right = new FormAttachment(100, 0);
        form.bottom = new FormAttachment(100, -60);
        marginMiddle.setLayoutData((Object)form);
        marginMiddle.setBackground(ColorResources.DIALOG_MIDDLE_LINE_COLOR);
        this.buttonContentsComp.setLayout((Layout)new FormLayout());
        form = new FormData();
        form.top = new FormAttachment((Control)marginMiddle, 0);
        form.left = new FormAttachment(0, 0);
        form.right = new FormAttachment(100, 0);
        form.bottom = new FormAttachment(100, 0);
        this.buttonContentsComp.setLayoutData((Object)form);
        this.buttonContentsComp.setBackground(ColorResources.WHITE);
        this.drawTitleContents();
        this.drawMainContents();
        this.drawButtons();
        opened = true;
        ShortCutManager.getInstance().setEnabled(!opened);
        return true;
    }

    private void drawTitleContents() {
        final Image titleimage = ImageResources.EMULATOR_TITLE_BG_02;
        this.titleCotentsComp.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent arg0) {
                arg0.gc.drawImage(titleimage, 0, 0);
                arg0.gc.setForeground(ColorResources.WHITE);
                if (CommonUtil.isMac()) {
                    arg0.gc.setFont(FontResources.ABOUT_DIALOG_TITLE_MIDDLE_FONT_MAC);
                } else {
                    arg0.gc.setFont(FontResources.ABOUT_DIALOG_TITLE_MIDDLE_FONT);
                }
                arg0.gc.drawString(AnalyzerLabels.ABOUT_DIALOG_TIZEN, 28, 20, true);
                if (CommonUtil.isMac()) {
                    arg0.gc.setFont(FontResources.ABOUT_DIALOG_TITLE_BIG_FONT_MAC);
                } else {
                    arg0.gc.setFont(FontResources.ABOUT_DIALOG_TITLE_BIG_FONT);
                }
                arg0.gc.drawString(AnalyzerLabels.ABOUT_DIALOG_DA, 28, 40, true);
            }
        });
    }

    private void drawMainContents() {
        AboutInfo info = AboutInfo.getInstance();
        Composite contents = new Composite(this.mainContentsComp, 0);
        FormData form = new FormData();
        form.top = new FormAttachment(0, 22);
        form.left = new FormAttachment(0, 20);
        form.bottom = new FormAttachment(100, -15);
        form.width = 104;
        contents.setLayoutData((Object)form);
        contents.setBackground(ColorResources.DIALOG_CONTENT_BACKGROUND);
        Composite valuecontents = new Composite(this.mainContentsComp, 0);
        form = new FormData();
        form.top = new FormAttachment(0, 22);
        form.left = new FormAttachment((Control)contents, 47);
        form.bottom = new FormAttachment(100, -17);
        form.width = 200;
        valuecontents.setLayoutData((Object)form);
        valuecontents.setBackground(ColorResources.DIALOG_CONTENT_BACKGROUND);
        RowLayout layout = new RowLayout(512);
        layout.justify = true;
        contents.setLayout((Layout)layout);
        valuecontents.setLayout((Layout)layout);
        Label daversion = new Label(contents, 16384);
        daversion.setFont(FontResources.DIALOG_CONTENTS_BOLD_FONT);
        daversion.setBackground(ColorResources.DIALOG_CONTENT_BACKGROUND);
        daversion.setForeground(ColorResources.DEFAULT_FONT_COLOR);
        daversion.setText(AnalyzerLabels.ABOUT_DIALOG_DA_VERSION);
        ((FormData)contents.getLayoutData()).top = new FormAttachment(0, 17);
        Label buildtime = new Label(contents, 16384);
        buildtime.setFont(FontResources.DIALOG_CONTENTS_BOLD_FONT);
        buildtime.setBackground(ColorResources.DIALOG_CONTENT_BACKGROUND);
        buildtime.setForeground(ColorResources.DEFAULT_FONT_COLOR);
        buildtime.setText(AnalyzerLabels.ABOUT_DIALOG_BUILD_TIME);
        Label tizensite = new Label(contents, 16384);
        tizensite.setFont(FontResources.DIALOG_CONTENTS_BOLD_FONT);
        tizensite.setBackground(ColorResources.DIALOG_CONTENT_BACKGROUND);
        tizensite.setForeground(ColorResources.DEFAULT_FONT_COLOR);
        tizensite.setText(AnalyzerLabels.ABOUT_DIALOG_TIZEN_SITE);
        ((FormData)contents.getLayoutData()).bottom = new FormAttachment(100, -22);
        Label releasenote = new Label(contents, 16384);
        releasenote.setFont(FontResources.DIALOG_CONTENTS_BOLD_FONT);
        releasenote.setBackground(ColorResources.DIALOG_CONTENT_BACKGROUND);
        releasenote.setForeground(ColorResources.DEFAULT_FONT_COLOR);
        releasenote.setText(AnalyzerLabels.ABOUT_DIALOG_RELEASE_NOTE);
        Label daversionvalue = new Label(valuecontents, 16384);
        daversionvalue.setFont(FontResources.DIALOG_CONTENTS_NORMAL_FONT);
        daversionvalue.setBackground(ColorResources.DIALOG_CONTENT_BACKGROUND);
        daversionvalue.setForeground(ColorResources.DEFAULT_FONT_COLOR);
        daversionvalue.setText(info.getDAVersion());
        ((FormData)valuecontents.getLayoutData()).top = new FormAttachment(0, 17);
        Label buildtimevalue = new Label(valuecontents, 16384);
        buildtimevalue.setFont(FontResources.DIALOG_CONTENTS_NORMAL_FONT);
        buildtimevalue.setBackground(ColorResources.DIALOG_CONTENT_BACKGROUND);
        buildtimevalue.setForeground(ColorResources.DEFAULT_FONT_COLOR);
        buildtimevalue.setText(info.getDABuildID());
        Link tizensitevalue = new Link(valuecontents, 16384);
        tizensitevalue.setFont(FontResources.DIALOG_CONTENTS_NORMAL_FONT);
        tizensitevalue.setBackground(ColorResources.DIALOG_CONTENT_BACKGROUND);
        tizensitevalue.setForeground(ColorResources.POINT);
        tizensitevalue.setText("<a>" + info.getTizenSite() + "</a>");
        tizensitevalue.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent arg0) {
            }

            public void widgetSelected(SelectionEvent arg0) {
                try {
                    String url = AboutInfo.getInstance().getTizenSite();
                    if (CommonUtil.isWin()) {
                        Program.launch((String)url);
                    } else if (CommonUtil.isLinux()) {
                        Runtime.getRuntime().exec("xdg-open " + url);
                    } else if (CommonUtil.isMac()) {
                        Runtime.getRuntime().exec("/usr/bin/open " + url);
                    }
                }
                catch (Throwable throwable) {
                    Logger.error((Object)"Failed to open developer site");
                    return;
                }
            }
        });
        ((FormData)valuecontents.getLayoutData()).bottom = new FormAttachment(100, -22);
        Link releasenotevalue = new Link(valuecontents, 16384);
        releasenotevalue.setFont(FontResources.DIALOG_CONTENTS_NORMAL_FONT);
        releasenotevalue.setBackground(ColorResources.DIALOG_CONTENT_BACKGROUND);
        releasenotevalue.setForeground(ColorResources.POINT);
        releasenotevalue.setText("<a>" + AnalyzerLabels.TIZEN_DEVELOP_SITE_LINK + "</a>");
        releasenotevalue.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent arg0) {
            }

            public void widgetSelected(SelectionEvent arg0) {
                try {
                    String url = AboutInfo.getInstance().getReleaseNote();
                    if (CommonUtil.isWin()) {
                        Program.launch((String)url);
                    } else if (CommonUtil.isLinux()) {
                        Runtime.getRuntime().exec("xdg-open " + url);
                    } else if (CommonUtil.isMac()) {
                        Runtime.getRuntime().exec("/usr/bin/open " + url);
                    }
                }
                catch (Throwable throwable) {
                    Logger.error((Object)"Failed to open developer site");
                    return;
                }
            }
        });
    }

    private void drawButtons() {
        Button okButton = new Button(this.buttonContentsComp, 0);
        FormData buttonData = new FormData();
        buttonData.top = new FormAttachment(0, 18);
        buttonData.right = new FormAttachment(100, -20);
        buttonData.width = 86;
        buttonData.height = 26;
        okButton.setLayoutData((Object)buttonData);
        okButton.setFont(FontResources.DIALOG_BUTTON_FONT);
        okButton.setText(WidgetLabels.CLOSE);
        okButton.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent arg0) {
            }

            public void widgetSelected(SelectionEvent arg0) {
                AboutDialog.this.shell.dispose();
            }
        });
    }
}

