/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.texteditor;

import java.util.ResourceBundle;
import org.eclipse.jface.text.ITextOperationTarget;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.texteditor.IReadOnlyDependent;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.ui.texteditor.TextEditorAction;

public class ShiftAction
extends TextEditorAction
implements IReadOnlyDependent {
    private int fOperationCode = -1;
    private ITextOperationTarget fOperationTarget;

    public ShiftAction(ResourceBundle bundle, String prefix, ITextEditor editor, int operationCode) {
        super(bundle, prefix, editor);
        this.fOperationCode = operationCode;
        this.update();
    }

    public void run() {
        if (this.fOperationCode == -1 || this.fOperationTarget == null) {
            return;
        }
        ITextEditor editor = this.getTextEditor();
        if (editor == null) {
            return;
        }
        if (!this.validateEditorInputState()) {
            return;
        }
        Display display = null;
        IWorkbenchPartSite site = editor.getSite();
        Shell shell = site.getShell();
        if (shell != null && !shell.isDisposed()) {
            display = shell.getDisplay();
        }
        BusyIndicator.showWhile((Display)display, (Runnable)new Runnable(){

            @Override
            public void run() {
                ShiftAction.this.fOperationTarget.doOperation(ShiftAction.this.fOperationCode);
            }
        });
    }

    @Override
    public void update() {
        super.update();
        if (!this.isEnabled()) {
            return;
        }
        if (!this.canModifyEditor()) {
            this.setEnabled(false);
            return;
        }
        ITextEditor editor = this.getTextEditor();
        if (this.fOperationTarget == null && editor != null && this.fOperationCode != -1) {
            this.fOperationTarget = (ITextOperationTarget)editor.getAdapter(ITextOperationTarget.class);
        }
    }

    protected void updateForTab() {
        super.update();
        if (this.isEnabled()) {
            if (!this.canModifyEditor()) {
                this.setEnabled(false);
                return;
            }
            ITextEditor editor = this.getTextEditor();
            if (this.fOperationTarget == null && editor != null && this.fOperationCode != -1) {
                this.fOperationTarget = (ITextOperationTarget)editor.getAdapter(ITextOperationTarget.class);
            }
            boolean isEnabled = this.fOperationTarget != null && this.fOperationTarget.canDoOperation(this.fOperationCode);
            this.setEnabled(isEnabled);
        }
    }

    @Override
    public void setEditor(ITextEditor editor) {
        super.setEditor(editor);
        this.fOperationTarget = null;
    }

    @Override
    public boolean isEnabled(boolean isWritable) {
        if (!isWritable) {
            return false;
        }
        ITextEditor editor = this.getTextEditor();
        if (this.fOperationTarget == null && editor != null && this.fOperationCode != -1) {
            this.fOperationTarget = (ITextOperationTarget)editor.getAdapter(ITextOperationTarget.class);
        }
        return this.fOperationTarget != null && this.fOperationTarget.canDoOperation(this.fOperationCode);
    }
}

