/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.dom.parser.cpp;

import org.eclipse.cdt.core.dom.IName;
import org.eclipse.cdt.core.dom.ast.DOMException;
import org.eclipse.cdt.core.dom.ast.EScopeKind;
import org.eclipse.cdt.core.dom.ast.IASTName;
import org.eclipse.cdt.core.dom.ast.IBinding;
import org.eclipse.cdt.core.dom.ast.IProblemBinding;
import org.eclipse.cdt.core.dom.ast.IScope;
import org.eclipse.cdt.core.dom.ast.IType;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPBase;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPClassScope;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPClassSpecialization;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPClassType;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPConstructor;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPField;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPMethod;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPNamespace;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPParameterPackType;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPTemplateParameter;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPTemplateParameterMap;
import org.eclipse.cdt.core.index.IIndexFileSet;
import org.eclipse.cdt.core.parser.util.ArrayUtil;
import org.eclipse.cdt.core.parser.util.CharArrayUtils;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPClassScope;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPParameterPackType;
import org.eclipse.cdt.internal.core.dom.parser.cpp.ICPPASTInternalScope;
import org.eclipse.cdt.internal.core.dom.parser.cpp.ICPPClassSpecializationScope;
import org.eclipse.cdt.internal.core.dom.parser.cpp.ICPPInternalBinding;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.CPPSemantics;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.CPPTemplates;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.SemanticUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AbstractCPPClassSpecializationScope
implements ICPPClassSpecializationScope {
    private final ICPPClassSpecialization specialClass;
    private volatile ICPPBase[] fBases;

    public AbstractCPPClassSpecializationScope(ICPPClassSpecialization specialization) {
        this.specialClass = specialization;
    }

    @Override
    public ICPPClassType getOriginalClassType() {
        return this.specialClass.getSpecializedBinding();
    }

    @Override
    public final IBinding getBinding(IASTName name, boolean resolve) {
        return this.getBinding(name, resolve, IIndexFileSet.EMPTY);
    }

    @Override
    public final IBinding[] getBindings(IASTName name, boolean resolve, boolean prefix) {
        return this.getBindings(name, resolve, prefix, IIndexFileSet.EMPTY);
    }

    @Override
    public IBinding getBinding(IASTName name, boolean forceResolve, IIndexFileSet fileSet) {
        IBinding[] bindings;
        char[] c = name.getLookupKey();
        if (CharArrayUtils.equals(c, this.specialClass.getNameCharArray()) && !CPPClassScope.shallReturnConstructors(name, false)) {
            return this.specialClass;
        }
        ICPPClassType specialized = this.specialClass.getSpecializedBinding();
        IScope classScope = specialized.getCompositeScope();
        IBinding[] iBindingArray = bindings = classScope != null ? classScope.getBindings(name, forceResolve, false) : null;
        if (bindings == null) {
            return null;
        }
        Object[] specs = new IBinding[]{};
        IBinding[] iBindingArray2 = bindings;
        int n = bindings.length;
        int n2 = 0;
        while (n2 < n) {
            IBinding binding = iBindingArray2[n2];
            specs = (IBinding[])ArrayUtil.append(IBinding.class, specs, this.specialClass.specializeMember(binding));
            ++n2;
        }
        specs = (IBinding[])ArrayUtil.trim(IBinding.class, specs);
        return CPPSemantics.resolveAmbiguities(name, specs);
    }

    @Override
    public final IBinding[] getBindings(IASTName name, boolean forceResolve, boolean prefixLookup, IIndexFileSet fileSet) {
        return this.getBindings(name, forceResolve, prefixLookup, fileSet, true);
    }

    public IBinding[] getBindings(IASTName name, boolean forceResolve, boolean prefixLookup, IIndexFileSet fileSet, boolean checkPointOfDecl) {
        ICPPClassType specialized = this.specialClass.getSpecializedBinding();
        IScope classScope = specialized.getCompositeScope();
        if (classScope == null) {
            return IBinding.EMPTY_BINDING_ARRAY;
        }
        IBinding[] bindings = classScope instanceof ICPPASTInternalScope ? ((ICPPASTInternalScope)classScope).getBindings(name, forceResolve, prefixLookup, fileSet, checkPointOfDecl) : classScope.getBindings(name, forceResolve, prefixLookup, fileSet);
        Object[] result = null;
        IBinding[] iBindingArray = bindings;
        int n = bindings.length;
        int n2 = 0;
        while (n2 < n) {
            IBinding binding = iBindingArray[n2];
            binding = binding == specialized ? this.specialClass : this.specialClass.specializeMember(binding);
            result = (IBinding[])ArrayUtil.append(IBinding.class, result, binding);
            ++n2;
        }
        return (IBinding[])ArrayUtil.trim(IBinding.class, result);
    }

    @Override
    public ICPPClassSpecialization getClassType() {
        return this.specialClass;
    }

    @Override
    public ICPPBase[] getBases() {
        if (this.fBases == null) {
            Object[] result = null;
            ICPPBase[] bases = this.specialClass.getSpecializedBinding().getBases();
            if (bases.length == 0) {
                this.fBases = bases;
            } else {
                ICPPTemplateParameterMap tpmap = this.specialClass.getTemplateParameterMap();
                ICPPBase[] iCPPBaseArray = bases;
                int n = bases.length;
                int n2 = 0;
                while (n2 < n) {
                    IType specClass;
                    ICPPBase base = iCPPBaseArray[n2];
                    IBinding origClass = base.getBaseClass();
                    if (origClass instanceof ICPPTemplateParameter && ((ICPPTemplateParameter)origClass).isParameterPack()) {
                        IType[] specClasses = CPPTemplates.instantiateTypes(new IType[]{new CPPParameterPackType((IType)((Object)origClass))}, tpmap, -1, this.specialClass);
                        if (specClasses.length == 1 && specClasses[0] instanceof ICPPParameterPackType) {
                            result = (ICPPBase[])ArrayUtil.append(ICPPBase.class, result, base);
                        } else {
                            IType[] iTypeArray = specClasses;
                            int n3 = specClasses.length;
                            int n4 = 0;
                            while (n4 < n3) {
                                specClass = iTypeArray[n4];
                                ICPPBase specBase = base.clone();
                                if ((specClass = SemanticUtil.getUltimateType(specClass, false)) instanceof IBinding && !(specClass instanceof IProblemBinding)) {
                                    specBase.setBaseClass((IBinding)((Object)specClass));
                                    result = (ICPPBase[])ArrayUtil.append(ICPPBase.class, result, specBase);
                                }
                                ++n4;
                            }
                        }
                    } else if (origClass instanceof IType) {
                        ICPPBase specBase = base.clone();
                        specClass = CPPTemplates.instantiateType((IType)((Object)origClass), tpmap, -1, this.specialClass);
                        if ((specClass = SemanticUtil.getUltimateType(specClass, false)) instanceof IBinding && !(specClass instanceof IProblemBinding)) {
                            specBase.setBaseClass((IBinding)((Object)specClass));
                        }
                        result = (ICPPBase[])ArrayUtil.append(ICPPBase.class, result, specBase);
                    }
                    ++n2;
                }
                result = (ICPPBase[])ArrayUtil.trim(ICPPBase.class, result);
                this.fBases = result;
                return result;
            }
        }
        return this.fBases;
    }

    private <T extends IBinding> T[] specializeMembers(T[] array) {
        if (array == null || array.length == 0) {
            return array;
        }
        IBinding[] newArray = (IBinding[])array.clone();
        int i = 0;
        while (i < newArray.length) {
            newArray[i] = this.specialClass.specializeMember((IBinding)array[i]);
            ++i;
        }
        return newArray;
    }

    @Override
    public ICPPField[] getDeclaredFields() {
        IBinding[] fields = this.specialClass.getSpecializedBinding().getDeclaredFields();
        return (ICPPField[])this.specializeMembers(fields);
    }

    @Override
    public ICPPMethod[] getImplicitMethods() {
        ICPPClassScope origClassScope = (ICPPClassScope)this.specialClass.getSpecializedBinding().getCompositeScope();
        if (origClassScope == null) {
            return ICPPMethod.EMPTY_CPPMETHOD_ARRAY;
        }
        IBinding[] methods = origClassScope.getImplicitMethods();
        return (ICPPMethod[])this.specializeMembers(methods);
    }

    @Override
    public IName getScopeName() {
        if (this.specialClass instanceof ICPPInternalBinding) {
            return (IASTName)((ICPPInternalBinding)((Object)this.specialClass)).getDefinition();
        }
        return null;
    }

    @Override
    public ICPPConstructor[] getConstructors() {
        IBinding[] ctors = this.specialClass.getSpecializedBinding().getConstructors();
        return (ICPPConstructor[])this.specializeMembers(ctors);
    }

    @Override
    public ICPPMethod[] getDeclaredMethods() {
        IBinding[] bindings = this.specialClass.getSpecializedBinding().getDeclaredMethods();
        return (ICPPMethod[])this.specializeMembers(bindings);
    }

    @Override
    public ICPPClassType[] getNestedClasses() {
        IBinding[] bindings = this.specialClass.getSpecializedBinding().getNestedClasses();
        return (ICPPClassType[])this.specializeMembers(bindings);
    }

    @Override
    public IBinding[] getFriends() {
        return IBinding.EMPTY_BINDING_ARRAY;
    }

    @Override
    public IScope getParent() throws DOMException {
        IBinding binding = this.specialClass.getOwner();
        if (binding instanceof ICPPClassType) {
            return ((ICPPClassType)binding).getCompositeScope();
        }
        if (binding instanceof ICPPNamespace) {
            return ((ICPPNamespace)binding).getNamespaceScope();
        }
        return this.getOriginalClassType().getScope();
    }

    @Override
    public IBinding[] find(String name) {
        return CPPSemantics.findBindings((IScope)this, name, false);
    }

    public String toString() {
        IName name = this.getScopeName();
        return name != null ? name.toString() : String.valueOf(this.specialClass);
    }

    @Override
    public EScopeKind getKind() {
        return EScopeKind.eClassType;
    }
}

