/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.dynamicanalyzer.communicator;

import java.io.File;
import java.io.IOException;
import java.net.ServerSocket;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.util.concurrent.TimeUnit;
import org.tizen.dynamicanalyzer.common.DAResult;
import org.tizen.dynamicanalyzer.common.path.PathManager;
import org.tizen.dynamicanalyzer.util.Logger;
import org.tizen.sdblib.IDevice;
import org.tizen.sdblib.IShellOutputReceiver;
import org.tizen.sdblib.PlatformCapability;
import org.tizen.sdblib.exception.SdbCommandRejectedException;
import org.tizen.sdblib.exception.ShellCommandUnresponsiveException;
import org.tizen.sdblib.exception.TimeoutException;
import org.tizen.sdblib.receiver.NullOutputReceiver;
import org.tizen.sdblib.service.FileEntry;
import org.tizen.sdblib.service.ISyncProgressMonitor;
import org.tizen.sdblib.service.NullSyncProgressMonitor;
import org.tizen.sdblib.service.SyncResult;
import org.tizen.sdblib.service.SyncService;
import org.tizen.sdblib.service.SyncServiceReturnCode;
import org.tizen.sdblib.util.DeviceUtil;

public class CommunicatorUtils {
    public static final int LOCAL_PORT = 8000;

    public static int getFreePort() {
        int port = 8000;
        try {
            ServerSocket socket = new ServerSocket(0);
            port = socket.getLocalPort();
            socket.close();
        }
        catch (IOException e) {
            Logger.exception((Throwable)e);
        }
        return port;
    }

    public static boolean becomeSuperUser(IDevice device, boolean mode) {
        boolean becomeSuper = false;
        try {
            becomeSuper = device.becomeSuperUser(mode);
        }
        catch (TimeoutException e) {
            Logger.exception((Throwable)e);
        }
        catch (SdbCommandRejectedException e) {
            Logger.exception((Throwable)e);
        }
        catch (IOException e) {
            try {
                Process p = Runtime.getRuntime().exec(String.valueOf(PathManager.SDB_PATH) + " -s " + device.getSerialNumber() + " root " + (mode ? "on" : "off"));
                return p.waitFor(1L, TimeUnit.SECONDS) && p.exitValue() == 0;
            }
            catch (IOException | InterruptedException e1) {
                Logger.exception((Throwable)e);
                Logger.exception((Throwable)e1);
                return false;
            }
        }
        return becomeSuper;
    }

    public static boolean enableRoot(IDevice device) {
        boolean availability = false;
        try {
            PlatformCapability capability = device.getPlatformCapability();
            String rootPerm = capability.getSdbdRootPerm();
            availability = !rootPerm.equals("disabled");
        }
        catch (TimeoutException e) {
            Logger.exception((Throwable)e);
        }
        catch (SdbCommandRejectedException sdbCommandRejectedException) {
            Logger.debug((Object)"getPlatformCapability() failed");
            if (CommunicatorUtils.becomeSuperUser(device, true)) {
                availability = true;
                CommunicatorUtils.becomeSuperUser(device, false);
            } else {
                availability = false;
            }
        }
        catch (IOException e) {
            Logger.exception((Throwable)e);
        }
        return availability;
    }

    public static void execShellCommand(IDevice device, String command) {
        CommunicatorUtils.execShellCommand(device, command, NullOutputReceiver.getInstance());
    }

    public static void execShellCommand(IDevice device, String command, IShellOutputReceiver receiver) {
        if (device != null && DeviceUtil.isOnline((IDevice)device)) {
            try {
                device.executeShellCommand(command, receiver);
            }
            catch (TimeoutException e) {
                Logger.exception((Throwable)e);
            }
            catch (SdbCommandRejectedException e) {
                Logger.exception((Throwable)e);
            }
            catch (ShellCommandUnresponsiveException e) {
                Logger.exception((Throwable)e);
            }
            catch (IOException e) {
                Logger.exception((Throwable)e);
            }
        }
    }

    public static SyncResult push(IDevice currentDevice, String local, String remote) {
        SyncResult result = null;
        if (currentDevice != null && DeviceUtil.isOnline((IDevice)currentDevice)) {
            try {
                SyncService service = currentDevice.getSyncService();
                if (service != null) {
                    result = service.push(new String[]{local}, currentDevice.getFileEntry(remote), (ISyncProgressMonitor)NullSyncProgressMonitor.getInstance());
                    service.close();
                }
            }
            catch (TimeoutException e) {
                Logger.exception((Throwable)e);
            }
            catch (SdbCommandRejectedException e) {
                Logger.exception((Throwable)e);
            }
            catch (IOException e) {
                Logger.exception((Throwable)e);
            }
        }
        return result;
    }

    public static SyncResult pull(IDevice device, String remote, String local) {
        String remoteFileName = remote.substring(remote.lastIndexOf("/") + 1);
        String localFolderName = local.substring(0, local.lastIndexOf(File.separator) + 1);
        SyncResult result = null;
        if (device != null && DeviceUtil.isOnline((IDevice)device)) {
            try {
                File f = new File(localFolderName);
                if (!f.exists() && !f.mkdirs()) {
                    return new SyncResult(SyncServiceReturnCode.RESULT_NO_DIR_TARGET);
                }
                SyncService service = device.getSyncService();
                if (service != null) {
                    result = service.pull(new FileEntry[]{device.getFileEntry(remote)}, localFolderName, (ISyncProgressMonitor)NullSyncProgressMonitor.getInstance(), 0);
                    service.close();
                }
                Files.copy(new File(String.valueOf(localFolderName) + remoteFileName).toPath(), new File(local).toPath(), StandardCopyOption.REPLACE_EXISTING, StandardCopyOption.COPY_ATTRIBUTES);
            }
            catch (TimeoutException e) {
                Logger.exception((Throwable)e);
            }
            catch (SdbCommandRejectedException e) {
                Logger.exception((Throwable)e);
            }
            catch (IOException e) {
                Logger.exception((Throwable)e);
            }
        }
        return result;
    }

    public static DAResult forward(IDevice device, int local, int remote) {
        DAResult result = new DAResult(DAResult.ErrorCode.SUCCESS);
        if (device != null && DeviceUtil.isOnline((IDevice)device)) {
            try {
                device.createForward(local, remote);
            }
            catch (TimeoutException e) {
                Logger.exception((Throwable)e);
                result = new DAResult(DAResult.ErrorCode.ERR_EXCEPTION_OCCURRED);
                result.setDetailMessage(e.getMessage());
            }
            catch (SdbCommandRejectedException e) {
                Logger.exception((Throwable)e);
                result = new DAResult(DAResult.ErrorCode.ERR_EXCEPTION_OCCURRED);
                result.setDetailMessage(e.getMessage());
            }
            catch (IOException e) {
                Logger.exception((Throwable)e);
                result = new DAResult(DAResult.ErrorCode.ERR_EXCEPTION_OCCURRED);
                result.setDetailMessage(e.getMessage());
            }
            catch (NullPointerException e) {
                Logger.exception((Throwable)e);
                result = new DAResult(DAResult.ErrorCode.ERR_EXCEPTION_OCCURRED);
                result.setDetailMessage(e.getMessage());
            }
        } else {
            result = device == null ? new DAResult(DAResult.ErrorCode.ERR_NO_DEVICE) : (!DeviceUtil.isOnline((IDevice)device) ? new DAResult(DAResult.ErrorCode.ERR_DISCONNECTED) : new DAResult(DAResult.ErrorCode.ERR_UNKNOWN));
        }
        return result;
    }

    public static void unforward(IDevice device, int local, int remote) {
        if (device != null && DeviceUtil.isOnline((IDevice)device)) {
            try {
                device.removeForward(local, remote);
                Thread.sleep(1000L);
            }
            catch (TimeoutException e) {
                Logger.exception((Throwable)e);
            }
            catch (SdbCommandRejectedException e) {
                Logger.exception((Throwable)e);
            }
            catch (IOException e) {
                Logger.exception((Throwable)e);
            }
            catch (InterruptedException e) {
                Logger.exception((Throwable)e);
            }
        }
    }
}

