/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.dynamicanalyzer.ui.memory;

import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.tizen.dynamicanalyzer.common.DASelectionData;
import org.tizen.dynamicanalyzer.common.DAState;
import org.tizen.dynamicanalyzer.nl.MemoryPageLabels;
import org.tizen.dynamicanalyzer.ui.memory.table.MemoryStatisticsTable;
import org.tizen.dynamicanalyzer.widgets.chart.IntervalManager;
import org.tizen.dynamicanalyzer.widgets.da.view.DAHidableViewComposite;
import org.tizen.dynamicanalyzer.widgets.da.view.DAViewData;

public class MemoryStatisticsTableView
extends DAHidableViewComposite {
    public static final String ID = MemoryStatisticsTableView.class.getName();
    public static final int PATH_TABLE_INDEX = 0;
    public static final int PERSISTENT_BYTE_TABLE_INDEX = 1;
    public static final int PERSISTENT_TABLE_INDEX = 0;
    public static final int FREED_TABLE_INDEX = 0;
    public static final int TOTAL_BYTE_TABLE_INDEX = 0;
    public static final int TOTAL_TABLE_INDEX = 0;
    private MemoryStatisticsTable tableComp = null;

    public MemoryStatisticsTableView(Composite parent, int style) {
        super(parent, style, false, MemoryPageLabels.STREAMING_NOT_SUPPORTED);
        this.setTitle(MemoryPageLabels.MEMORY_STATISTICS_VIEW_TITLE);
        this.tableComp = new MemoryStatisticsTable(this.getContentArea(), 0, 68354);
        this.setDataComposite(this.tableComp);
    }

    public void updateView() {
        if (this.isHidden()) {
            if (DAState.isDone() || IntervalManager.INSTANCE.isIntervalSelected()) {
                this.show();
                this.tableComp.updateTable();
            }
        } else if (!DAState.isDone() && !IntervalManager.INSTANCE.isIntervalSelected()) {
            this.hide();
        } else {
            this.tableComp.updateTable();
        }
    }

    public void updateView(final DAViewData vdata) {
        this.tableComp.taskQueueSize = this.tableComp.taskQueueSize + 1;
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                this.subRun();
                ((MemoryStatisticsTableView)MemoryStatisticsTableView.this).tableComp.taskQueueSize = ((MemoryStatisticsTableView)MemoryStatisticsTableView.this).tableComp.taskQueueSize - 1;
            }

            private void subRun() {
                if (!(vdata instanceof DASelectionData)) {
                    return;
                }
                DASelectionData selData = (DASelectionData)vdata;
                if (selData.getStartTime() == selData.getEndTime()) {
                    if (!DAState.isDone()) {
                        MemoryStatisticsTableView.this.hide();
                        MemoryStatisticsTableView.this.tableComp.clear();
                        return;
                    }
                    MemoryStatisticsTableView.this.show();
                } else {
                    MemoryStatisticsTableView.this.show();
                }
                MemoryStatisticsTableView.this.tableComp.updateTable();
            }
        });
    }

    public void clear() {
        this.tableComp.clear();
    }

    public Control getControl() {
        return this.tableComp;
    }
}

