/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.dynamicanalyzer.ui.timeline.chart;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.MouseMoveListener;
import org.eclipse.swt.events.MouseTrackListener;
import org.tizen.dynamicanalyzer.common.Global;
import org.tizen.dynamicanalyzer.nl.TimelineChartLabels;
import org.tizen.dynamicanalyzer.resources.ColorResources;
import org.tizen.dynamicanalyzer.resources.ImageResources;
import org.tizen.dynamicanalyzer.ui.common.ChartPopupMenu;
import org.tizen.dynamicanalyzer.ui.common.TimelineChartMouseEventListener;
import org.tizen.dynamicanalyzer.ui.common.TimelineChartMouseTrackAdapter;
import org.tizen.dynamicanalyzer.ui.memory.data.ProcessMemoryDBTable;
import org.tizen.dynamicanalyzer.ui.timeline.chart.TimelineChart;
import org.tizen.dynamicanalyzer.ui.toolbar.Toolbar;
import org.tizen.dynamicanalyzer.utils.AnalyzerUtil;
import org.tizen.dynamicanalyzer.utils.Formatter;
import org.tizen.dynamicanalyzer.widgets.chart.DAChartPlot;
import org.tizen.dynamicanalyzer.widgets.chart.DAChartSeries;
import org.tizen.dynamicanalyzer.widgets.chart.DAChartSeriesItem;
import org.tizen.dynamicanalyzer.widgets.chartBoard.DAChartBoard;
import org.tizen.dynamicanalyzer.widgets.chartBoard.DAChartBoardItem;

public class ProcessMemoryChart
extends TimelineChart {
    private final int VSS = 0;
    private final int RSS = 1;
    private final int PSS = 2;
    private final int NEW_PSS = 0;
    private final int NEW_THREED = 1;
    private final int NEW_GEM = 2;
    private Map<Integer, DAChartBoardItem> processChartboardMap = new HashMap<Integer, DAChartBoardItem>();
    private Map<Integer, String> processNameMap = new HashMap<Integer, String>();
    private DAChartBoardItem parentBoardItem;

    public ProcessMemoryChart(String pageID) {
        super(pageID);
        this.chartType = -105;
        this.probeType = 5;
        this.chartName = TimelineChartLabels.PROCESS_MEMORY_CHART_TITLE;
        this.chartDescriptor = TimelineChartLabels.PROCESS_MEMORY_CHART_DESCRIPTOR;
        this.chartIcon = ImageResources.FEATURE_MEM_PROCESS_SMALL_NOR;
        this.addIcon = ImageResources.FEATURE_MEM_PROCESS_SMALL_NOR;
    }

    private List<DAChartSeries> createChartSeries() {
        ArrayList<DAChartSeries> chartSeriesList = new ArrayList<DAChartSeries>();
        DAChartSeries pssSeries = new DAChartSeries(TimelineChartLabels.PROCESS_MEMORY_CHART_PSS, 3, ColorResources.CHART_SERIES_RED);
        if (Global.getProject().getMempsAvailable()) {
            DAChartSeries threeDSeries = new DAChartSeries(TimelineChartLabels.PROCESS_MEMORY_CHART_THREED, 3, ColorResources.CHART_SERIES_PURPLE);
            DAChartSeries gemSeries = new DAChartSeries(TimelineChartLabels.PROCESS_MEMORY_CHART_GEM, 3, ColorResources.CHART_SERIES_PINK);
            chartSeriesList.add(pssSeries);
            chartSeriesList.add(threeDSeries);
            chartSeriesList.add(gemSeries);
        } else {
            DAChartSeries vssSeries = new DAChartSeries(TimelineChartLabels.PROCESS_MEMORY_CHART_VSS, 3, ColorResources.CHART_SERIES_PURPLE);
            DAChartSeries rssSeries = new DAChartSeries(TimelineChartLabels.PROCESS_MEMORY_CHART_RSS, 3, ColorResources.CHART_SERIES_PINK);
            chartSeriesList.add(vssSeries);
            chartSeriesList.add(rssSeries);
            chartSeriesList.add(pssSeries);
        }
        return chartSeriesList;
    }

    @Override
    public DAChartBoardItem createBoardItem(DAChartBoard board) {
        this.parentBoardItem = super.createBoardItem(board);
        this.chart.getPlot().setAxisUnit("B");
        this.chart.getPlot().setAxisUnitType(DAChartPlot.UnitType.BINARY);
        this.chart.getPlot().setShowAxis(true);
        this.clear();
        return this.parentBoardItem;
    }

    public DAChartBoardItem createChildBoardItem(DAChartBoardItem parent) {
        DAChartBoardItem item = new DAChartBoardItem(parent, this.chartName, this.chartIcon, this.chartStyle);
        this.chart = item.getChart();
        this.setChartStyle();
        DAChartPlot parentPlot = parent.getChart().getPlot();
        this.chart.getPlot().setTooltip(parentPlot.getTooltip());
        this.chart.getPlot().setAxisUnit(parentPlot.getAxisUnit());
        this.chart.getPlot().setAxisUnitType(parentPlot.getAxisUnitType());
        this.chart.getPlot().setShowAxis(parentPlot.isShowAxis());
        this.popupMenu = new ChartPopupMenu(this.chart);
        TimelineChartMouseEventListener timelineChartMouseEventListener = new TimelineChartMouseEventListener(this.popupMenu, parent.getChartBoard().getTimeline(), this.pageID);
        this.chart.addMouseListener((MouseListener)timelineChartMouseEventListener);
        this.chart.addMouseMoveListener((MouseMoveListener)timelineChartMouseEventListener);
        this.chart.addMouseTrackListener((MouseTrackListener)new TimelineChartMouseTrackAdapter(parent.getChartBoard().getTimeline()));
        return item;
    }

    @Override
    public void inputChartSeries(List<Object> dataList) {
        for (Map.Entry<Integer, DAChartBoardItem> entry : this.processChartboardMap.entrySet()) {
            DAChartBoardItem board = entry.getValue();
            List seriesList = board.getChart().getSeriesList();
            int i = 0;
            while (i < seriesList.size()) {
                ((DAChartSeries)seriesList.get(i)).clear();
                ++i;
            }
        }
        if (Global.getProject() == null) {
            return;
        }
        Map processDataMap = (Map)dataList.get(1);
        for (Integer pid : processDataMap.keySet()) {
            String processName = AnalyzerUtil.getProcessName(pid);
            if (processName == null) {
                return;
            }
            if (this.processChartboardMap.isEmpty()) {
                List<DAChartSeries> seriesList = this.createChartSeries();
                this.processChartboardMap.put(pid, this.parentBoardItem);
                int i = 0;
                while (i < seriesList.size()) {
                    this.parentBoardItem.getChart().addSeries(seriesList.get(i));
                    ++i;
                }
            } else if (this.processChartboardMap.get(pid) == null) {
                List<DAChartSeries> seriesList = this.createChartSeries();
                ProcessMemoryChart childChart = new ProcessMemoryChart(this.pageID);
                DAChartBoardItem childBoardItem = childChart.createChildBoardItem(this.parentBoardItem);
                this.processChartboardMap.put(pid, childBoardItem);
                int i = 0;
                while (i < seriesList.size()) {
                    childBoardItem.getChart().addSeries(seriesList.get(i));
                    ++i;
                }
                this.parentBoardItem.unFoldChild();
            }
            DAChartBoardItem curBoard = null;
            int selectedPID = Toolbar.INSTANCE.getSelectedPid();
            if (selectedPID > 0 && selectedPID != pid) continue;
            if (selectedPID > 0 && selectedPID == pid) {
                curBoard = this.parentBoardItem;
                this.parentBoardItem.hideChildItems();
                this.parentBoardItem.getItemCell().hideChildFoldToggleButton();
                curBoard.getChart().getPlot().setAxisEndY(0.0);
            } else {
                curBoard = this.processChartboardMap.get(pid);
                this.parentBoardItem.showChildItems();
                this.parentBoardItem.getItemCell().showChildFoldToggleButton();
            }
            String oldProcessName = this.processNameMap.get(pid);
            if (oldProcessName == null || !oldProcessName.equals(processName)) {
                curBoard.getChart().setInformation(String.valueOf(processName) + " / PID : " + pid);
            }
            List seriesList = curBoard.getChart().getSeriesList();
            List data = (List)processDataMap.get(pid);
            int i = 0;
            while (i < data.size()) {
                List row = (List)data.get(i);
                double time = (double)((Long)row.get(ProcessMemoryDBTable.COLUMN.SAMPLING_TIME.index)).longValue() / 1000000.0;
                long vssMemory = (Long)row.get(ProcessMemoryDBTable.COLUMN.MEMORY_VIRTUAL.index);
                long rssMemory = (Long)row.get(ProcessMemoryDBTable.COLUMN.MEMORY_RESIDENT.index);
                long pssMemory = (Long)row.get(ProcessMemoryDBTable.COLUMN.MEMORY_PSS.index);
                if (Global.getProject().getMempsAvailable()) {
                    long threeDMemory = (Long)row.get(ProcessMemoryDBTable.COLUMN.MEMORY_THREED.index);
                    long gemMemory = (Long)row.get(ProcessMemoryDBTable.COLUMN.MEMORY_GEM.index);
                    ((DAChartSeries)seriesList.get(0)).addSeriesItem(new DAChartSeriesItem(time, (double)pssMemory, Formatter.toByteFormat(pssMemory)));
                    ((DAChartSeries)seriesList.get(1)).addSeriesItem(new DAChartSeriesItem(time, (double)threeDMemory, Formatter.toByteFormat(threeDMemory)));
                    ((DAChartSeries)seriesList.get(2)).addSeriesItem(new DAChartSeriesItem(time, (double)gemMemory, Formatter.toByteFormat(gemMemory)));
                } else {
                    ((DAChartSeries)seriesList.get(0)).addSeriesItem(new DAChartSeriesItem(time, (double)vssMemory, Formatter.toByteFormat(vssMemory)));
                    ((DAChartSeries)seriesList.get(1)).addSeriesItem(new DAChartSeriesItem(time, (double)rssMemory, Formatter.toByteFormat(rssMemory)));
                    ((DAChartSeries)seriesList.get(2)).addSeriesItem(new DAChartSeriesItem(time, (double)pssMemory, Formatter.toByteFormat(pssMemory)));
                }
                ++i;
            }
        }
    }

    @Override
    public void clear() {
        this.processChartboardMap.clear();
        this.processNameMap.clear();
        for (Map.Entry<Integer, DAChartBoardItem> entry : this.processChartboardMap.entrySet()) {
            DAChartBoardItem board = entry.getValue();
            if (board == this.parentBoardItem) continue;
            board.dispose();
        }
    }
}

