/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.dynamicanalyzer.cli.manager;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.tizen.dynamicanalyzer.cli.CliInternals;
import org.tizen.dynamicanalyzer.cli.manager.ProcessManagerMBean;
import org.tizen.dynamicanalyzer.cli.manager.TracingProcessContext;
import org.tizen.dynamicanalyzer.cli.manager.TracingProcessManager;
import org.tizen.dynamicanalyzer.cli.tracing.TracingArguments;
import org.tizen.dynamicanalyzer.cli.utils.HumanReadableTimeFormat;
import org.tizen.dynamicanalyzer.common.DAResult;
import org.tizen.dynamicanalyzer.util.Logger;

public class ProcessManager
implements ProcessManagerMBean {
    static int TRACING_PROCESS_STOP_TIMEOUT = 16000;
    Map<String, TracingProcessManager> mTracingMap = new ConcurrentHashMap<String, TracingProcessManager>();

    private boolean isDeviceReady(String device) {
        TracingProcessManager tpManager = this.mTracingMap.get(device);
        return tpManager == null || tpManager.isFinished();
    }

    @Override
    public synchronized String[] getTracedDevices() {
        ArrayList<String> tracedDevices = new ArrayList<String>(this.mTracingMap.size());
        for (Map.Entry<String, TracingProcessManager> entry : this.mTracingMap.entrySet()) {
            if (entry.getValue().isFinished()) continue;
            tracedDevices.add(entry.getKey());
        }
        Collections.sort(tracedDevices);
        return tracedDevices.toArray(new String[0]);
    }

    @Override
    public synchronized TracingProcessContext getContext(String device) {
        TracingProcessManager tpManager = this.mTracingMap.get(device);
        if (tpManager == null) {
            return null;
        }
        return tpManager.getContext();
    }

    @Override
    public synchronized DAResult startTracing(TracingArguments args) {
        TracingProcessManager tpManager;
        String device = args.getDevice();
        if (!CliInternals.isDeviceExist(device)) {
            Logger.error((String)"Device '%s' does not exist.", (Object[])new Object[]{device});
            return new DAResult(DAResult.ErrorCode.ERR_NO_DEVICE, "Device '" + device + "' does not exist.");
        }
        if (!CliInternals.isApllicationInstalled(args.getApplicationID(), device)) {
            Logger.error((String)"Application '%s' is not installed.", (Object[])new Object[]{args.getApplicationID()});
            return new DAResult(DAResult.ErrorCode.ERR_NO_APP, "Application '" + args.getApplicationID() + "' is not installed.");
        }
        if (!this.isDeviceReady(device)) {
            Logger.error((String)"Device '%s' is occupied by another tracing process.", (Object[])new Object[]{device});
            return new DAResult(DAResult.ErrorCode.ERR_BUSY_DEVICE);
        }
        try {
            tpManager = TracingProcessManager.createTracingProcess(args);
        }
        catch (IOException e) {
            Logger.error((String)"Couldn't start tracing proccess: %s.", (Object[])new Object[]{e.toString()});
            return new DAResult(DAResult.ErrorCode.ERR_EXCEPTION_OCCURRED, "Couldn't start tracing process: " + e.toString());
        }
        this.mTracingMap.put(device, tpManager);
        return DAResult.SUCCESS;
    }

    @Override
    public synchronized DAResult stopTracing(String device) {
        boolean softStopped;
        TracingProcessManager tpManager = this.mTracingMap.get(device);
        if (tpManager == null) {
            Logger.warning((String)"Requested stop tracing on invalid manager for device: '%s'.", (Object[])new Object[]{device});
            return new DAResult(DAResult.ErrorCode.ERR_TRACING_NOT_RUNNING);
        }
        if (tpManager.isFinished()) {
            Logger.warning((String)"Requested stop for tracing process that is finished already: '%s'.", (Object[])new Object[]{device});
            return new DAResult(DAResult.ErrorCode.ERR_TRACING_NOT_RUNNING, "Tracing process is not running.");
        }
        try {
            softStopped = tpManager.stopTracing(TRACING_PROCESS_STOP_TIMEOUT);
        }
        catch (InterruptedException e) {
            Logger.warning((String)"Stopping tracing process was interrupted on device '%s'.", (Object[])new Object[]{device});
            return new DAResult(DAResult.ErrorCode.ERR_EXCEPTION_OCCURRED, "Stopping tracing process was interrupted.");
        }
        if (!softStopped) {
            Logger.error((String)"Tracing process will be forcibly terminated due timeout %d ms on device '%s'.", (Object[])new Object[]{TRACING_PROCESS_STOP_TIMEOUT, device});
            tpManager.forceStopTracing();
            return new DAResult(DAResult.ErrorCode.ERR_EXCEPTION_OCCURRED, "Tracing process was forcibly terminated, traced data can be corrupted.");
        }
        Logger.info((String)"Tracing process was successufully stopped on device '%s'.", (Object[])new Object[]{device});
        return DAResult.SUCCESS;
    }

    @Override
    public synchronized HumanReadableTimeFormat getTracingTime(String device) {
        return new HumanReadableTimeFormat(this.mTracingMap.get(device).getTracingTime());
    }

    @Override
    public synchronized DAResult stopAll() {
        Logger.warning((Object)"Requested stop tracing on all devices.");
        DAResult result = DAResult.SUCCESS;
        for (Map.Entry<String, TracingProcessManager> entry : this.mTracingMap.entrySet()) {
            DAResult buf;
            TracingProcessManager mgr = entry.getValue();
            String device = entry.getKey();
            if (mgr.isFinished() || (buf = this.stopTracing(device)).isSuccess()) continue;
            result = buf;
        }
        return result;
    }
}

