/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.core.settings.model;

import java.util.Arrays;
import java.util.List;
import org.eclipse.cdt.core.settings.model.ICConfigurationDescription;
import org.eclipse.cdt.core.settings.model.ICLanguageSetting;
import org.eclipse.cdt.core.settings.model.ICLanguageSettingEntry;
import org.eclipse.cdt.core.settings.model.ICSettingContainer;
import org.eclipse.cdt.core.settings.model.MultiItemsHolder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MultiLanguageSetting
extends MultiItemsHolder
implements ICLanguageSetting {
    ICLanguageSetting[] items = null;
    ICConfigurationDescription cfgd = null;

    public MultiLanguageSetting(List<ICLanguageSetting> data, ICConfigurationDescription cf) {
        this.items = data.toArray(new ICLanguageSetting[data.size()]);
        this.cfgd = cf;
    }

    @Override
    public String getLanguageId() {
        return this.items[0].getLanguageId();
    }

    public ICLanguageSettingEntry[][] getSettingEntriesM(int kind) {
        ICLanguageSettingEntry[][] le = new ICLanguageSettingEntry[this.items.length][];
        int i = 0;
        while (i < this.items.length) {
            le[i] = this.items[i].getSettingEntries(kind);
            ++i;
        }
        return le;
    }

    @Override
    public List<ICLanguageSettingEntry> getSettingEntriesList(int kind) {
        return Arrays.asList(this.getSettingEntries(kind));
    }

    public String[][] getSourceContentTypeIdsM() {
        String[][] ss = new String[this.items.length][];
        int i = 0;
        while (i < this.items.length) {
            ss[i] = this.items[i].getSourceContentTypeIds();
            ++i;
        }
        return ss;
    }

    public String[][] getSourceExtensionsM() {
        String[][] ss = new String[this.items.length][];
        int i = 0;
        while (i < this.items.length) {
            ss[i] = this.items[i].getSourceExtensions();
            ++i;
        }
        return ss;
    }

    @Override
    public int getSupportedEntryKinds() {
        int res = 0;
        ICLanguageSetting[] iCLanguageSettingArray = this.items;
        int n = this.items.length;
        int n2 = 0;
        while (n2 < n) {
            ICLanguageSetting item = iCLanguageSettingArray[n2];
            res |= item.getSupportedEntryKinds();
            ++n2;
        }
        return res;
    }

    @Override
    public void setLanguageId(String id) {
    }

    @Override
    public void setSettingEntries(int kind, ICLanguageSettingEntry[] entries) {
        ICLanguageSetting[] iCLanguageSettingArray = this.items;
        int n = this.items.length;
        int n2 = 0;
        while (n2 < n) {
            ICLanguageSetting item = iCLanguageSettingArray[n2];
            item.setSettingEntries(kind, entries);
            ++n2;
        }
    }

    @Override
    public void setSettingEntries(int kind, List<ICLanguageSettingEntry> entriesList) {
        ICLanguageSetting[] iCLanguageSettingArray = this.items;
        int n = this.items.length;
        int n2 = 0;
        while (n2 < n) {
            ICLanguageSetting item = iCLanguageSettingArray[n2];
            item.setSettingEntries(kind, entriesList);
            ++n2;
        }
    }

    @Override
    public void setSourceContentTypeIds(String[] ids) {
        ICLanguageSetting[] iCLanguageSettingArray = this.items;
        int n = this.items.length;
        int n2 = 0;
        while (n2 < n) {
            ICLanguageSetting item = iCLanguageSettingArray[n2];
            item.setSourceContentTypeIds(ids);
            ++n2;
        }
    }

    @Override
    public void setSourceExtensions(String[] exts) {
        ICLanguageSetting[] iCLanguageSettingArray = this.items;
        int n = this.items.length;
        int n2 = 0;
        while (n2 < n) {
            ICLanguageSetting item = iCLanguageSettingArray[n2];
            item.setSourceExtensions(exts);
            ++n2;
        }
    }

    @Override
    public boolean supportsEntryKind(int kind) {
        ICLanguageSetting[] iCLanguageSettingArray = this.items;
        int n = this.items.length;
        int n2 = 0;
        while (n2 < n) {
            ICLanguageSetting item = iCLanguageSettingArray[n2];
            if (item.supportsEntryKind(kind)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    @Override
    public ICConfigurationDescription getConfiguration() {
        return null;
    }

    @Override
    public String getId() {
        return null;
    }

    @Override
    public String getName() {
        return this.items[0].getName();
    }

    @Override
    public ICSettingContainer getParent() {
        return null;
    }

    @Override
    public int getType() {
        int x = this.items[0].getType();
        ICLanguageSetting[] iCLanguageSettingArray = this.items;
        int n = this.items.length;
        int n2 = 0;
        while (n2 < n) {
            ICLanguageSetting item = iCLanguageSettingArray[n2];
            if (x != item.getType()) {
                return 0;
            }
            ++n2;
        }
        return x;
    }

    @Override
    public boolean isReadOnly() {
        int i = 0;
        while (i < this.items.length) {
            if (!this.items[i].isReadOnly()) {
                return false;
            }
            ++i;
        }
        return true;
    }

    @Override
    public boolean isValid() {
        int i = 0;
        while (i < this.items.length) {
            if (!this.items[i].isValid()) {
                return false;
            }
            ++i;
        }
        return true;
    }

    @Override
    public Object[] getItems() {
        return this.items;
    }

    @Override
    public ICLanguageSettingEntry[] getResolvedSettingEntries(int kind) {
        return null;
    }

    @Override
    public ICLanguageSettingEntry[] getSettingEntries(int kind) {
        ICLanguageSettingEntry[][] ses = this.getSettingEntriesM(kind);
        return ses[0];
    }

    @Override
    public String[] getSourceContentTypeIds() {
        return null;
    }

    @Override
    public String[] getSourceExtensions() {
        return null;
    }
}

