/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.dynamicanalyzer.widgets.da.view;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;
import org.eclipse.swt.custom.StackLayout;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.tizen.dynamicanalyzer.resources.ColorResources;
import org.tizen.dynamicanalyzer.resources.FontResources;
import org.tizen.dynamicanalyzer.resources.ImageResources;
import org.tizen.dynamicanalyzer.util.Logger;
import org.tizen.dynamicanalyzer.widgets.chart.IntervalManager;
import org.tizen.dynamicanalyzer.widgets.chartBoard.DAChartBoardItem;
import org.tizen.dynamicanalyzer.widgets.da.view.DABaseComposite;
import org.tizen.dynamicanalyzer.widgets.da.view.DAContainerComposite;
import org.tizen.dynamicanalyzer.widgets.da.view.DATabButton;
import org.tizen.dynamicanalyzer.widgets.da.view.DAViewData;
import org.tizen.dynamicanalyzer.widgets.da.view.TabButtonRenderer;
import org.tizen.dynamicanalyzer.widgets.helper.WidgetUtils;

public class DATabComposite
extends DABaseComposite {
    public static final int LONG_TAB_WIDTH = 190;
    public static final int SHORT_TAB_WIDTH = 80;
    protected boolean isToplevel = false;
    private List<DATabButton> buttons = null;
    private List<DABaseComposite> children = null;
    protected Composite tabComposite = null;
    protected Composite contentsComposite = null;
    private StackLayout contentsStackLayout = null;
    private Control lasttab = null;
    private Color tabBGColorStart = ColorResources.WHITE;
    private Color tabBGColorEnd = ColorResources.WHITE;
    private DATabButton sourceButton = null;
    private int targetButtonIndex = -1;
    private int sourceButtonIndex = -1;
    private boolean drag = false;
    private Shell shell = null;
    private Display display = null;
    private Cursor dragCursor = null;
    private Cursor basicCursor = null;
    private boolean isImageTab = false;
    private int tabWidth = 190;
    private PaintListener tabCompositePaintListener;

    public DATabComposite(Composite parent, int style) {
        super(parent, style);
        this.ID = DATabComposite.class.getName();
        this.tabCompositePaintListener = new PaintListener(){

            public void paintControl(PaintEvent e) {
                Composite comp = (Composite)e.widget;
                Rectangle rect = comp.getClientArea();
                e.gc.setForeground(DATabComposite.this.tabBGColorStart);
                e.gc.setBackground(DATabComposite.this.tabBGColorEnd);
                e.gc.fillGradientRectangle(rect.x, rect.y, rect.width, rect.height, true);
                e.gc.drawRectangle(rect);
            }
        };
        this.shell = parent.getShell();
        this.display = parent.getDisplay();
        this.construct();
    }

    public DATabComposite(Composite parent, int style, boolean istoplevel) {
        super(parent, style);
        this.ID = DATabComposite.class.getName();
        this.tabCompositePaintListener = new /* invalid duplicate definition of identical inner class */;
        this.isToplevel = istoplevel;
        this.shell = parent.getShell();
        this.display = parent.getDisplay();
        this.construct();
    }

    public DATabComposite(Composite parent, int style, boolean istoplevel, boolean enableImageTab) {
        super(parent, style);
        this.ID = DATabComposite.class.getName();
        this.tabCompositePaintListener = new /* invalid duplicate definition of identical inner class */;
        this.isToplevel = istoplevel;
        this.shell = parent.getShell();
        this.display = parent.getDisplay();
        this.enableImageTab(enableImageTab);
        this.construct();
    }

    private void construct() {
        this.dragCursor = new Cursor((Device)this.display, ImageResources.DRAG_TAB_32.getImageData(), 0, 0);
        this.basicCursor = new Cursor((Device)this.display, 0);
        this.buttons = new ArrayList<DATabButton>();
        this.children = new ArrayList<DABaseComposite>();
        this.tabComposite = new Composite((Composite)this, 0x20000000);
        this.tabComposite.setLayout((Layout)new FormLayout());
        this.contentsComposite = new Composite((Composite)this, 0x20000000);
        this.contentsStackLayout = new StackLayout();
        this.contentsComposite.setLayout((Layout)this.contentsStackLayout);
        this.setLayout((Layout)new FormLayout());
        FormData data = new FormData();
        data.top = new FormAttachment(0, 0);
        data.left = new FormAttachment(0, 0);
        data.right = new FormAttachment(100, 0);
        data.height = 31;
        this.tabComposite.setLayoutData((Object)data);
        this.tabComposite.addPaintListener(this.tabCompositePaintListener);
        data = new FormData();
        data.top = new FormAttachment((Control)this.tabComposite, 0);
        data.left = new FormAttachment(0, 0);
        data.right = new FormAttachment(100, 0);
        data.bottom = new FormAttachment(100, 0);
        this.contentsComposite.setLayoutData((Object)data);
        DAContainerComposite parentPage = WidgetUtils.getParentOfType(this, DAContainerComposite.class);
        if (parentPage != null && parentPage.getActiveTabComposite() == null) {
            parentPage.setActiveTabComposite(this);
        }
    }

    public DATabButton addView(String childId, DABaseComposite child, boolean usingAnimation) {
        if (child == null) {
            return null;
        }
        return this.addView(childId, child, usingAnimation, false);
    }

    public DATabButton addView(String childId, DABaseComposite child) {
        if (child == null) {
            return null;
        }
        return this.addView(childId, child, false, false);
    }

    public DATabButton addView(DABaseComposite child, boolean usingAnimation) {
        if (child == null) {
            return null;
        }
        return this.addView(child.getID(), child, usingAnimation, false);
    }

    public DATabButton addView(DABaseComposite child) {
        if (child == null) {
            return null;
        }
        return this.addView(child.getID(), child, false, false);
    }

    public DATabButton addView(String childId, DABaseComposite child, boolean usingAnimation, boolean closeable) {
        DATabButton tabButton;
        if (child == null || this.children.contains((Object)child)) {
            return null;
        }
        String ID = null;
        ID = childId == null || childId.isEmpty() ? ((Object)((Object)child)).getClass().getName() : childId;
        child.setID(ID);
        String title = child.getTitle();
        if (this.isImageTab) {
            tabButton = new DATabButton(this.tabComposite, 0, true);
            tabButton.setButtonFont(FontResources.TAB_BUTTON_FONT);
        } else {
            tabButton = new DATabButton(this.tabComposite, 0, false);
            tabButton.setButtonFont(FontResources.TAB_BUTTON_BOLD_FONT);
        }
        tabButton.setFontColors(ColorResources.TAB_NORMAL_FONT_COLOR, ColorResources.TAB_PUSH_FONT_COLOR, ColorResources.TAB_HOVER_FONT_COLOR, ColorResources.TAB_SELECTED_FONT_COLOR);
        tabButton.setOutlineColors(ColorResources.TAB_NORMAL_COLOR_START, ColorResources.TAB_SELECTED_COLOR_START, ColorResources.TAB_NORMAL_COLOR_START, ColorResources.TAB_SELECTED_COLOR_START);
        tabButton.setRenderer(new TabButtonRenderer());
        tabButton.setButtonEnabled(true);
        tabButton.setBackground(ColorResources.WHITE);
        tabButton.setText(title);
        tabButton.setToolTipText((String)child.getData("tooltip"));
        tabButton.setClosable(closeable);
        FormData data = new FormData();
        data.top = new FormAttachment(0, 1);
        data.bottom = new FormAttachment(100, 0);
        if (this.buttons.size() > 0) {
            DATabButton lastbutton = this.buttons.get(this.buttons.size() - 1);
            data.left = new FormAttachment((Control)lastbutton, 0);
            if (!usingAnimation) {
                data.width = this.tabWidth;
            }
        } else {
            data.left = new FormAttachment(0, 0);
            if (!usingAnimation) {
                data.width = this.tabWidth;
            }
        }
        tabButton.setLayoutData(data);
        final DABaseComposite finalChild = child;
        Listener tabMoveEvent = new Listener(){

            public void handleEvent(Event event) {
                Point cursorLocation = Display.getCurrent().getCursorLocation();
                Point curPosition = DATabComposite.this.tabComposite.toControl(cursorLocation);
                DATabComposite.this.targetButtonIndex = curPosition.x / DATabComposite.this.tabWidth;
                switch (event.type) {
                    case 3: {
                        DATabComposite.this.drag = true;
                        DATabComposite.this.sourceButton = (DATabButton)event.widget;
                        DATabComposite.this.sourceButtonIndex = DATabComposite.this.buttons.indexOf((Object)DATabComposite.this.sourceButton);
                        break;
                    }
                    case 4: {
                        DATabComposite.this.shell.setCursor(null);
                        DATabComposite.this.drag = false;
                        if (DATabComposite.this.targetButtonIndex == DATabComposite.this.sourceButtonIndex) {
                            DATabComposite.this.changeButtonState(tabButton);
                        }
                        DATabComposite.this.lasttab = ((DATabComposite)DATabComposite.this).contentsStackLayout.topControl;
                        ((DATabComposite)DATabComposite.this).contentsStackLayout.topControl = finalChild;
                        DATabComposite.this.tabComposite.layout();
                        DATabComposite.this.contentsComposite.layout();
                        finalChild.update();
                        finalChild.updateView();
                        DATabComposite.this.activateTab();
                        break;
                    }
                    case 5: {
                        if (!DATabComposite.this.drag) break;
                        DATabComposite.this.shell.setCursor(DATabComposite.this.dragCursor);
                        if (curPosition.y < DATabComposite.this.tabComposite.getBounds().y || curPosition.y > DATabComposite.this.tabComposite.getBounds().height || DATabComposite.this.sourceButtonIndex == DATabComposite.this.buttons.size()) break;
                        if (curPosition.x <= 0) {
                            DATabComposite.this.targetButtonIndex = 0;
                        } else if (curPosition.x > DATabComposite.this.tabWidth * DATabComposite.this.buttons.size()) {
                            DATabComposite.this.targetButtonIndex = DATabComposite.this.buttons.size() - 1;
                        }
                        if (DATabComposite.this.targetButtonIndex == DATabComposite.this.sourceButtonIndex) {
                            DATabComposite.this.changeButtonState(tabButton);
                        } else {
                            DATabComposite.this.reArrangeTabs();
                            DATabComposite.this.sourceButtonIndex = DATabComposite.this.targetButtonIndex;
                        }
                        DATabComposite.this.lasttab = ((DATabComposite)DATabComposite.this).contentsStackLayout.topControl;
                        ((DATabComposite)DATabComposite.this).contentsStackLayout.topControl = finalChild;
                        DATabComposite.this.tabComposite.layout();
                        DATabComposite.this.contentsComposite.layout();
                    }
                }
            }
        };
        tabButton.addListener(4, tabMoveEvent);
        tabButton.addListener(3, tabMoveEvent);
        tabButton.addListener(5, tabMoveEvent);
        this.buttons.add(tabButton);
        this.children.add(child);
        if (this.children.size() == 1) {
            this.lasttab = this.contentsStackLayout.topControl;
            this.contentsStackLayout.topControl = child;
            this.contentsComposite.layout();
            tabButton.setGradationColor(3, ColorResources.TAB_SELECTED_COLOR_START, ColorResources.TAB_SELECTED_COLOR_END);
            tabButton.setButtonEnabled(false);
            tabButton.setRenderer(new TabButtonRenderer());
        }
        if (usingAnimation) {
            data.width = 1;
            this.tabAnimation(tabButton, true);
        } else {
            this.tabComposite.layout();
        }
        return tabButton;
    }

    private void changeButtonState(DATabButton button) {
        int size = this.buttons.size();
        if (size > 1) {
            int i = 0;
            while (i < size) {
                DATabButton sample = this.buttons.get(i);
                if (((Object)((Object)sample)).equals((Object)button)) {
                    button.setGradationColor(3, ColorResources.TAB_SELECTED_COLOR_START, ColorResources.TAB_SELECTED_COLOR_END);
                    button.setButtonEnabled(false);
                } else {
                    sample.setButtonEnabled(true);
                }
                ++i;
            }
        }
    }

    private void reArrangeTabs() {
        if (this.sourceButtonIndex < this.targetButtonIndex) {
            this.setLayoutTabs(this.targetButtonIndex, this.sourceButtonIndex);
            if (this.sourceButtonIndex == 0) {
                this.setLayoutTabs(-1, this.sourceButtonIndex + 1);
            } else {
                this.setLayoutTabs(this.sourceButtonIndex - 1, this.sourceButtonIndex + 1);
            }
            if (this.targetButtonIndex != this.buttons.size() - 1) {
                this.setLayoutTabs(this.sourceButtonIndex, this.targetButtonIndex + 1);
            }
            Collections.rotate(this.buttons.subList(this.sourceButtonIndex, this.targetButtonIndex + 1), -1);
            Collections.rotate(this.children.subList(this.sourceButtonIndex, this.targetButtonIndex + 1), -1);
        } else {
            if (this.targetButtonIndex == 0) {
                this.setLayoutTabs(-1, this.sourceButtonIndex);
            } else {
                this.setLayoutTabs(this.targetButtonIndex - 1, this.sourceButtonIndex);
            }
            if (this.sourceButtonIndex != this.buttons.size() - 1) {
                this.setLayoutTabs(this.sourceButtonIndex - 1, this.sourceButtonIndex + 1);
            }
            this.setLayoutTabs(this.sourceButtonIndex, this.targetButtonIndex);
            Collections.rotate(this.buttons.subList(this.targetButtonIndex, this.sourceButtonIndex + 1), 1);
            Collections.rotate(this.children.subList(this.targetButtonIndex, this.sourceButtonIndex + 1), 1);
        }
    }

    private void setLayoutTabs(int leftTabIndex, int tabIndex) {
        FormData data = new FormData();
        data.top = new FormAttachment(0, 1);
        data.bottom = new FormAttachment(100, 0);
        data.width = this.tabWidth;
        data.left = leftTabIndex != -1 ? new FormAttachment((Control)this.buttons.get(leftTabIndex), 2) : new FormAttachment(0, 2);
        this.buttons.get(tabIndex).setLayoutData(data);
    }

    private void tabAnimation(final DATabButton button, final boolean isShow) {
        Timer timer = new Timer();
        timer.schedule(new TimerTask(){

            @Override
            public void run() {
                Display.getDefault().syncExec(new Runnable(){

                    @Override
                    public void run() {
                        if (button != null && !button.isDisposed()) {
                            button.setAnimating(true);
                            FormData data = (FormData)button.getLayoutData();
                            if (isShow) {
                                data.width += DATabComposite.this.tabWidth / 10;
                                if (data.width > DATabComposite.this.tabWidth) {
                                    data.width = DATabComposite.this.tabWidth;
                                    (this).DATabComposite.this.tabComposite.layout();
                                    button.setAnimating(false);
                                    this.cancel();
                                } else {
                                    (this).DATabComposite.this.tabComposite.layout();
                                }
                            } else {
                                data.width -= DATabComposite.this.tabWidth / 10;
                                (this).DATabComposite.this.tabComposite.layout();
                                if (data.width <= 0) {
                                    button.setAnimating(false);
                                    this.cancel();
                                    DATabComposite.this.changeLastTabPage();
                                }
                            }
                        } else {
                            this.cancel();
                        }
                    }
                });
            }
        }, 10L, 50L);
    }

    public void removeView(String viewID, boolean usingAnimation) {
        DABaseComposite child = this.getView(viewID);
        int index = this.children.indexOf((Object)child);
        if (index < 0) {
            Logger.warning((String)"[%s] can't remove tab %s", (Object[])new Object[]{this.ID, viewID});
            return;
        }
        this.children.remove(index);
        this.contentsComposite.layout();
        this.tabComposite.layout();
        DATabButton button = this.buttons.remove(index);
        if (!usingAnimation) {
            FormData data = (FormData)button.getLayoutData();
            data.width = 0;
        } else {
            button.setGradationColor(3, ColorResources.TAB_NORMAL_COLOR_START, ColorResources.TAB_NORMAL_COLOR_START);
            button.setButtonEnabled(false);
            this.tabAnimation(button, false);
        }
        if (child == this.contentsStackLayout.topControl) {
            this.contentsStackLayout.topControl = this.lasttab;
            this.contentsComposite.layout();
        }
        this.contentsComposite.layout();
        this.tabComposite.layout();
    }

    public void removeAll() {
        int i = 0;
        while (i < this.buttons.size()) {
            FormData data = (FormData)this.buttons.get(i).getLayoutData();
            data.width = 0;
            ++i;
        }
        this.children.clear();
        this.buttons.clear();
    }

    public boolean isExistingPage(String id) {
        DABaseComposite child = this.getView(id);
        return child != null;
    }

    public Composite getContentComposite() {
        return this.contentsComposite;
    }

    public void selectTab(String ID) {
        DABaseComposite tab = this.getView(ID);
        int index = this.children.indexOf((Object)tab);
        DATabButton button = this.buttons.get(index);
        if (tab == null || button == null) {
            Logger.debug((Object)"tab create bug!!");
            return;
        }
        this.changeButtonState(button);
        this.lasttab = this.contentsStackLayout.topControl;
        this.contentsStackLayout.topControl = tab;
        tab.updateView();
        this.contentsComposite.layout();
    }

    public void changeLastTabPage() {
        DATabButton lastTab = this.buttons.get(this.children.size() - 1);
        this.changeButtonState(lastTab);
        DABaseComposite last = this.children.get(this.children.size() - 1);
        this.contentsStackLayout.topControl = last;
        last.updateView();
        this.contentsComposite.layout();
    }

    @Override
    public void clear() {
        IntervalManager.INSTANCE.clearIntervals();
        int size = this.children.size();
        int i = 0;
        while (i < size) {
            this.children.get(i).clear();
            ++i;
        }
    }

    @Override
    public void updateView() {
        if (this.isToplevel) {
            this.getTopComposite().updateView();
        } else {
            int size = this.children.size();
            int i = 0;
            while (i < size) {
                this.children.get(i).updateView();
                ++i;
            }
        }
    }

    @Override
    public void updateView(DAViewData data) {
        int size = this.children.size();
        String viewid = data.getViewID();
        int i = 0;
        while (i < size) {
            if (!this.children.get(i).getID().equals(viewid)) {
                this.children.get(i).updateView(data);
            }
            ++i;
        }
    }

    @Override
    public void callUpdatePage(DAChartBoardItem selectedItem) {
        if (this.isToplevel) {
            this.getTopComposite().callUpdatePage(selectedItem);
        } else {
            int size = this.children.size();
            int i = 0;
            while (i < size) {
                this.children.get(i).callUpdatePage(selectedItem);
                ++i;
            }
        }
    }

    public DABaseComposite getTopComposite() {
        return (DABaseComposite)this.contentsStackLayout.topControl;
    }

    public void setTabWidth(int size) {
        this.tabWidth = size;
    }

    public void enableImageTab(boolean isImageTab) {
        this.isImageTab = isImageTab;
    }

    @Override
    public DABaseComposite getView(String ID) {
        DABaseComposite child;
        DABaseComposite ret = null;
        int size = this.children.size();
        int i = 0;
        while (i < size) {
            child = this.children.get(i);
            if (child.getID().equals(ID)) {
                ret = child;
                break;
            }
            ++i;
        }
        if (ret == null) {
            i = 0;
            while (i < size) {
                child = this.children.get(i);
                if (child.isContainer() && (ret = child.getView(ID)) != null) break;
                ++i;
            }
        }
        return ret;
    }

    public List<String> getViewIDList() {
        ArrayList<String> tabViewList = new ArrayList<String>();
        int size = this.children.size();
        int i = 0;
        while (i < size) {
            tabViewList.add(this.children.get(i).getID());
            ++i;
        }
        return tabViewList;
    }

    @Override
    protected boolean isContainer() {
        return true;
    }

    public void setTabBGColor(Color tabBGColorStart, Color tabBGColorEnd) {
        this.tabBGColorStart = tabBGColorStart;
        this.tabBGColorEnd = tabBGColorEnd;
    }

    public void updateTabButtonsWidth(int width) {
        this.setTabWidth(width);
        for (DATabButton button : this.buttons) {
            FormData data = (FormData)button.getLayoutData();
            data.width = width;
        }
        this.tabComposite.layout();
    }

    public List<DATabButton> getTabButtons() {
        return this.buttons;
    }

    public void activateTab() {
        DAContainerComposite parentPage = WidgetUtils.getParentOfType(this, DAContainerComposite.class);
        if (parentPage != null) {
            parentPage.setActiveTabComposite(this);
        }
    }

    public void resizeTableButton(int width) {
        int tabCount = this.buttons.size();
        int newWidth = width / tabCount > 190 ? 190 : width / tabCount;
        this.updateTabButtonsWidth(newWidth);
    }
}

