/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.core.contexts;

import java.lang.annotation.Annotation;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.core.di.IInjector;
import org.eclipse.e4.core.di.InjectionException;
import org.eclipse.e4.core.di.InjectorFactory;
import org.eclipse.e4.core.di.suppliers.PrimaryObjectSupplier;
import org.eclipse.e4.core.internal.contexts.ContextObjectSupplier;
import org.eclipse.e4.core.internal.contexts.EclipseContext;

public final class ContextInjectionFactory {
    private static final IInjector injector = InjectorFactory.getDefault();

    private ContextInjectionFactory() {
    }

    public static void inject(Object object, IEclipseContext context) throws InjectionException {
        ContextObjectSupplier supplier = ContextObjectSupplier.getObjectSupplier(context, injector);
        injector.inject(object, (PrimaryObjectSupplier)supplier);
    }

    public static Object invoke(Object object, Class<? extends Annotation> qualifier, IEclipseContext context) throws InjectionException {
        ContextObjectSupplier supplier = ContextObjectSupplier.getObjectSupplier(context, injector);
        return injector.invoke(object, qualifier, (PrimaryObjectSupplier)supplier);
    }

    public static Object invoke(Object object, Class<? extends Annotation> qualifier, IEclipseContext context, Object defaultValue) throws InjectionException {
        ContextObjectSupplier supplier = ContextObjectSupplier.getObjectSupplier(context, injector);
        return injector.invoke(object, qualifier, defaultValue, (PrimaryObjectSupplier)supplier);
    }

    public static Object invoke(Object object, Class<? extends Annotation> qualifier, IEclipseContext context, IEclipseContext localContext, Object defaultValue) throws InjectionException {
        ContextObjectSupplier supplier = ContextObjectSupplier.getObjectSupplier(context, injector);
        ContextObjectSupplier tempSupplier = ContextObjectSupplier.getObjectSupplier(localContext, injector);
        return injector.invoke(object, qualifier, defaultValue, (PrimaryObjectSupplier)supplier, (PrimaryObjectSupplier)tempSupplier);
    }

    public static void uninject(Object object, IEclipseContext context) throws InjectionException {
        ((EclipseContext)context).removeListenersTo(object);
    }

    public static <T> T make(Class<T> clazz, IEclipseContext context) throws InjectionException {
        ContextObjectSupplier supplier = ContextObjectSupplier.getObjectSupplier(context, injector);
        return (T)injector.make(clazz, (PrimaryObjectSupplier)supplier);
    }

    public static <T> T make(Class<T> clazz, IEclipseContext context, IEclipseContext staticContext) throws InjectionException {
        ContextObjectSupplier supplier = ContextObjectSupplier.getObjectSupplier(context, injector);
        ContextObjectSupplier tempSupplier = ContextObjectSupplier.getObjectSupplier(staticContext, injector);
        return (T)injector.make(clazz, (PrimaryObjectSupplier)supplier, (PrimaryObjectSupplier)tempSupplier);
    }

    public static void setDefault(IEclipseContext context) {
        ContextObjectSupplier supplier = ContextObjectSupplier.getObjectSupplier(context, injector);
        injector.setDefaultSupplier((PrimaryObjectSupplier)supplier);
    }
}

