/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.dynamicanalyzer.common;

import java.io.File;
import org.eclipse.ui.IPerspectiveListener;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchListener;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.BundleContext;
import org.tizen.dynamicanalyzer.common.AboutInfo;
import org.tizen.dynamicanalyzer.common.RemoteLogger;
import org.tizen.dynamicanalyzer.common.path.PathManager;
import org.tizen.dynamicanalyzer.database.SqlConnectionManager;
import org.tizen.dynamicanalyzer.listeners.AnalyzerPerspectiveListener;
import org.tizen.dynamicanalyzer.util.Logger;
import org.tizen.dynamicanalyzer.utils.AnalyzerUtil;

public class AnalyzerPlugin
extends AbstractUIPlugin {
    private static AnalyzerPlugin plugin;
    public static final String PRODUCT_NAME = "Dynamic Analyzer";
    private static long startTime;
    private static long endTime;
    private static long usage;

    public static AnalyzerPlugin getDefault() {
        return plugin;
    }

    public void start(BundleContext context) throws Exception {
        Logger.info((Object)(">>> DA version: " + AboutInfo.getInstance().getDABuildID() + ", SDK version: " + AboutInfo.getInstance().getSDKVersion() + " <<<"));
        super.start(context);
        plugin = this;
        startTime = System.currentTimeMillis() / 1000L;
        RemoteLogger.logAccess(PRODUCT_NAME);
        AnalyzerUtil.setPlatformSDK();
        IWorkbench workbench = PlatformUI.getWorkbench();
        workbench.getActiveWorkbenchWindow().getPages();
        workbench.addWorkbenchListener(new IWorkbenchListener(){

            public void postShutdown(IWorkbench workbench) {
                SqlConnectionManager.closeConnection();
                File tempDir = new File(PathManager.DA_TEMP_FOLDER_PATH);
                if (tempDir.isDirectory() && tempDir.exists()) {
                    if (AnalyzerUtil.deleteFile(tempDir)) {
                        Logger.debug((Object)"Delete temp folder!");
                    } else {
                        Logger.debug((Object)"Delete temp folder fail...");
                    }
                }
            }

            public boolean preShutdown(IWorkbench workbench, boolean forced) {
                return true;
            }
        });
        IWorkbenchWindow window = workbench.getActiveWorkbenchWindow();
        window.addPerspectiveListener((IPerspectiveListener)new AnalyzerPerspectiveListener());
        PathManager.createDATempDir();
    }

    public void stop(BundleContext context) throws Exception {
        endTime = System.currentTimeMillis() / 1000L;
        usage = endTime - startTime;
        RemoteLogger.logUsage(PRODUCT_NAME, usage);
        plugin = null;
        super.stop(context);
    }
}

