/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.dynamicanalyzer.ui.info.process;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.swt.widgets.Composite;
import org.tizen.dynamicanalyzer.model.TableInput;
import org.tizen.dynamicanalyzer.ui.info.process.ProcessData;
import org.tizen.dynamicanalyzer.ui.info.process.ProcessDataManager;
import org.tizen.dynamicanalyzer.ui.widgets.table.DATableComposite;
import org.tizen.dynamicanalyzer.ui.widgets.table.DATableDataFormat;

public class ProcessTable
extends DATableComposite {
    public ProcessTable(Composite parent, int style, int tableStyle) {
        super(parent, style, tableStyle);
    }

    @Override
    protected List<TableInput> makeTableInput() {
        ArrayList<TableInput> input = new ArrayList<TableInput>();
        List<ProcessData> processData = ProcessDataManager.getInstance().getProcessData();
        int i = 0;
        while (i < processData.size()) {
            ArrayList<String> text = new ArrayList<String>();
            ProcessData data = processData.get(i);
            DATableDataFormat tableData = new DATableDataFormat(data.getPID());
            ArrayList<Object> sortingData = new ArrayList<Object>();
            text.add(data.getProcessName());
            sortingData.add(data.getProcessName());
            text.add(String.valueOf(data.getPID()));
            sortingData.add(data.getPID());
            text.add(data.getCpuLoad());
            Double cpuLoad = new Double(data.getCpuLoad()) * 100.0;
            sortingData.add(cpuLoad.intValue());
            TableInput tableInput = new TableInput();
            tableInput.setText(text);
            tableData.getData().addAll(sortingData);
            tableInput.setData(tableData);
            input.add(tableInput);
            ++i;
        }
        return input;
    }
}

