/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.edc;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;

public abstract class MessageLogger {
    public static final String MISSING_MESSAGE_PLACEHOLDER = "Internal error";
    public static final String MULTIPLE_MESSAGE_PLACEHOLDER = "Multiple problems have occurred";
    private static List<Listener> listeners = new ArrayList<Listener>();

    public static synchronized void addListener(Listener listener) {
        if (!listeners.contains(listener)) {
            listeners.add(listener);
        }
    }

    public static synchronized void removeListener(Listener listener) {
        listeners.remove(listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static void fireListener(IStatus status) {
        Listener[] array;
        List<Listener> list = listeners;
        synchronized (list) {
            array = listeners.toArray(new Listener[listeners.size()]);
        }
        Listener[] listenerArray = array;
        int n = array.length;
        int n2 = 0;
        while (n2 < n) {
            Listener listener = listenerArray[n2];
            listener.statusLogged(status);
            ++n2;
        }
    }

    protected void doLog(IStatus status) {
        if (this.getPlugin() != null) {
            this.getPlugin().getLog().log(status);
        } else {
            System.err.println(status.toString());
            if (status.getException() != null) {
                status.getException().printStackTrace(System.err);
            }
        }
        MessageLogger.fireListener(status);
    }

    public IStatus createStatus(int severity, String mainMessage, Throwable exception) {
        IStatus status;
        String pluginID = this.getPluginID();
        if (MessageLogger.isEmpty(mainMessage) && exception instanceof CoreException) {
            status = ((CoreException)exception).getStatus();
            exception = null;
            if (!MessageLogger.isEmpty(status.getMessage())) {
                if (!this.isRealMultiStatus(status)) {
                    return status;
                }
                mainMessage = MULTIPLE_MESSAGE_PLACEHOLDER;
            }
            if (status.getException() != null && status.getException().getMessage() != null) {
                mainMessage = status.getException().getMessage();
                exception = status.getException();
            } else {
                return status;
            }
        }
        if (MessageLogger.isEmpty(mainMessage)) {
            Throwable base = exception;
            while (base != null && MessageLogger.isEmpty(base.getMessage())) {
                base = base.getCause();
            }
            mainMessage = base != null && !MessageLogger.isEmpty(base.getMessage()) ? base.getMessage() : MISSING_MESSAGE_PLACEHOLDER;
        }
        status = new Status(severity, pluginID, mainMessage, exception);
        return status;
    }

    private static boolean isEmpty(String text) {
        return text == null || text.length() == 0;
    }

    public void log(IStatus status) {
        if (status.getSeverity() == 8) {
            return;
        }
        if (MessageLogger.isEmpty(status.getMessage()) && !this.isRealMultiStatus(status)) {
            status = this.createStatus(status.getSeverity(), null, status.getException());
        }
        this.doLog(status);
    }

    private boolean isRealMultiStatus(IStatus status) {
        return status.isMultiStatus() && ((MultiStatus)status).getChildren().length > 0;
    }

    public void log(int severity, String mainMessage, Throwable exception) {
        IStatus status = this.createStatus(severity, mainMessage, exception);
        this.log(status);
    }

    public void logError(String mainMessage, Throwable t) {
        this.log(4, mainMessage, t);
    }

    public void logException(Throwable t) {
        this.log(4, null, t);
    }

    public abstract Plugin getPlugin();

    public abstract String getPluginID();

    public static interface Listener {
        public void statusLogged(IStatus var1);
    }
}

