/*
 * Decompiled with CFR 0.152.
 */
package com.google.protobuf;

import com.google.protobuf.ByteString;
import com.google.protobuf.ExtensionRegistryLite;
import com.google.protobuf.InvalidProtocolBufferException;
import com.google.protobuf.MessageLite;
import com.google.protobuf.Parser;
import com.google.protobuf.WireFormat;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;

public final class CodedInputStream {
    private final byte[] buffer;
    private int bufferSize;
    private int bufferSizeAfterLimit;
    private int bufferPos;
    private final InputStream input;
    private int lastTag;
    private int totalBytesRetired;
    private int currentLimit = Integer.MAX_VALUE;
    private int recursionDepth;
    private int recursionLimit = 64;
    private int sizeLimit = 0x4000000;
    private static final int DEFAULT_RECURSION_LIMIT = 64;
    private static final int DEFAULT_SIZE_LIMIT = 0x4000000;
    private static final int BUFFER_SIZE = 4096;

    public static CodedInputStream newInstance(InputStream inputStream) {
        return new CodedInputStream(inputStream);
    }

    public static CodedInputStream newInstance(byte[] byArray) {
        return CodedInputStream.newInstance(byArray, 0, byArray.length);
    }

    public static CodedInputStream newInstance(byte[] byArray, int n, int n2) {
        CodedInputStream codedInputStream = new CodedInputStream(byArray, n, n2);
        try {
            codedInputStream.pushLimit(n2);
        }
        catch (InvalidProtocolBufferException invalidProtocolBufferException) {
            throw new IllegalArgumentException(invalidProtocolBufferException);
        }
        return codedInputStream;
    }

    public int readTag() throws IOException {
        if (this.isAtEnd()) {
            this.lastTag = 0;
            return 0;
        }
        this.lastTag = this.readRawVarint32();
        if (WireFormat.getTagFieldNumber(this.lastTag) == 0) {
            throw InvalidProtocolBufferException.invalidTag();
        }
        return this.lastTag;
    }

    public void checkLastTagWas(int n) throws InvalidProtocolBufferException {
        if (this.lastTag != n) {
            throw InvalidProtocolBufferException.invalidEndTag();
        }
    }

    public boolean skipField(int n) throws IOException {
        switch (WireFormat.getTagWireType(n)) {
            case 0: {
                this.readInt32();
                return true;
            }
            case 1: {
                this.readRawLittleEndian64();
                return true;
            }
            case 2: {
                this.skipRawBytes(this.readRawVarint32());
                return true;
            }
            case 3: {
                this.skipMessage();
                this.checkLastTagWas(WireFormat.makeTag(WireFormat.getTagFieldNumber(n), 4));
                return true;
            }
            case 4: {
                return false;
            }
            case 5: {
                this.readRawLittleEndian32();
                return true;
            }
        }
        throw InvalidProtocolBufferException.invalidWireType();
    }

    public void skipMessage() throws IOException {
        int n;
        while ((n = this.readTag()) != 0 && this.skipField(n)) {
        }
    }

    public double readDouble() throws IOException {
        return Double.longBitsToDouble(this.readRawLittleEndian64());
    }

    public float readFloat() throws IOException {
        return Float.intBitsToFloat(this.readRawLittleEndian32());
    }

    public long readUInt64() throws IOException {
        return this.readRawVarint64();
    }

    public long readInt64() throws IOException {
        return this.readRawVarint64();
    }

    public int readInt32() throws IOException {
        return this.readRawVarint32();
    }

    public long readFixed64() throws IOException {
        return this.readRawLittleEndian64();
    }

    public int readFixed32() throws IOException {
        return this.readRawLittleEndian32();
    }

    public boolean readBool() throws IOException {
        return this.readRawVarint32() != 0;
    }

    public String readString() throws IOException {
        int n = this.readRawVarint32();
        if (n <= this.bufferSize - this.bufferPos && n > 0) {
            String string = new String(this.buffer, this.bufferPos, n, "UTF-8");
            this.bufferPos += n;
            return string;
        }
        return new String(this.readRawBytes(n), "UTF-8");
    }

    public void readGroup(int n, MessageLite.Builder builder, ExtensionRegistryLite extensionRegistryLite) throws IOException {
        if (this.recursionDepth >= this.recursionLimit) {
            throw InvalidProtocolBufferException.recursionLimitExceeded();
        }
        ++this.recursionDepth;
        builder.mergeFrom(this, extensionRegistryLite);
        this.checkLastTagWas(WireFormat.makeTag(n, 4));
        --this.recursionDepth;
    }

    public <T extends MessageLite> T readGroup(int n, Parser<T> parser, ExtensionRegistryLite extensionRegistryLite) throws IOException {
        if (this.recursionDepth >= this.recursionLimit) {
            throw InvalidProtocolBufferException.recursionLimitExceeded();
        }
        ++this.recursionDepth;
        MessageLite messageLite = (MessageLite)parser.parsePartialFrom(this, extensionRegistryLite);
        this.checkLastTagWas(WireFormat.makeTag(n, 4));
        --this.recursionDepth;
        return (T)messageLite;
    }

    @Deprecated
    public void readUnknownGroup(int n, MessageLite.Builder builder) throws IOException {
        this.readGroup(n, builder, null);
    }

    public void readMessage(MessageLite.Builder builder, ExtensionRegistryLite extensionRegistryLite) throws IOException {
        int n = this.readRawVarint32();
        if (this.recursionDepth >= this.recursionLimit) {
            throw InvalidProtocolBufferException.recursionLimitExceeded();
        }
        int n2 = this.pushLimit(n);
        ++this.recursionDepth;
        builder.mergeFrom(this, extensionRegistryLite);
        this.checkLastTagWas(0);
        --this.recursionDepth;
        this.popLimit(n2);
    }

    public <T extends MessageLite> T readMessage(Parser<T> parser, ExtensionRegistryLite extensionRegistryLite) throws IOException {
        int n = this.readRawVarint32();
        if (this.recursionDepth >= this.recursionLimit) {
            throw InvalidProtocolBufferException.recursionLimitExceeded();
        }
        int n2 = this.pushLimit(n);
        ++this.recursionDepth;
        MessageLite messageLite = (MessageLite)parser.parsePartialFrom(this, extensionRegistryLite);
        this.checkLastTagWas(0);
        --this.recursionDepth;
        this.popLimit(n2);
        return (T)messageLite;
    }

    public ByteString readBytes() throws IOException {
        int n = this.readRawVarint32();
        if (n == 0) {
            return ByteString.EMPTY;
        }
        if (n <= this.bufferSize - this.bufferPos && n > 0) {
            ByteString byteString = ByteString.copyFrom(this.buffer, this.bufferPos, n);
            this.bufferPos += n;
            return byteString;
        }
        return ByteString.copyFrom(this.readRawBytes(n));
    }

    public int readUInt32() throws IOException {
        return this.readRawVarint32();
    }

    public int readEnum() throws IOException {
        return this.readRawVarint32();
    }

    public int readSFixed32() throws IOException {
        return this.readRawLittleEndian32();
    }

    public long readSFixed64() throws IOException {
        return this.readRawLittleEndian64();
    }

    public int readSInt32() throws IOException {
        return CodedInputStream.decodeZigZag32(this.readRawVarint32());
    }

    public long readSInt64() throws IOException {
        return CodedInputStream.decodeZigZag64(this.readRawVarint64());
    }

    public int readRawVarint32() throws IOException {
        byte by = this.readRawByte();
        if (by >= 0) {
            return by;
        }
        int n = by & 0x7F;
        by = this.readRawByte();
        if (by >= 0) {
            n |= by << 7;
        } else {
            n |= (by & 0x7F) << 7;
            by = this.readRawByte();
            if (by >= 0) {
                n |= by << 14;
            } else {
                n |= (by & 0x7F) << 14;
                by = this.readRawByte();
                if (by >= 0) {
                    n |= by << 21;
                } else {
                    n |= (by & 0x7F) << 21;
                    by = this.readRawByte();
                    n |= by << 28;
                    if (by < 0) {
                        for (int i = 0; i < 5; ++i) {
                            if (this.readRawByte() < 0) continue;
                            return n;
                        }
                        throw InvalidProtocolBufferException.malformedVarint();
                    }
                }
            }
        }
        return n;
    }

    static int readRawVarint32(InputStream inputStream) throws IOException {
        int n = inputStream.read();
        if (n == -1) {
            throw InvalidProtocolBufferException.truncatedMessage();
        }
        return CodedInputStream.readRawVarint32(n, inputStream);
    }

    public static int readRawVarint32(int n, InputStream inputStream) throws IOException {
        int n2;
        int n3;
        if ((n & 0x80) == 0) {
            return n;
        }
        int n4 = n & 0x7F;
        for (n3 = 7; n3 < 32; n3 += 7) {
            n2 = inputStream.read();
            if (n2 == -1) {
                throw InvalidProtocolBufferException.truncatedMessage();
            }
            n4 |= (n2 & 0x7F) << n3;
            if ((n2 & 0x80) != 0) continue;
            return n4;
        }
        while (n3 < 64) {
            n2 = inputStream.read();
            if (n2 == -1) {
                throw InvalidProtocolBufferException.truncatedMessage();
            }
            if ((n2 & 0x80) == 0) {
                return n4;
            }
            n3 += 7;
        }
        throw InvalidProtocolBufferException.malformedVarint();
    }

    public long readRawVarint64() throws IOException {
        long l = 0L;
        for (int i = 0; i < 64; i += 7) {
            byte by = this.readRawByte();
            l |= (long)(by & 0x7F) << i;
            if ((by & 0x80) != 0) continue;
            return l;
        }
        throw InvalidProtocolBufferException.malformedVarint();
    }

    public int readRawLittleEndian32() throws IOException {
        byte by = this.readRawByte();
        byte by2 = this.readRawByte();
        byte by3 = this.readRawByte();
        byte by4 = this.readRawByte();
        return by & 0xFF | (by2 & 0xFF) << 8 | (by3 & 0xFF) << 16 | (by4 & 0xFF) << 24;
    }

    public long readRawLittleEndian64() throws IOException {
        byte by = this.readRawByte();
        byte by2 = this.readRawByte();
        byte by3 = this.readRawByte();
        byte by4 = this.readRawByte();
        byte by5 = this.readRawByte();
        byte by6 = this.readRawByte();
        byte by7 = this.readRawByte();
        byte by8 = this.readRawByte();
        return (long)by & 0xFFL | ((long)by2 & 0xFFL) << 8 | ((long)by3 & 0xFFL) << 16 | ((long)by4 & 0xFFL) << 24 | ((long)by5 & 0xFFL) << 32 | ((long)by6 & 0xFFL) << 40 | ((long)by7 & 0xFFL) << 48 | ((long)by8 & 0xFFL) << 56;
    }

    public static int decodeZigZag32(int n) {
        return n >>> 1 ^ -(n & 1);
    }

    public static long decodeZigZag64(long l) {
        return l >>> 1 ^ -(l & 1L);
    }

    private CodedInputStream(byte[] byArray, int n, int n2) {
        this.buffer = byArray;
        this.bufferSize = n + n2;
        this.bufferPos = n;
        this.totalBytesRetired = -n;
        this.input = null;
    }

    private CodedInputStream(InputStream inputStream) {
        this.buffer = new byte[4096];
        this.bufferSize = 0;
        this.bufferPos = 0;
        this.totalBytesRetired = 0;
        this.input = inputStream;
    }

    public int setRecursionLimit(int n) {
        if (n < 0) {
            throw new IllegalArgumentException("Recursion limit cannot be negative: " + n);
        }
        int n2 = this.recursionLimit;
        this.recursionLimit = n;
        return n2;
    }

    public int setSizeLimit(int n) {
        if (n < 0) {
            throw new IllegalArgumentException("Size limit cannot be negative: " + n);
        }
        int n2 = this.sizeLimit;
        this.sizeLimit = n;
        return n2;
    }

    public void resetSizeCounter() {
        this.totalBytesRetired = -this.bufferPos;
    }

    public int pushLimit(int n) throws InvalidProtocolBufferException {
        if (n < 0) {
            throw InvalidProtocolBufferException.negativeSize();
        }
        int n2 = this.currentLimit;
        if ((n += this.totalBytesRetired + this.bufferPos) > n2) {
            throw InvalidProtocolBufferException.truncatedMessage();
        }
        this.currentLimit = n;
        this.recomputeBufferSizeAfterLimit();
        return n2;
    }

    private void recomputeBufferSizeAfterLimit() {
        this.bufferSize += this.bufferSizeAfterLimit;
        int n = this.totalBytesRetired + this.bufferSize;
        if (n > this.currentLimit) {
            this.bufferSizeAfterLimit = n - this.currentLimit;
            this.bufferSize -= this.bufferSizeAfterLimit;
        } else {
            this.bufferSizeAfterLimit = 0;
        }
    }

    public void popLimit(int n) {
        this.currentLimit = n;
        this.recomputeBufferSizeAfterLimit();
    }

    public int getBytesUntilLimit() {
        if (this.currentLimit == Integer.MAX_VALUE) {
            return -1;
        }
        int n = this.totalBytesRetired + this.bufferPos;
        return this.currentLimit - n;
    }

    public boolean isAtEnd() throws IOException {
        return this.bufferPos == this.bufferSize && !this.refillBuffer(false);
    }

    public int getTotalBytesRead() {
        return this.totalBytesRetired + this.bufferPos;
    }

    private boolean refillBuffer(boolean bl) throws IOException {
        if (this.bufferPos < this.bufferSize) {
            throw new IllegalStateException("refillBuffer() called when buffer wasn't empty.");
        }
        if (this.totalBytesRetired + this.bufferSize == this.currentLimit) {
            if (bl) {
                throw InvalidProtocolBufferException.truncatedMessage();
            }
            return false;
        }
        this.totalBytesRetired += this.bufferSize;
        this.bufferPos = 0;
        int n = this.bufferSize = this.input == null ? -1 : this.input.read(this.buffer);
        if (this.bufferSize == 0 || this.bufferSize < -1) {
            throw new IllegalStateException("InputStream#read(byte[]) returned invalid result: " + this.bufferSize + "\nThe InputStream implementation is buggy.");
        }
        if (this.bufferSize == -1) {
            this.bufferSize = 0;
            if (bl) {
                throw InvalidProtocolBufferException.truncatedMessage();
            }
            return false;
        }
        this.recomputeBufferSizeAfterLimit();
        int n2 = this.totalBytesRetired + this.bufferSize + this.bufferSizeAfterLimit;
        if (n2 > this.sizeLimit || n2 < 0) {
            throw InvalidProtocolBufferException.sizeLimitExceeded();
        }
        return true;
    }

    public byte readRawByte() throws IOException {
        if (this.bufferPos == this.bufferSize) {
            this.refillBuffer(true);
        }
        return this.buffer[this.bufferPos++];
    }

    public byte[] readRawBytes(int n) throws IOException {
        int n2;
        byte[] byArray;
        if (n < 0) {
            throw InvalidProtocolBufferException.negativeSize();
        }
        if (this.totalBytesRetired + this.bufferPos + n > this.currentLimit) {
            this.skipRawBytes(this.currentLimit - this.totalBytesRetired - this.bufferPos);
            throw InvalidProtocolBufferException.truncatedMessage();
        }
        if (n <= this.bufferSize - this.bufferPos) {
            byte[] byArray2 = new byte[n];
            System.arraycopy(this.buffer, this.bufferPos, byArray2, 0, n);
            this.bufferPos += n;
            return byArray2;
        }
        if (n < 4096) {
            byte[] byArray3 = new byte[n];
            int n3 = this.bufferSize - this.bufferPos;
            System.arraycopy(this.buffer, this.bufferPos, byArray3, 0, n3);
            this.bufferPos = this.bufferSize;
            this.refillBuffer(true);
            while (n - n3 > this.bufferSize) {
                System.arraycopy(this.buffer, 0, byArray3, n3, this.bufferSize);
                n3 += this.bufferSize;
                this.bufferPos = this.bufferSize;
                this.refillBuffer(true);
            }
            System.arraycopy(this.buffer, 0, byArray3, n3, n - n3);
            this.bufferPos = n - n3;
            return byArray3;
        }
        int n4 = this.bufferPos;
        int n5 = this.bufferSize;
        this.totalBytesRetired += this.bufferSize;
        this.bufferPos = 0;
        this.bufferSize = 0;
        ArrayList<byte[]> arrayList = new ArrayList<byte[]>();
        for (int i = n - (n5 - n4); i > 0; i -= byArray.length) {
            int n6;
            byArray = new byte[Math.min(i, 4096)];
            for (n2 = 0; n2 < byArray.length; n2 += n6) {
                int n7 = n6 = this.input == null ? -1 : this.input.read(byArray, n2, byArray.length - n2);
                if (n6 == -1) {
                    throw InvalidProtocolBufferException.truncatedMessage();
                }
                this.totalBytesRetired += n6;
            }
            arrayList.add(byArray);
        }
        byArray = new byte[n];
        n2 = n5 - n4;
        System.arraycopy(this.buffer, n4, byArray, 0, n2);
        for (byte[] byArray4 : arrayList) {
            System.arraycopy(byArray4, 0, byArray, n2, byArray4.length);
            n2 += byArray4.length;
        }
        return byArray;
    }

    public void skipRawBytes(int n) throws IOException {
        if (n < 0) {
            throw InvalidProtocolBufferException.negativeSize();
        }
        if (this.totalBytesRetired + this.bufferPos + n > this.currentLimit) {
            this.skipRawBytes(this.currentLimit - this.totalBytesRetired - this.bufferPos);
            throw InvalidProtocolBufferException.truncatedMessage();
        }
        if (n <= this.bufferSize - this.bufferPos) {
            this.bufferPos += n;
        } else {
            int n2 = this.bufferSize - this.bufferPos;
            this.bufferPos = this.bufferSize;
            this.refillBuffer(true);
            while (n - n2 > this.bufferSize) {
                n2 += this.bufferSize;
                this.bufferPos = this.bufferSize;
                this.refillBuffer(true);
            }
            this.bufferPos = n - n2;
        }
    }
}

