/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.edc.launch;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.eclipse.cdt.debug.core.sourcelookup.AbsolutePathSourceContainer;
import org.eclipse.cdt.debug.edc.internal.EDCDebugger;
import org.eclipse.cdt.debug.edc.internal.ExecutablesSourceContainer;
import org.eclipse.cdt.debug.edc.internal.PathUtils;
import org.eclipse.cdt.debug.edc.internal.launch.ShutdownSequence;
import org.eclipse.cdt.debug.edc.internal.services.dsf.Processes;
import org.eclipse.cdt.debug.edc.internal.services.dsf.RunControl;
import org.eclipse.cdt.debug.edc.internal.snapshot.Album;
import org.eclipse.cdt.debug.edc.internal.snapshot.SnapshotUtils;
import org.eclipse.cdt.debug.edc.snapshot.IAlbum;
import org.eclipse.cdt.debug.internal.core.sourcelookup.CSourceLookupDirector;
import org.eclipse.cdt.dsf.concurrent.ConfinedToDsfExecutor;
import org.eclipse.cdt.dsf.concurrent.DefaultDsfExecutor;
import org.eclipse.cdt.dsf.concurrent.DsfExecutor;
import org.eclipse.cdt.dsf.concurrent.DsfRunnable;
import org.eclipse.cdt.dsf.concurrent.ImmediateExecutor;
import org.eclipse.cdt.dsf.concurrent.RequestMonitor;
import org.eclipse.cdt.dsf.concurrent.ThreadSafe;
import org.eclipse.cdt.dsf.debug.model.DsfLaunch;
import org.eclipse.cdt.dsf.debug.model.DsfMemoryBlockRetrieval;
import org.eclipse.cdt.dsf.debug.service.IDsfDebugServicesFactory;
import org.eclipse.cdt.dsf.debug.service.IRunControl;
import org.eclipse.cdt.dsf.debug.service.command.ICommandControlService;
import org.eclipse.cdt.dsf.debug.sourcelookup.DsfSourceLookupDirector;
import org.eclipse.cdt.dsf.service.DsfServiceEventHandler;
import org.eclipse.cdt.dsf.service.DsfServicesTracker;
import org.eclipse.cdt.dsf.service.DsfSession;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchManager;
import org.eclipse.debug.core.model.IMemoryBlockRetrieval;
import org.eclipse.debug.core.model.ISourceLocator;
import org.eclipse.debug.core.sourcelookup.ISourceContainer;
import org.eclipse.debug.core.sourcelookup.ISourceLookupDirector;
import org.eclipse.debug.core.sourcelookup.containers.DirectorySourceContainer;
import org.eclipse.tm.tcf.protocol.IChannel;
import org.eclipse.tm.tcf.protocol.IPeer;
import org.eclipse.tm.tcf.protocol.Protocol;

@ThreadSafe
public abstract class EDCLaunch
extends DsfLaunch {
    private DefaultDsfExecutor executor;
    private final DsfSession session;
    private DsfServicesTracker tracker;
    private boolean initialized;
    private boolean shutDown;
    private boolean isLaunching;
    private boolean isTerminating;
    private DsfMemoryBlockRetrieval memRetrieval;
    private IDsfDebugServicesFactory serviceFactory;
    private final String debugModelID;
    private String description;
    private Album album;
    private boolean snapshotSupportInitialized;
    private boolean isFirstLaunch = true;
    private ILaunchConfiguration activeLaunchConfiguration;
    private List<ILaunchConfiguration> affiliatedLaunchConfigurations = Collections.synchronizedList(new ArrayList());
    private boolean isTerminatedThanDisconnected = false;
    private boolean shuttingDown;
    private static final Map<EDCLaunch, List<IChannel>> launchChannels = Collections.synchronizedMap(new HashMap());
    private static final Map<String, EDCLaunch> launchSessions = Collections.synchronizedMap(new HashMap());
    private static final Map<String, ExecutorService> threadPools = Collections.synchronizedMap(new HashMap());

    public EDCLaunch(ILaunchConfiguration launchConfiguration, String mode, ISourceLocator locator, String ownerID) {
        super(launchConfiguration, mode, locator);
        this.debugModelID = ownerID;
        DefaultDsfExecutor dsfExecutor = new DefaultDsfExecutor("DSF executor - " + ownerID);
        dsfExecutor.prestartCoreThread();
        this.executor = dsfExecutor;
        this.session = DsfSession.startSession((DsfExecutor)this.executor, (String)ownerID);
        launchSessions.put(this.session.getId(), this);
        threadPools.put(this.session.getId(), this.newThreadPool());
    }

    private ThreadPoolExecutor newThreadPool() {
        int coreThreadCount = EDCLaunch.getBackdoorValue("org.eclipse.cdt.edc.poolthread.coreThreadCount", 3);
        int maxThreadCount = EDCLaunch.getBackdoorValue("org.eclipse.cdt.edc.poolthread.maxThreadCount", coreThreadCount + 3);
        long idleLimit = EDCLaunch.getBackdoorValue("org.eclipse.cdt.edc.poolthread.idleLimit", 10);
        int queueLimit = EDCLaunch.getBackdoorValue("org.eclipse.cdt.edc.poolthread.queueLimit", 10000);
        return new ThreadPoolExecutor(coreThreadCount, maxThreadCount, idleLimit, TimeUnit.SECONDS, new ArrayBlockingQueue<Runnable>(queueLimit));
    }

    private static int getBackdoorValue(String prop, int defaultVal) {
        String value = System.getProperty(prop);
        if (value != null) {
            try {
                return Integer.parseInt(value);
            }
            catch (NumberFormatException numberFormatException) {}
        }
        return defaultVal;
    }

    public static EDCLaunch getLaunchForSession(String sessionID) {
        return launchSessions.get(sessionID);
    }

    public static ExecutorService getThreadPool(String sessionID) {
        return threadPools.get(sessionID);
    }

    public DsfExecutor getDsfExecutor() {
        return this.executor;
    }

    public IDsfDebugServicesFactory getServiceFactory() {
        return this.serviceFactory;
    }

    public void initialize() {
        DsfRunnable initRunnable = new DsfRunnable(){

            public void run() {
                EDCLaunch.this.tracker = new DsfServicesTracker(EDCDebugger.getDefault().getBundle().getBundleContext(), EDCLaunch.this.session.getId());
                EDCLaunch.this.session.addServiceEventListener((Object)EDCLaunch.this, null);
                EDCLaunch.this.memRetrieval = null;
                EDCLaunch.this.initialized = true;
                EDCLaunch.this.fireChanged();
            }
        };
        try {
            this.executor.submit((Runnable)initRunnable).get();
        }
        catch (Exception e) {
            EDCDebugger.getMessageLogger().log((IStatus)new Status(4, "org.eclipse.cdt.debug.edc", 10005, "Error initializing launch", (Throwable)e));
        }
    }

    public void initializeMemoryRetrieval() throws CoreException {
        try {
            this.executor.submit((Callable)new Callable<Object>(){

                @Override
                public Object call() throws CoreException {
                    EDCLaunch.this.memRetrieval = new DsfMemoryBlockRetrieval(EDCLaunch.this.getDebugModelID(), EDCLaunch.this.getLaunchConfiguration(), EDCLaunch.this.session);
                    EDCLaunch.this.session.registerModelAdapter(IMemoryBlockRetrieval.class, (Object)EDCLaunch.this.memRetrieval);
                    return null;
                }
            }).get();
        }
        catch (InterruptedException e) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.cdt.debug.edc", 0, "Interrupted while waiting for get process callable.", (Throwable)e));
        }
        catch (ExecutionException e) {
            throw (CoreException)e.getCause();
        }
        catch (RejectedExecutionException e) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.cdt.debug.edc", 0, "Debugger shut down before launch was completed.", (Throwable)e));
        }
    }

    public DsfSession getSession() {
        return this.session;
    }

    public DsfMemoryBlockRetrieval getMemoryBlockRetrieval() {
        return this.memRetrieval;
    }

    public void setServiceFactory(IDsfDebugServicesFactory factory) {
        this.serviceFactory = factory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @DsfServiceEventHandler
    public void eventDispatched(IRunControl.IExitedDMEvent e) {
        if (!(e instanceof RunControl.ExitedEvent)) {
            return;
        }
        EDCLaunch eDCLaunch = this;
        synchronized (eDCLaunch) {
            if (e.getDMContext() instanceof RunControl.RootExecutionDMC && !this.isLaunching()) {
                this.setTerminating(true);
                this.isTerminatedThanDisconnected = ((RunControl.ExitedEvent)e).isTerminatedThanDisconnected();
                this.shutdownSession(new RequestMonitor(ImmediateExecutor.getInstance(), null));
            }
        }
    }

    @DsfServiceEventHandler
    public void eventDispatched(ICommandControlService.ICommandControlShutdownDMEvent event) {
        this.shutdownSession(new RequestMonitor(ImmediateExecutor.getInstance(), null));
    }

    public boolean canTerminate() {
        return this.initialized && !this.shutDown;
    }

    public boolean isTerminated() {
        return this.shutDown;
    }

    public void terminate() throws DebugException {
        DsfExecutor dsfExecutor = this.getDsfExecutor();
        if (dsfExecutor != null) {
            this.setTerminating(true);
            this.getDsfExecutor().execute(new Runnable(){

                @Override
                public void run() {
                    RunControl runControlService = (RunControl)EDCLaunch.this.tracker.getService(RunControl.class);
                    if (runControlService != null) {
                        runControlService.terminateAllContexts(null);
                    }
                }
            });
        }
    }

    public boolean canDisconnect() {
        return (!this.snapshotSupportInitialized || !this.isSnapshotLaunch()) && this.canTerminate();
    }

    public boolean isDisconnected() {
        return this.isTerminated() && !this.isTerminatedThanDisconnected;
    }

    public void disconnect() throws DebugException {
        DsfExecutor dsfExecutor = this.getDsfExecutor();
        if (dsfExecutor != null) {
            this.getDsfExecutor().execute(new Runnable(){

                @Override
                public void run() {
                    Processes procService = (Processes)EDCLaunch.this.tracker.getService(Processes.class);
                    if (procService != null) {
                        procService.detachDebuggerFromSession(null);
                    }
                }
            });
        }
    }

    @ConfinedToDsfExecutor(value="getSession().getExecutor()")
    public void shutdownSession(final RequestMonitor rm) {
        if (this.shutDown || this.shuttingDown || this.executor == null) {
            rm.done();
            return;
        }
        this.shuttingDown = true;
        ExecutorService pool = threadPools.get(this.session.getId());
        if (pool != null) {
            pool.shutdown();
            try {
                pool.awaitTermination(15L, TimeUnit.SECONDS);
            }
            catch (InterruptedException exc) {
                EDCDebugger.getMessageLogger().logException(exc);
            }
        }
        ShutdownSequence shutdownSeq = new ShutdownSequence(this.getDsfExecutor(), this.session.getId(), new RequestMonitor((Executor)this.session.getExecutor(), rm){

            public void handleCompleted() {
                EDCLaunch.this.session.removeServiceEventListener((Object)EDCLaunch.this);
                if (!this.isSuccess()) {
                    EDCDebugger.getMessageLogger().log((IStatus)new MultiStatus("org.eclipse.cdt.debug.edc", -1, new IStatus[]{this.getStatus()}, "Session shutdown failed", null));
                }
                if (EDCLaunch.this.tracker != null) {
                    EDCLaunch.this.tracker.dispose();
                }
                EDCLaunch.this.tracker = null;
                DsfSession.endSession((DsfSession)EDCLaunch.this.session);
                if (EDCLaunch.this.memRetrieval != null) {
                    EDCLaunch.this.memRetrieval.saveMemoryBlocks();
                }
                EDCLaunch.this.executor.shutdown();
                EDCLaunch.this.executor = null;
                EDCLaunch.this.fireTerminate();
                try {
                    EDCLaunch.this.closeUnusedChannels();
                }
                catch (Throwable e) {
                    EDCDebugger.getMessageLogger().logError(null, e);
                }
                EDCLaunch.this.shutDown = true;
                rm.setStatus(this.getStatus());
                rm.done();
            }
        });
        this.executor.execute((Runnable)((Object)shutdownSeq));
        try {
            ILaunchConfiguration lc;
            ILaunchConfiguration activeLaunchConfig = this.getLaunchConfiguration();
            if (activeLaunchConfig.getAttribute("org.eclipse.cdt.debug.edc.isOneUse", false)) {
                activeLaunchConfig.delete();
            }
            if (this.isSnapshotLaunch() && (lc = SnapshotUtils.findExistingLaunchForAlbum(this.album)) != null) {
                lc.delete();
            }
        }
        catch (Throwable e) {
            EDCDebugger.getMessageLogger().logError(null, e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void closeUnusedChannels() {
        Map<EDCLaunch, List<IChannel>> map = launchChannels;
        synchronized (map) {
            List<IChannel> channelList = launchChannels.get((Object)this);
            launchChannels.remove((Object)this);
            if (channelList == null) {
                return;
            }
            Collection<List<IChannel>> remainingChannels = launchChannels.values();
            for (List<IChannel> list : remainingChannels) {
                channelList.removeAll(list);
            }
            for (final IChannel channel : channelList) {
                Protocol.invokeAndWait((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        channel.close();
                    }
                });
            }
        }
    }

    public Object getAdapter(Class adapter) {
        Platform.getAdapterManager().loadAdapter((Object)this, adapter.getName());
        return super.getAdapter(adapter);
    }

    public String getDebugModelID() {
        return this.debugModelID;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void usingTCFChannel(IChannel channel) {
        Map<EDCLaunch, List<IChannel>> map = launchChannels;
        synchronized (map) {
            List<IChannel> channelList = launchChannels.get((Object)this);
            if (channelList == null) {
                channelList = new ArrayList<IChannel>();
            }
            if (!channelList.contains(channel)) {
                channelList.add(channel);
            }
            launchChannels.put(this, channelList);
        }
    }

    public IAlbum getAlbum() {
        return this.album;
    }

    public void setAlbum(IAlbum album) {
        this.album = (Album)album;
    }

    public boolean isSnapshotLaunch() {
        if ("debug".equals(this.getLaunchMode())) assert (this.snapshotSupportInitialized);
        return this.album != null;
    }

    public ISourceLocator getExecutableLocator() {
        CSourceLookupDirector director = new CSourceLookupDirector();
        director.initializeParticipants();
        try {
            if (this.isSnapshotLaunch()) {
                this.getAlbum().configureSourceLookupDirector((ISourceLookupDirector)director);
            } else {
                String exePath = this.getLaunchConfiguration().getAttribute("org.eclipse.cdt.launch.PROGRAM_NAME", "");
                director.setSourceContainers(this.createExecutableLocatorSourceContainers(exePath));
            }
        }
        catch (CoreException e) {
            EDCDebugger.getMessageLogger().logError(null, e);
        }
        return director;
    }

    protected ISourceContainer[] createExecutableLocatorSourceContainers(String exePath) {
        ArrayList<Object> containers = new ArrayList<Object>();
        containers.add(new AbsolutePathSourceContainer());
        if (exePath.length() > 0) {
            IPath exeDirectory = new Path(exePath).removeLastSegments(1);
            containers.add(new DirectorySourceContainer(exeDirectory, false));
        }
        containers.add((Object)new ExecutablesSourceContainer());
        return containers.toArray(new ISourceContainer[containers.size()]);
    }

    public void initializeSnapshotSupport() {
        try {
            String albumFile = this.getLaunchConfiguration().getAttribute("org.eclipse.cdt.debug.edc.internal.launch.snapshotAlbum", "");
            IPath albumPath = PathUtils.createPath(albumFile);
            if (albumPath.toFile().exists()) {
                this.album = Album.getAlbumByLocation(albumPath);
                if (this.album == null) {
                    this.album = new Album();
                    this.album.setLocation(albumPath);
                    this.album.loadAlbum(false);
                }
                this.album.setSessionID(this.session.getId());
                IAlbum album = Album.getAlbumBySession(this.session.getId());
                DsfSourceLookupDirector director = (DsfSourceLookupDirector)this.getSourceLocator();
                album.configureSourceLookupDirector((ISourceLookupDirector)director);
            }
        }
        catch (Exception e) {
            EDCDebugger.getMessageLogger().logError(null, e);
        }
        this.snapshotSupportInitialized = true;
    }

    public ILaunchConfiguration[] getAffiliatedLaunchConfigurations() {
        return this.affiliatedLaunchConfigurations.toArray(new ILaunchConfiguration[this.affiliatedLaunchConfigurations.size()]);
    }

    public void addAffiliatedLaunchConfiguration(ILaunchConfiguration configuration) {
        this.affiliatedLaunchConfigurations.add(configuration);
    }

    public void setActiveLaunchConfiguration(ILaunchConfiguration activeLaunchConfiguration) {
        this.activeLaunchConfiguration = activeLaunchConfiguration;
    }

    public void setFirstLaunch(boolean isFirstLaunch) {
        this.isFirstLaunch = isFirstLaunch;
    }

    public boolean isFirstLaunch() {
        return this.isFirstLaunch;
    }

    public ISourceLocator createSourceLocator() throws CoreException {
        DsfSourceLookupDirector locator = new DsfSourceLookupDirector(this.session);
        String memento = this.getLaunchConfiguration().getAttribute(ILaunchConfiguration.ATTR_SOURCE_LOCATOR_MEMENTO, null);
        if (memento == null) {
            locator.initializeDefaults(this.getLaunchConfiguration());
        } else {
            locator.initializeFromMemento(memento, this.getLaunchConfiguration());
        }
        return locator;
    }

    public static EDCLaunch[] findLaunchesUsingPeer(final IPeer ipeer) {
        final ArrayList results = new ArrayList();
        ILaunchManager manager = DebugPlugin.getDefault().getLaunchManager();
        final List<ILaunch> launchList = Arrays.asList(manager.getLaunches());
        Protocol.invokeAndWait((Runnable)new Runnable(){

            @Override
            public void run() {
                block0: for (ILaunch iLaunch : launchList) {
                    if (!(iLaunch instanceof EDCLaunch)) continue;
                    EDCLaunch edcLaunch = (EDCLaunch)iLaunch;
                    List channels = (List)launchChannels.get((Object)edcLaunch);
                    if (channels == null) continue;
                    for (IChannel iChannel : channels) {
                        if (!iChannel.getRemotePeer().equals(ipeer)) continue;
                        results.add(edcLaunch);
                        continue block0;
                    }
                }
            }
        });
        return results.toArray(new EDCLaunch[results.size()]);
    }

    public ILaunchConfiguration getLaunchConfiguration() {
        if (this.activeLaunchConfiguration == null) {
            this.activeLaunchConfiguration = super.getLaunchConfiguration();
        }
        return this.activeLaunchConfiguration;
    }

    public String getCompilationPath(String filename) {
        Path path = Path.EMPTY;
        if (Path.EMPTY.isValidPath(filename)) {
            filename = PathUtils.convertPathToNative(filename);
            ISourceLocator sl = this.getSourceLocator();
            if (sl instanceof CSourceLookupDirector) {
                path = ((CSourceLookupDirector)sl).getCompilationPath(filename);
            }
            if (path == null) {
                path = PathUtils.findExistingPathIfCaseSensitive((IPath)new Path(filename));
            }
        }
        return path.toOSString();
    }

    public String getStartupStopAtPoint() {
        String ret = null;
        try {
            if (this.getLaunchConfiguration().getAttribute("org.eclipse.cdt.launch.DEBUGGER_STOP_AT_MAIN", false)) {
                ret = this.getLaunchConfiguration().getAttribute("org.eclipse.cdt.launch.DEBUGGER_STOP_AT_MAIN_SYMBOL", "main");
            }
        }
        catch (CoreException coreException) {}
        return ret;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getDescription() {
        if (this.description == null) {
            return this.getLaunchConfiguration().getName();
        }
        return this.description;
    }

    public void setLaunching(boolean isLaunching) {
        this.isLaunching = isLaunching;
    }

    public boolean isLaunching() {
        return this.isLaunching;
    }

    public void setTerminating(boolean isTerminating) {
        this.isTerminating = isTerminating;
    }

    public boolean isTerminating() {
        return this.isTerminating;
    }
}

