/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.common.sdb.command;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tizen.common.TizenPlatformConstants;
import org.tizen.common.rds.RdsDeployer;
import org.tizen.common.sdb.command.ApplicationCommand;
import org.tizen.common.sdb.command.FsCommand;
import org.tizen.common.sdb.command.ReInstallCommand;
import org.tizen.common.sdb.command.receiver.PkgCmdReceiver;
import org.tizen.common.ui.view.console.ITizenConsoleManager;
import org.tizen.sdblib.IDevice;
import org.tizen.sdblib.IShellOutputReceiver;
import org.tizen.sdblib.service.ApplicationCmdService;
import org.tizen.sdblib.service.SyncResult;

public class RdsCommand
extends ApplicationCommand {
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());

    public RdsCommand(IDevice device, ITizenConsoleManager console) {
        super(device, console);
    }

    public boolean rdsPush(String pkgId, String localPackagePath, String remotePackagePath) throws Exception {
        if (ApplicationCommand.isAppCmdSupported(this.getDevice())) {
            ApplicationCmdService appcmd = this.getApplicationCmdService();
            if (!appcmd.unzipPackage(localPackagePath, pkgId, (IShellOutputReceiver)this.receiver)) {
                return false;
            }
        } else {
            String strAppInstallPath = String.valueOf(TizenPlatformConstants.getAppTmpDirectory(this.device)) + "/" + pkgId;
            FsCommand command = new FsCommand(this.device, this.getConsole());
            command.removeFile(strAppInstallPath);
            SyncResult result = this.device.getSyncService().push(localPackagePath, this.device.getFileEntry(remotePackagePath).getParent());
            if (!result.isOk()) {
                return false;
            }
            command.unzip(remotePackagePath, strAppInstallPath);
            command.removeFile(remotePackagePath);
        }
        return true;
    }

    public boolean rdsInstall(String pkgId, String pkgType, String localPackagePath, String remotePackagePath) throws Exception {
        boolean isSuccess = false;
        if (ApplicationCommand.isAppCmdSupported(this.getDevice())) {
            ApplicationCmdService appcmd = this.device.getApplicationCmdService();
            try {
                isSuccess = appcmd.installPackageWithRDS(localPackagePath, pkgId, (IShellOutputReceiver)new PkgCmdReceiver(this.getConsole()));
            }
            catch (Exception e) {
                this.newCoreException(RdsDeployer.makeRdsLog("rds appcmd error"), e);
            }
        } else {
            String strAppInstallPath = String.valueOf(TizenPlatformConstants.getAppTmpDirectory(this.device)) + "/" + pkgId;
            this.rdsPush(pkgId, localPackagePath, remotePackagePath);
            ReInstallCommand command = new ReInstallCommand(this.getDevice(), pkgType, pkgId, 20000, this.getConsole());
            command.execute();
            FsCommand fsCommand = new FsCommand(this.device, this.getConsole());
            fsCommand.removeFile(strAppInstallPath);
            isSuccess = true;
        }
        return isSuccess;
    }
}

