/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.common.util;

import java.io.IOException;
import java.net.InetAddress;
import java.net.ServerSocket;
import org.tizen.common.util.IOUtil;

public class LocalPortChecker {
    protected static String LOCAL_ADDRESS_IP = "127.0.0.1";

    public static boolean isPortInRange(int port) {
        return port >= 0 && port < 65536;
    }

    public static boolean isPortAvailable(int port) {
        if (!LocalPortChecker.isPortInRange(port)) {
            return false;
        }
        ServerSocket socket = null;
        try {
            InetAddress localhost = InetAddress.getByName(LOCAL_ADDRESS_IP);
            socket = new ServerSocket(port, 50, localhost);
        }
        catch (IOException iOException) {
            try {}
            catch (Throwable throwable) {
                IOUtil.tryClose(socket);
                throw throwable;
            }
            IOUtil.tryClose(socket);
            return false;
        }
        IOUtil.tryClose(socket);
        return true;
    }

    public static int getAvailableLocalPort(int inc, int portBase) {
        int port = portBase;
        while (LocalPortChecker.isPortInRange(port)) {
            if (LocalPortChecker.isPortAvailable(port)) {
                return port;
            }
            port += inc;
        }
        return -1;
    }
}

