/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.dynamicanalyzer.ui.widgets.table;

import org.eclipse.nebula.widgets.grid.GridColumn;
import org.eclipse.nebula.widgets.grid.internal.CheckBoxRenderer;
import org.eclipse.nebula.widgets.grid.internal.DefaultColumnHeaderRenderer;
import org.eclipse.nebula.widgets.grid.internal.TextUtils;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Display;
import org.tizen.dynamicanalyzer.resources.ColorResources;
import org.tizen.dynamicanalyzer.resources.FontResources;
import org.tizen.dynamicanalyzer.resources.ImageResources;

public class DATableHeaderRenderer
extends DefaultColumnHeaderRenderer {
    int leftMargin = 6;
    int rightMargin = 6;
    int insideMargin = 3;
    int imageRightMargin = 9;
    int alignment;
    boolean check = false;
    boolean checked = false;
    Color bgColor = ColorResources.TABLE_HEADER_BG;
    Color fontColor = ColorResources.TABLE_HEADER_FONT_COLOR;
    protected CheckBoxRenderer checkRenderer = null;

    public DATableHeaderRenderer() {
        this.alignment = 16384;
    }

    public DATableHeaderRenderer(int style) {
        this.alignment = (style & 0x4000) == 16384 ? 16384 : ((style & 0x20000) == 131072 ? 131072 : 0x1000000);
        if ((style & 0x20) == 32) {
            this.check = true;
            this.checkRenderer = new CheckBoxRenderer();
        }
    }

    public void setDisplay(Display display) {
        super.setDisplay(display);
        if (this.checkRenderer != null) {
            this.checkRenderer.setDisplay(display);
        }
    }

    public void setBgColor(Color bgColor) {
        this.bgColor = bgColor;
    }

    public void setFontColor(Color fontColor) {
        this.fontColor = fontColor;
    }

    public void paint(GC gc, Object value) {
        this.paint(gc, (GridColumn)value);
    }

    public void setSelected() {
        if (this.check) {
            this.checked = !this.checked;
        }
    }

    public boolean getChecked() {
        return this.checked;
    }

    public void paint(GC gc, GridColumn column) {
        boolean flat = column.getParent().getCellSelectionEnabled() && !column.getMoveable();
        boolean drawSelected = this.isMouseDown() && this.isHover();
        gc.setBackground(this.bgColor);
        if (flat && this.isSelected()) {
            gc.setBackground(column.getParent().getCellHeaderSelectionBackground());
        }
        Rectangle r = this.getBounds();
        gc.fillRectangle(r.x, r.y, r.width, r.height);
        gc.setForeground(ColorResources.TABLE_LINE);
        gc.drawLine(r.x - 1, r.y, r.x - 1, r.y + r.height);
        gc.drawLine(r.x - 1, r.y + r.height, r.x + r.width, r.y + r.height);
        int pushedDrawingOffset = 0;
        if (drawSelected) {
            pushedDrawingOffset = 1;
        }
        int x = this.leftMargin;
        if (this.check) {
            this.checkRenderer.setChecked(this.checked);
            this.checkRenderer.setHover(this.getHoverDetail().equals("check"));
            this.checkRenderer.setBounds(this.getBounds().x + x, (this.getBounds().height - this.checkRenderer.getBounds().height) / 2 + this.getBounds().y, this.checkRenderer.getBounds().width, this.checkRenderer.getBounds().height);
            this.checkRenderer.paint(gc, null);
            x += this.checkRenderer.getBounds().width + this.insideMargin;
        }
        int width = this.getBounds().width - x;
        if (column.getImage() != null || column.getSort() != 0) {
            column.setImage(this.refineImage(column));
            gc.drawImage(column.getImage(), this.getBounds().x + this.getBounds().width - this.imageRightMargin - column.getImage().getBounds().width + pushedDrawingOffset, this.getBounds().y + (this.getBounds().height - column.getImage().getBounds().height) / 2 + pushedDrawingOffset);
            width -= column.getImage().getBounds().width + this.insideMargin + this.imageRightMargin;
        } else {
            width -= this.rightMargin;
        }
        gc.setForeground(this.fontColor);
        gc.setFont(FontResources.TABLE_HEADER_FONT);
        String inputText = TextUtils.getShortString((GC)gc, (String)column.getText(), (int)width);
        Point textSize = gc.textExtent(inputText, 8);
        int textX = this.alignment == 0x1000000 ? r.x + x + (width - textSize.x) / 2 : (this.alignment == 16384 ? r.x + x : r.x + x + width - textSize.x);
        int y = this.getBounds().y + (this.getBounds().height - textSize.y) / 2;
        gc.drawString(inputText, textX + pushedDrawingOffset, y + pushedDrawingOffset, true);
    }

    private Image refineImage(GridColumn column) {
        if (column.getSort() == 0 && ImageResources.FILTER_IMAGES.contains(column.getImage())) {
            if (this.isHover()) {
                if (this.isMouseDown()) {
                    return ImageResources.DA_IC_FILTER_PRESSED;
                }
                return ImageResources.DA_IC_FILTER_OVER;
            }
            return ImageResources.DA_IC_FILTER;
        }
        if (column.getSort() == 128) {
            if (this.isHover()) {
                if (this.isMouseDown()) {
                    return ImageResources.SORTED_INC_SELECTED;
                }
                return ImageResources.SORTED_INC_OVER;
            }
            return ImageResources.SORTED_INC;
        }
        if (column.getSort() == 1024) {
            if (this.isHover()) {
                if (this.isMouseDown()) {
                    return ImageResources.SORTED_DESC_SELECTED;
                }
                return ImageResources.SORTED_DESC_OVER;
            }
            return ImageResources.SORTED_DESC;
        }
        return column.getImage();
    }
}

