/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.common.util.log;

import java.text.MessageFormat;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.core.Layout;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.appender.AbstractAppender;
import org.apache.logging.log4j.core.config.plugins.Plugin;
import org.apache.logging.log4j.core.config.plugins.PluginAttribute;
import org.apache.logging.log4j.core.config.plugins.PluginFactory;
import org.apache.logging.log4j.core.layout.PatternLayout;
import org.apache.logging.log4j.message.Message;
import org.apache.logging.log4j.status.StatusLogger;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.tizen.common.CommonPlugin;
import org.tizen.common.ui.view.console.ConsoleManager;

@Plugin(name="EclipseAppender", category="Core", printObject=true)
public class EclipseAppender
extends AbstractAppender {
    protected EclipseAppender(String name, Layout<String> layout) {
        super(name, null, layout, false);
    }

    @PluginFactory
    public static EclipseAppender createAppender(@PluginAttribute(value="name") String name, @PluginAttribute(value="pattern") String pattern) {
        PatternLayout layout = PatternLayout.newBuilder().withPattern(pattern != null ? pattern : "[%d{yyyy.MM.dd HH:mm:ss}][%-5p] %F(%L) - %m%n").build();
        return new EclipseAppender(name, (Layout<String>)layout);
    }

    public void append(LogEvent event) {
        try {
            Level level = event.getLevel();
            Throwable throwable = event.getThrown();
            String message = ((Message)this.getLayout().toSerializable(event)).getFormattedMessage();
            String caller = event.getSource().getClassName();
            Status status = null;
            if (level.isMoreSpecificThan(Level.ERROR)) {
                status = new Status(4, caller, message, throwable);
            } else if (level.isMoreSpecificThan(Level.WARN)) {
                status = new Status(2, caller, message, throwable);
            } else if (level.isMoreSpecificThan(Level.INFO)) {
                status = new Status(1, caller, message, throwable);
            }
            if (status != null) {
                EclipseAppender.log((IStatus)status);
            }
        }
        catch (Throwable t) {
            StatusLogger.getLogger().error(MessageFormat.format("Exception occurred while logging message: {0}", event.getMessage().getFormattedMessage()), t);
        }
    }

    private static void log(IStatus status) {
        CommonPlugin plugin = CommonPlugin.getDefault();
        if (plugin != null) {
            plugin.getLog().log(status);
        } else {
            ConsoleManager conManager = new ConsoleManager("Error Log", false);
            conManager.println(String.valueOf(status.getPlugin()) + " : " + status.getMessage());
        }
    }
}

