/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.sdb.command;

import java.io.IOException;
import org.tizen.sdb.command.receiver.LineReceiver;
import org.tizen.sdb.item.PackageItem;

class PackageInfoReceiver
extends LineReceiver {
    private PackageItem packageInfo = null;
    private String packageID;
    private String mainAppID;
    private String type;
    private boolean isRemovable;
    private boolean isRunning;
    protected static final String APPCMD_EXITCODE_PREFIX = "appcmd_exitcode:";
    protected static final String APPCMD_RETURNSTR_PREFIX = "appcmd_returnstr:";

    public PackageInfoReceiver(String packageID) {
        this.packageID = packageID;
    }

    @Override
    public void processNewLines(String[] lines) {
        String[] stringArray = lines;
        int n = lines.length;
        int n2 = 0;
        while (n2 < n) {
            String line = stringArray[n2];
            if (!line.contains(APPCMD_EXITCODE_PREFIX)) {
                String data;
                if (line.contains(APPCMD_RETURNSTR_PREFIX)) {
                    data = line.substring(APPCMD_RETURNSTR_PREFIX.length());
                    String[] words = data.split(":");
                    if (words.length == 4) {
                        this.mainAppID = words[0].trim();
                        this.type = words[1].trim();
                        this.isRemovable = Integer.parseInt(words[2]) == 1;
                        this.isRunning = Integer.parseInt(words[3]) == 1;
                    } else {
                        int cfr_ignored_0 = words.length;
                    }
                } else if (line.contains("mainappid :")) {
                    this.mainAppID = line.substring(11).trim();
                } else if (line.contains("Type:")) {
                    this.type = line.substring(5).trim();
                } else if (line.contains("Removable:")) {
                    data = line.substring(10).trim();
                    this.isRemovable = Integer.parseInt(data) == 1;
                } else if (line.contains("is Running")) {
                    this.isRunning = true;
                } else if (line.contains("is Not Running")) {
                    this.isRunning = false;
                }
            }
            ++n2;
        }
    }

    @Override
    public void close() throws IOException {
        super.close();
        if (this.mainAppID != null && !this.mainAppID.isEmpty()) {
            this.packageInfo = new PackageItem(this.packageID, this.mainAppID, this.type, this.isRemovable, this.isRunning);
        }
    }

    PackageItem getPackageItem() {
        return this.packageInfo;
    }
}

