/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.dynamicanalyzer.ui.opengl.data.type;

import java.util.ArrayList;
import java.util.List;
import org.tizen.dynamicanalyzer.common.Global;
import org.tizen.dynamicanalyzer.project.BinaryInfo;
import org.tizen.dynamicanalyzer.swap.model.data.GLES20LogData;

public class GLAPIData
extends GLES20LogData {
    private int frameIndex = 0;
    private int binaryId = 0;

    public GLAPIData() {
    }

    public GLAPIData(GLES20LogData logData, int currentFrameIndex) {
        this.setSeq(logData.getSeq());
        this.setContextID(logData.getCurrentContextID());
        this.setFrameIndex(currentFrameIndex);
        this.setTime(logData.getTime());
        this.setApiId(logData.getApiId());
        this.setArgs(logData.getArgs());
        this.setReturn(logData.getReturn());
        this.setElapsedTime(logData.getElapsedTime());
        this.setErrNo(logData.getErrno());
        this.setPid(logData.getPid());
        this.setTid(logData.getTid());
        this.setCallerAddress(logData.getCallerPcAddr());
        this.setBinaryID(logData.getLibName());
    }

    @Override
    public String getLibName() {
        BinaryInfo binInfo = Global.getProject().getDeviceStatusInfo().getBinaryInfo(this.getBinaryId());
        this.libName = binInfo.getTargetBinaryPath();
        return this.libName;
    }

    public void setContextID(long id) {
        this.glCurrentContextName = id;
    }

    public long getContextID() {
        return this.glCurrentContextName;
    }

    public int getFrameIndex() {
        return this.frameIndex;
    }

    public void setFrameIndex(int frameIndex) {
        this.frameIndex = frameIndex;
    }

    public List<Object> getDBInsertData() {
        ArrayList<Object> data = new ArrayList<Object>();
        data.add(this.getSeq());
        data.add(this.getContextID());
        data.add(this.getFrameIndex());
        data.add(this.getTime());
        data.add(this.getApiId());
        data.add(this.getArgs());
        data.add(this.getReturn());
        data.add(this.getElapsedTime());
        data.add(this.getErrno());
        data.add(this.getPid());
        data.add(this.getTid());
        data.add(this.getCallerPcAddr());
        data.add(this.getBinaryId());
        return data;
    }

    public int getBinaryId() {
        return this.binaryId;
    }

    public void setBinaryId(int binaryId) {
        this.binaryId = binaryId;
    }

    public void setBinaryID(String binaryPath) {
        BinaryInfo binInfo = Global.getProject().getDeviceStatusInfo().getBinaryInfo(binaryPath);
        this.binaryId = binInfo.getID();
    }
}

