/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.dynamicanalyzer.swap.model.data;

import org.tizen.dynamicanalyzer.model.DATime;
import org.tizen.dynamicanalyzer.swap.model.data.LogData;

public class LSanData
extends LogData {
    private LSanStatus status;
    private int pid;
    private String data;

    @Override
    public LSanData clone() throws CloneNotSupportedException {
        throw new CloneNotSupportedException();
    }

    @Override
    protected boolean parse(DATime startTime) {
        super.parse(startTime);
        int statusVal = this.getInt();
        this.status = LSanStatus.parse(statusVal);
        if (this.status != null) {
            this.pid = this.getInt();
            this.data = this.parseArgs();
        } else {
            this.status = LSanStatus.ERROR;
            this.data = String.format("Not recognized LeakSanitizer status: %d(0b%s)", statusVal, Integer.toBinaryString(statusVal));
        }
        return true;
    }

    public LSanStatus getStatus() {
        return this.status;
    }

    @Override
    public int getPid() {
        return this.pid;
    }

    public String getData() {
        return this.data;
    }

    public static enum LSanStatus {
        ERROR(0),
        REPORT(2),
        INITIALIZED(5);

        private final int status;

        private LSanStatus(int status) {
            this.status = status;
        }

        public int getStatus() {
            return this.status;
        }

        public static LSanStatus parse(int status) {
            LSanStatus[] lSanStatusArray = LSanStatus.values();
            int n = lSanStatusArray.length;
            int n2 = 0;
            while (n2 < n) {
                LSanStatus value = lSanStatusArray[n2];
                if (status == value.getStatus()) {
                    return value;
                }
                ++n2;
            }
            return null;
        }
    }
}

