/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.dynamicanalyzer.ui.opengl.data;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.tizen.dynamicanalyzer.swap.model.data.GLES20LogData;
import org.tizen.dynamicanalyzer.ui.opengl.data.GLContextDataManager;
import org.tizen.dynamicanalyzer.ui.opengl.data.GLDataManager;
import org.tizen.dynamicanalyzer.ui.opengl.data.GLStateDataManager;
import org.tizen.dynamicanalyzer.ui.opengl.data.type.GLContextNameEnum;
import org.tizen.dynamicanalyzer.ui.opengl.data.type.GLSharingContextType;
import org.tizen.dynamicanalyzer.util.Logger;
import org.tizen.dynamicanalyzer.utils.AnalyzerUtil;

public class GLContextSharingDataMaker {
    private GLStateDataManager glStateDataManager = null;
    List<GLSharingContextType> savedSharingInfoList = new ArrayList<GLSharingContextType>();

    public GLContextSharingDataMaker(GLStateDataManager glStateDataManager) {
        this.glStateDataManager = glStateDataManager;
    }

    private GLStateDataManager getStateDataManager() {
        return this.glStateDataManager;
    }

    public void extractSharingContextAPIParameter(GLES20LogData logData) {
        String apiName = logData.getApiName();
        if (!apiName.equals("_SglCreateContext") && !apiName.equals("evas_gl_context_create")) {
            return;
        }
        if (this.glStateDataManager.isNormalAPIStatusForExtractParameter(logData)) {
            this.eglAPILogManager(logData);
        }
    }

    private void eglAPILogManager(GLES20LogData logData) {
        String apiName = logData.getApiName();
        if (apiName.equals("_SglCreateContext")) {
            this.insertContextOfEGL(logData);
        } else if (apiName.equals("evas_gl_context_create")) {
            this.insertContextOfEvasGL(logData);
        } else {
            Logger.error((Object)("GL extract sharing context API parameter  : " + apiName));
        }
    }

    private void insertContextOfEGL(GLES20LogData logData) {
        String apiName = logData.getApiName();
        String parameter = logData.getArgs();
        String[] parameters = parameter.split(", ");
        String returnValue = logData.getReturn();
        if (parameters.length != 4) {
            Logger.error((Object)("GL extract API parameter  : " + apiName));
            return;
        }
        long currentContextId = AnalyzerUtil.addrToLong(parameters[2]);
        long sharingContextId = AnalyzerUtil.addrToLong(returnValue);
        if (!this.isExistSharingContextID(currentContextId)) {
            return;
        }
        this.updateSharingDataAtCurrentContextDataManager(currentContextId, sharingContextId);
        this.insertSharingData();
    }

    private void insertContextOfEvasGL(GLES20LogData logData) {
        String apiName = logData.getApiName();
        String parameter = logData.getArgs();
        String[] parameters = parameter.split(", ");
        String returnValue = logData.getReturn();
        if (parameters.length != 2) {
            Logger.error((Object)("GL extract API parameter  : " + apiName));
            return;
        }
        long currentContextId = AnalyzerUtil.addrToLong(returnValue);
        long sharingContextId = AnalyzerUtil.addrToLong(parameters[1]);
        if (!this.isExistSharingContextID(currentContextId)) {
            return;
        }
        this.updateSharingDataAtCurrentContextDataManager(currentContextId, sharingContextId);
        this.insertSharingData();
    }

    private boolean isExistSharingContextID(long currentContextId) {
        return currentContextId != 0L;
    }

    private void updateSharingDataAtCurrentContextDataManager(long currentContextId, long sharingContextId) {
        this.getStateDataManager().updateStateAtCurrentContext(GLContextNameEnum.CONTEXT_ID.ordinal(), sharingContextId);
        GLContextDataManager curretnContextValue = this.getStateDataManager().getGLContextDataManager(sharingContextId);
        if (curretnContextValue == null) {
            Logger.error((Object)("GL context hash map not set data : " + sharingContextId));
            return;
        }
        curretnContextValue.addSharingContextID(this.getStateDataManager().getStateHashMap(), currentContextId);
    }

    private void insertSharingData() {
        ArrayList<GLSharingContextType> insertSharingInfoList = new ArrayList<GLSharingContextType>();
        Set<Map.Entry<Long, GLContextDataManager>> set = this.getStateDataManager().getStateHashMap().entrySet();
        for (Map.Entry<Long, GLContextDataManager> e : set) {
            insertSharingInfoList.addAll(this.getInsertSharingInfoList(e.getValue()));
        }
        this.insertSharingDataToDB(insertSharingInfoList);
    }

    public void insertSharingDataToDB(List<GLSharingContextType> sharingInfoList) {
        ArrayList<List<Object>> insertList = new ArrayList<List<Object>>();
        int i = 0;
        while (i < sharingInfoList.size()) {
            GLSharingContextType insertSharingType = sharingInfoList.get(i);
            if (!this.isSavedSharingData(insertSharingType)) {
                ArrayList<Long> objectList = new ArrayList<Long>();
                objectList.add(insertSharingType.getContextId());
                objectList.add(insertSharingType.getSharingContextId());
                insertList.add(objectList);
                this.savedSharingInfoList.add(insertSharingType);
            }
            ++i;
        }
        GLDataManager.getInstance().getStateSharingDBTableManage().insertData(insertList);
        GLDataManager.getInstance().updateSharingContextList();
    }

    private boolean isSavedSharingData(GLSharingContextType insertSharingType) {
        int j = 0;
        while (j < this.savedSharingInfoList.size()) {
            GLSharingContextType savedSharingType = this.savedSharingInfoList.get(j);
            if (savedSharingType.getContextId() == insertSharingType.getContextId() && savedSharingType.getSharingContextId() == insertSharingType.getSharingContextId()) {
                return true;
            }
            ++j;
        }
        return false;
    }

    private List<GLSharingContextType> getInsertSharingInfoList(GLContextDataManager contextValue) {
        ArrayList<GLSharingContextType> returnSharingInfoList = new ArrayList<GLSharingContextType>();
        int i = 0;
        while (i < contextValue.sharingContextIdList.size()) {
            returnSharingInfoList.add(new GLSharingContextType(contextValue.contextID, contextValue.sharingContextIdList.get(i)));
            ++i;
        }
        return returnSharingInfoList;
    }
}

