/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.dynamicanalyzer.ui.timeline.dlog;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.tizen.dynamicanalyzer.database.DBColumn;
import org.tizen.dynamicanalyzer.database.DBTable;
import org.tizen.dynamicanalyzer.util.Logger;

public class DLogDBTable
extends DBTable {
    public static final String TABLENAME = "DLOG_DB";

    @Override
    public String getTableName() {
        return TABLENAME;
    }

    public DLogDBTable() {
        this.addColumn(new DBColumn(COLUMN.TIME.name, "NOT NULL", "VARCHAR", 20));
        this.addColumn(new DBColumn(COLUMN.LEVEL.name, "NOT NULL", "VARCHAR", 10));
        this.addColumn(new DBColumn(COLUMN.PID.name, "NOT NULL", "VARCHAR", 10));
        this.addColumn(new DBColumn(COLUMN.TID.name, "NOT NULL", "VARCHAR", 10));
        this.addColumn(new DBColumn(COLUMN.TAG.name, "NOT NULL", "VARCHAR", 64));
        this.addColumn(new DBColumn(COLUMN.MESSAGE.name, "NOT NULL", "VARCHAR", 4096));
    }

    @Override
    public boolean prepare(PreparedStatement prep, List<Object> rowData) {
        boolean isPrepared = true;
        int columnsize = this.getColumnSize();
        if (columnsize != rowData.size()) {
            isPrepared = false;
        } else {
            try {
                int index = 1;
                prep.setString(index++, (String)rowData.get(COLUMN.TIME.index));
                prep.setString(index++, (String)rowData.get(COLUMN.LEVEL.index));
                prep.setString(index++, (String)rowData.get(COLUMN.PID.index));
                prep.setString(index++, (String)rowData.get(COLUMN.TID.index));
                prep.setString(index++, (String)rowData.get(COLUMN.TAG.index));
                prep.setString(index++, (String)rowData.get(COLUMN.MESSAGE.index));
            }
            catch (SQLException e) {
                Logger.exception((Throwable)e);
                isPrepared = false;
            }
        }
        return isPrepared;
    }

    @Override
    public List<Object> extractDataFromResultSet(ResultSet rs) {
        ArrayList<Object> row = new ArrayList<Object>();
        try {
            int index = 1;
            row.add(rs.getString(index++));
            row.add(rs.getString(index++));
            row.add(rs.getString(index++));
            row.add(rs.getString(index++));
            row.add(rs.getString(index++));
            row.add(rs.getString(index++));
        }
        catch (SQLException e) {
            Logger.exception((Throwable)e);
            return null;
        }
        return row;
    }

    public static enum COLUMN {
        TIME(0, "TIME"),
        LEVEL(1, "LEVEL"),
        PID(2, "PID"),
        TID(3, "TID"),
        TAG(4, "TAG"),
        MESSAGE(5, "MESSAGE");

        public final int index;
        public final String name;

        private COLUMN(int index, String name) {
            this.index = index;
            this.name = name;
        }
    }
}

