/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.dynamicanalyzer.ui.toolbar;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.tizen.dynamicanalyzer.annotation.UIMethod;
import org.tizen.dynamicanalyzer.common.DAResult;
import org.tizen.dynamicanalyzer.common.DAState;
import org.tizen.dynamicanalyzer.common.Global;
import org.tizen.dynamicanalyzer.communicator.DACommunicator;
import org.tizen.dynamicanalyzer.communicator.DeviceInfo;
import org.tizen.dynamicanalyzer.communicator.DeviceManager;
import org.tizen.dynamicanalyzer.control.ApplistManager;
import org.tizen.dynamicanalyzer.handlers.CommandAction;
import org.tizen.dynamicanalyzer.handlers.CommonAction;
import org.tizen.dynamicanalyzer.handlers.UIActionHolder;
import org.tizen.dynamicanalyzer.nl.AnalyzerLabels;
import org.tizen.dynamicanalyzer.nl.UserErrorWarningLabels;
import org.tizen.dynamicanalyzer.project.AppInfo;
import org.tizen.dynamicanalyzer.project.PackageInfo;
import org.tizen.dynamicanalyzer.project.ProcessInformation;
import org.tizen.dynamicanalyzer.project.ProcessMemoryMap;
import org.tizen.dynamicanalyzer.project.Project;
import org.tizen.dynamicanalyzer.resources.ColorResources;
import org.tizen.dynamicanalyzer.resources.FontResources;
import org.tizen.dynamicanalyzer.resources.ImageResources;
import org.tizen.dynamicanalyzer.setting.SettingDataManager;
import org.tizen.dynamicanalyzer.shortcut.ShortCutManager;
import org.tizen.dynamicanalyzer.ui.common.explorer.DeviceExplorerDialog;
import org.tizen.dynamicanalyzer.ui.page.BaseView;
import org.tizen.dynamicanalyzer.ui.timeline.TimelinePage;
import org.tizen.dynamicanalyzer.ui.toolbar.AboutDialog;
import org.tizen.dynamicanalyzer.ui.toolbar.DAToolBarCustomCombo;
import org.tizen.dynamicanalyzer.ui.toolbar.ProcessExplorerDialog;
import org.tizen.dynamicanalyzer.ui.toolbar.RemoteDeviceDialog;
import org.tizen.dynamicanalyzer.ui.toolbar.ToolBarComboListener;
import org.tizen.dynamicanalyzer.ui.toolbar.opentrace.OpenTraceDialog;
import org.tizen.dynamicanalyzer.ui.toolbar.setting.FlatFeatureDialog;
import org.tizen.dynamicanalyzer.ui.toolbar.setting.FlatFeatureDialogTargetPage;
import org.tizen.dynamicanalyzer.ui.toolbar.setting.PreferencesDialog;
import org.tizen.dynamicanalyzer.ui.widgets.SearchDialog;
import org.tizen.dynamicanalyzer.util.Logger;
import org.tizen.dynamicanalyzer.util.WorkbenchUtil;
import org.tizen.dynamicanalyzer.utils.AnalyzerUtil;
import org.tizen.dynamicanalyzer.widgets.button.DACustomButton;
import org.tizen.dynamicanalyzer.widgets.button.DACustomButtonClickEventListener;
import org.tizen.dynamicanalyzer.widgets.button.DACustomButtonRenderer;
import org.tizen.dynamicanalyzer.widgets.button.IDACustomButtonRenderer;
import org.tizen.dynamicanalyzer.widgets.button.toggle.DACustomToggleButton;
import org.tizen.dynamicanalyzer.widgets.chart.DAChartRenderer;
import org.tizen.dynamicanalyzer.widgets.chart.DANotificationOnChartRenderer;
import org.tizen.dynamicanalyzer.widgets.chartBoard.DAChartBoardItem;
import org.tizen.dynamicanalyzer.widgets.combo.DACustomCombo;
import org.tizen.dynamicanalyzer.widgets.combo.DACustomComboSelectionListener;
import org.tizen.dynamicanalyzer.widgets.da.base.ProgressManager;
import org.tizen.dynamicanalyzer.widgets.progress.CircleProgress;
import org.tizen.dynamicanalyzer.widgets.progress.ProgressHolder;
import org.tizen.dynamicanalyzer.widgets.timeline.MarkerManager;
import org.tizen.dynamicanalyzer.widgets.timer.IAlarm;
import org.tizen.dynamicanalyzer.widgets.timer.TimerClock;
import org.tizen.sdblib.service.FileEntry;

public enum Toolbar {
    INSTANCE;

    public static final int START_BUTTON = 0;
    public static final int SAVE_BUTTON = 1;
    public static final int OPEN_BUTTON = 2;
    public static final int SOURCE_BUTTON = 4;
    public static final int ABOUT_BUTTON = 5;
    public static final int CONFIG_BUTTON = 6;
    public static final int SETTING_BUTTON = 7;
    public static final int SCREENSHOT_BUTTON = 8;
    public static final int SEARCH_BUTTON = 10;
    public static final String ALL_PROCESS = "All Processes";
    public static final String PROCESS_SPLITER = " : ";
    private DAToolBarCustomCombo deviceCombo;
    private DAToolBarCustomCombo appCombo;
    private DACustomCombo processCombo;
    private DACustomButton startButton;
    private TimerClock timerClock;
    private CircleProgress circleProgress;
    private DACustomButton openTraceButton;
    private DACustomButton configButton;
    private DACustomButton screenshotButton;
    private DACustomButton aboutButton;
    private DACustomButton searchButton;
    private DACustomToggleButton viewSourceButton;
    private List<AppInfo> oldAppList = null;
    private List<AppInfo> newAppList = null;
    private Map<Integer, DACustomButton> buttons = new HashMap<Integer, DACustomButton>();
    private ProgressHolder progress = null;
    private static FlatFeatureDialog flatFeatureDialog;
    private static final int TIMER_WIDTH = 118;
    private static final int DEVICE_COMBO = 0;
    private static final int APP_COMBO = 1;
    private long chartDragStart = -1L;
    private long chartDragEnd = -1L;
    private boolean dlogTimeSelection = true;
    private int scaleSelection = 2;
    CompletableFuture<List<AppInfo>> applicationListTask = null;

    public DACustomButton getStartButton() {
        return this.startButton;
    }

    public int getScaleSelection() {
        return this.scaleSelection;
    }

    public void setScaleSelection(int scale) {
        this.scaleSelection = scale;
    }

    public void create(Composite parent) {
        parent.setBackground(ColorResources.GRAY_220);
        this.createToolbar(parent);
        parent.layout(true);
    }

    public DACustomCombo getProcessCombo() {
        return this.processCombo;
    }

    public DAToolBarCustomCombo getDeviceCombo() {
        return this.deviceCombo;
    }

    public DAToolBarCustomCombo getAppCombo() {
        return this.appCombo;
    }

    private void addToolbarListeners() {
        this.deviceCombo.addSelectionListener(new ToolBarComboListener(){

            @Override
            public void selectionEvent(DAToolBarCustomCombo combo) {
                String newDeviceName = combo.getText();
                Toolbar.this.selectDevice(newDeviceName);
            }
        });
        this.appCombo.addSelectionListener(new ToolBarComboListener(){

            @Override
            public void selectionEvent(DAToolBarCustomCombo combo) {
                String appID = combo.getID();
                if (appID == null || appID.isEmpty()) {
                    Global.setCurrentApplication(null);
                    return;
                }
                DeviceInfo curDev = Global.getCurrentDeviceInfo();
                if (curDev != null) {
                    AppInfo selectedApp = curDev.getAppInfoByAppID(appID);
                    if (selectedApp != null) {
                        if (appID.equals("da.id.dummy.app.running")) {
                            if (curDev.isRootAvailable()) {
                                Shell shell = WorkbenchUtil.getWorkbenchWindow().getShell();
                                ProcessExplorerDialog pdialog = new ProcessExplorerDialog(shell);
                                pdialog.setProcessList(selectedApp.getRunningProcesses());
                                Object result = pdialog.open();
                                if (result != null) {
                                    Map processes = (Map)result;
                                    selectedApp.setRunningProcesses(processes);
                                    selectedApp.setPossibleToTrace(true);
                                }
                            } else {
                                UIActionHolder.getUIAction().showWarning(UserErrorWarningLabels.ERROR_APP_SELECT_BY_SECURITY);
                                selectedApp.setPossibleToTrace(false);
                            }
                        } else if (appID.equals("da.id.dummy.app.executable")) {
                            if (curDev.isRootAvailable()) {
                                List files;
                                Shell shell = WorkbenchUtil.getWorkbenchWindow().getShell();
                                DeviceExplorerDialog dialog = new DeviceExplorerDialog(shell, false);
                                dialog.setPermissionFilter("111");
                                Object result = dialog.open();
                                if (result != null && (files = (List)result).size() > 0) {
                                    String execpath = ((FileEntry)files.get(0)).getFullPath();
                                    selectedApp.setInfo(AppInfo.PROPERTY.EXEC.index, execpath);
                                    selectedApp.setPossibleToTrace(true);
                                }
                            } else {
                                UIActionHolder.getUIAction().showWarning(UserErrorWarningLabels.ERROR_APP_SELECT_BY_SECURITY);
                                selectedApp.setPossibleToTrace(false);
                            }
                        } else if (appID.equals("da.id.dummy.app.systemwide") && !curDev.isRootAvailable()) {
                            UIActionHolder.getUIAction().showWarning(UserErrorWarningLabels.ERROR_APP_SELECT_BY_SECURITY);
                            selectedApp.setPossibleToTrace(false);
                        }
                        Global.setCurrentApplication(selectedApp);
                        Toolbar.this.onAppSelected(selectedApp);
                    } else {
                        Toolbar.this.updateAppCombo(false);
                    }
                } else {
                    Toolbar.this.updateAppCombo(false);
                }
                Toolbar.this.setStartButtonState(true);
            }
        });
        this.appCombo.addListener(3, new Listener(){

            public void handleEvent(Event event) {
                if (!Toolbar.this.appCombo.isChildShellOpened()) {
                    Toolbar.this.updateAppCombo(false);
                }
            }
        });
        this.processCombo.addSelectionListener(new DACustomComboSelectionListener(){

            public void selectionEvent(DACustomCombo combo) {
                BaseView baseView = (BaseView)WorkbenchUtil.getViewPart((String)BaseView.ID);
                baseView.getTopComposite().updateView();
            }
        });
        this.processCombo.addListener(3, new Listener(){

            public void handleEvent(Event event) {
                Project project = Global.getProject();
                if (project == null) {
                    return;
                }
                Toolbar.this.processCombo.initCombo();
                Toolbar.this.processCombo.add(Toolbar.ALL_PROCESS);
                int[] pids = project.getProcessIDs();
                int pcount = pids.length;
                int i = 0;
                while (i < pcount) {
                    ProcessMemoryMap map;
                    ProcessInformation process = project.getProcessInformation(pids[i]);
                    String binName = process.getProcessName();
                    if ((binName == null || binName.isEmpty()) && (map = process.getLastProcessMemoryMap()) != null) {
                        int bid = map.getMainbinary().getBinaryID();
                        String binPath = project.getDeviceStatusInfo().getBinaryInfo(bid).getTargetBinaryPath();
                        if (binPath != null && !binPath.isEmpty()) {
                            int index = binPath.lastIndexOf("/");
                            binName = binPath.substring(index + 1, binPath.length());
                        }
                    }
                    StringBuffer buffer = new StringBuffer();
                    buffer.append(process.getPid()).append(Toolbar.PROCESS_SPLITER);
                    buffer.append(binName);
                    Toolbar.this.processCombo.add(buffer.toString());
                    ++i;
                }
            }
        });
        this.startButton.addClickListener(new DACustomButtonClickEventListener(){

            public void handleClickEvent(DACustomButton button) {
                if (!SettingDataManager.INSTANCE.checkConnectedTargetType()) {
                    UIActionHolder.getUIAction().showWarning(button.getShell(), String.valueOf(DAResult.ErrorCode.ERR_DEVICE_TARGET_MISMATCH.getErrorMessage()) + "\nDevice type: " + SettingDataManager.INSTANCE.getConnectedTargetOrNull().getTargetName() + "\nSelected target: " + SettingDataManager.INSTANCE.getSelectedTarget());
                    Logger.info((Object)DAResult.ErrorCode.ERR_DEVICE_TARGET_MISMATCH.getErrorMessage());
                    return;
                }
                if (DAState.isStartable()) {
                    MarkerManager.INSTANCE.clearMarkerList();
                    CommandAction.startTrace();
                } else if (DAState.isRunning()) {
                    CommandAction.stopTrace(new DAResult(DAResult.ErrorCode.SUCCESS), false);
                } else {
                    Logger.error((Object)"Wrong action for start button");
                }
            }
        });
        this.openTraceButton.addClickListener(new DACustomButtonClickEventListener(){

            public void handleClickEvent(DACustomButton button) {
                Shell shell = WorkbenchUtil.getWorkbenchWindow().getShell();
                OpenTraceDialog dialog = new OpenTraceDialog(shell);
                Object result = dialog.open();
                if (result != null) {
                    Toolbar.this.processCombo.setVisible(true);
                }
            }
        });
        this.configButton.addClickListener(new DACustomButtonClickEventListener(){

            public void handleClickEvent(DACustomButton button) {
                Shell shell = WorkbenchUtil.getWorkbenchWindow().getShell();
                PreferencesDialog preferenceDialog = new PreferencesDialog(shell);
                preferenceDialog.open();
            }
        });
        this.screenshotButton.addClickListener(new DACustomButtonClickEventListener(){

            public void handleClickEvent(DACustomButton button) {
                AnalyzerUtil.captureScreenshot();
            }
        });
        this.aboutButton.addClickListener(new DACustomButtonClickEventListener(){

            public void handleClickEvent(DACustomButton button) {
                Shell shell = WorkbenchUtil.getWorkbenchWindow().getShell();
                AboutDialog dialog = new AboutDialog(shell);
                dialog.open();
            }
        });
        this.searchButton.addClickListener(new DACustomButtonClickEventListener(){

            public void handleClickEvent(DACustomButton button) {
                Shell shell = WorkbenchUtil.getWorkbenchWindow().getShell();
                BaseView baseView = (BaseView)WorkbenchUtil.getViewPart((String)BaseView.ID);
                Composite comp = baseView.getTopPage().getActiveTable();
                SearchDialog dialog = new SearchDialog(shell, comp);
                dialog.open();
            }
        });
        this.viewSourceButton.addClickListener(new DACustomButtonClickEventListener(){

            public void handleClickEvent(DACustomButton button) {
            }
        });
    }

    private void createToolbar(Composite parent) {
        this.startButton = new DACustomButton(parent, ImageResources.START, ImageResources.START_PUSH, ImageResources.START_HOVER, ImageResources.START_DISABLE);
        this.setStartButtonState(false);
        this.startButton.setToolTipText(ShortCutManager.START_TRACE);
        this.buttons.put(0, this.startButton);
        this.timerClock = new TimerClock(parent, 0);
        this.timerClock.setBgImage(ImageResources.TIMER);
        this.timerClock.setClockFont(FontResources.TIMER);
        this.timerClock.setFontColor(ColorResources.POINT);
        this.circleProgress = CircleProgress.getCircleProgress((Composite)parent, (int)0);
        this.circleProgress.setVisible(false);
        this.openTraceButton = new DACustomButton(parent, ImageResources.OPEN, ImageResources.OPEN_PUSH, ImageResources.OPEN_HOVER, ImageResources.OPEN_DISABLE);
        this.openTraceButton.setToolTipText(ShortCutManager.OPEN_TRACE);
        this.openTraceButton.setBackground(ColorResources.COOLBAR_BG_COLOR);
        this.buttons.put(2, this.openTraceButton);
        this.configButton = new DACustomButton(parent, ImageResources.DA_PREFERENCES_ICON_NOR, ImageResources.DA_PREFERENCES_ICON_SEL, ImageResources.DA_PREFERENCES_ICON_OVER, ImageResources.DA_PREFERENCES_ICON_DIM);
        this.configButton.setToolTipText(ShortCutManager.COOLBAR_AREA_SETTING);
        this.configButton.setBackground(ColorResources.GRAY_220);
        this.buttons.put(6, this.configButton);
        this.screenshotButton = new DACustomButton(parent, ImageResources.DA_SCREENSHOT_ICON_NOR, ImageResources.DA_SCREENSHOT_ICON_FOC, ImageResources.DA_SCREENSHOT_ICON_OVER, ImageResources.DA_SCREENSHOT_ICON_DIM);
        this.screenshotButton.setToolTipText("Capture screen");
        this.screenshotButton.setBackground(ColorResources.GRAY_220);
        this.buttons.put(8, this.screenshotButton);
        this.aboutButton = new DACustomButton(parent, ImageResources.DA_INFO_ICON_NOR, ImageResources.DA_INFO_ICON_SEL, ImageResources.DA_INFO_ICON_OVER, ImageResources.DA_INFO_ICON_DIM);
        this.aboutButton.setToolTipText(ShortCutManager.COOLBAR_AREA_ABOUT);
        this.aboutButton.setBackground(ColorResources.GRAY_220);
        this.buttons.put(5, this.aboutButton);
        this.searchButton = new DACustomButton(parent, ImageResources.SEARCH, ImageResources.SEARCH_PUSH, ImageResources.SEARCH_HOVER, ImageResources.SEARCH_DISABLE);
        this.searchButton.setToolTipText(ShortCutManager.COOLBAR_AREA_SEARCH);
        this.searchButton.setBackground(ColorResources.GRAY_220);
        this.buttons.put(10, this.searchButton);
        this.viewSourceButton = new DACustomToggleButton(parent, ImageResources.VIEW_SOURCE_NORMAL, ImageResources.VIEW_SOURCE_PUSH, ImageResources.VIEW_SOURCE_HOVER, ImageResources.VIEW_SOURCE_DISABLE, ImageResources.VIEW_SOURCE_TOGGLE, ImageResources.VIEW_SOURCE_TOGGLE_HOVER, ImageResources.VIEW_SOURCE_DISABLE, ImageResources.VIEW_SOURCE_TOGGLE_PUSH);
        this.viewSourceButton.setToolTipText(ShortCutManager.COOLBAR_AREA_VIEW_SOURCE);
        this.viewSourceButton.setBackground(ColorResources.COOLBAR_BG_COLOR);
        this.buttons.put(4, (DACustomButton)this.viewSourceButton);
        this.openTraceButton.setVisible(false);
        this.viewSourceButton.setVisible(false);
        FormData data = new FormData();
        data = new FormData();
        data.top = new FormAttachment(0, 11);
        data.left = new FormAttachment((Control)this.startButton, 0);
        data.width = 118;
        data.height = 24;
        this.timerClock.setLayoutData((Object)data);
        data = new FormData();
        data.top = new FormAttachment(0, 11);
        data.left = new FormAttachment((Control)this.timerClock, 3);
        data.width = 200;
        data.height = 30;
        this.circleProgress.setLayoutData((Object)data);
        data = new FormData();
        data.top = new FormAttachment(0, 11);
        data.left = new FormAttachment((Control)this.timerClock, 4, 131072);
        data.width = 27;
        data.height = 30;
        this.openTraceButton.setLayoutData((Object)data);
        data = new FormData();
        data.top = new FormAttachment(0, 11);
        data.right = new FormAttachment(100, -20);
        data.width = 24;
        data.height = 24;
        this.aboutButton.setLayoutData((Object)data);
        data = new FormData();
        data.top = new FormAttachment(0, 11);
        data.right = new FormAttachment((Control)this.aboutButton, -17);
        data.width = 24;
        data.height = 24;
        this.configButton.setLayoutData((Object)data);
        data = new FormData();
        data.top = new FormAttachment(0, 11);
        data.right = new FormAttachment((Control)this.configButton, -17);
        data.width = 24;
        data.height = 24;
        this.screenshotButton.setLayoutData((Object)data);
        data = new FormData();
        data.top = new FormAttachment(0, 11);
        data.right = new FormAttachment((Control)this.screenshotButton, -17);
        data.width = 24;
        data.height = 24;
        this.searchButton.setLayoutData((Object)data);
        data = new FormData();
        data.top = new FormAttachment(0, 11);
        data.right = new FormAttachment((Control)this.searchButton, -5);
        data.width = 27;
        data.height = 30;
        this.viewSourceButton.setLayoutData((Object)data);
        this.deviceCombo = this.makeDAToolBarCustomCombo(parent, 0);
        data = new FormData();
        data.top = new FormAttachment(0, 11);
        data.left = new FormAttachment(0, 20);
        data.width = 168;
        data.height = 24;
        this.deviceCombo.setLayoutData(data);
        Label bracketLabel = new Label(parent, 0x41000000);
        bracketLabel.setImage(ImageResources.BIG_RIGHT_ARROW);
        bracketLabel.setBackground(ColorResources.WHITE);
        data = new FormData();
        data.top = new FormAttachment(0, 11);
        data.left = new FormAttachment((Control)this.deviceCombo, 0, 131072);
        data.width = 13;
        data.height = 24;
        bracketLabel.setLayoutData((Object)data);
        this.appCombo = this.makeDAToolBarCustomCombo(parent, 1);
        data = new FormData();
        data.top = new FormAttachment(0, 11);
        data.left = new FormAttachment((Control)bracketLabel, 0, 131072);
        data.width = 168;
        data.height = 24;
        this.appCombo.setLayoutData(data);
        this.processCombo = this.makeDACustomCombo(parent);
        data = new FormData();
        data.top = new FormAttachment(0, 11);
        data.left = new FormAttachment((Control)this.appCombo, 15);
        data.width = 168;
        data.height = 24;
        this.processCombo.setLayoutData((Object)data);
        data.top = new FormAttachment(0, 11);
        data.left = new FormAttachment((Control)this.appCombo, 8, 131072);
        data.width = 60;
        data.height = 24;
        this.startButton.setLayoutData((Object)data);
        this.initDeviceCombo();
        this.initProcessCombo();
        this.addToolbarListeners();
    }

    private DACustomCombo makeDACustomCombo(Composite parent) {
        DACustomCombo returnCombo = new DACustomCombo(parent, 0);
        returnCombo.setComboGradation(ColorResources.WHITE, ColorResources.WHITE, ColorResources.POINT, ColorResources.POINT, ColorResources.WHITE, ColorResources.WHITE, ColorResources.WHITE, ColorResources.WHITE);
        returnCombo.setOutlineColors(ColorResources.GRAY_130, ColorResources.WHITE, ColorResources.GRAY_130, ColorResources.GRAY_130);
        returnCombo.setComboImages(ImageResources.DROP_ARROW_DOWN_NOR, ImageResources.DROP_ARROW_DOWN_SEL, ImageResources.DROP_ARROW_DOWN_HOVER, ImageResources.DROP_ARROW_DOWN_DIM);
        returnCombo.setComboImagePoint(new Point(130, 9));
        returnCombo.setComboButtonColor(ColorResources.WHITE, ColorResources.WHITE, ColorResources.WHITE, ColorResources.WHITE);
        returnCombo.setArrowOutlineColors(ColorResources.GRAY_220, ColorResources.GRAY_220, ColorResources.GRAY_220, ColorResources.GRAY_220);
        returnCombo.setButtonImages(ImageResources.COMBO_DROPDOWN_UP, ImageResources.COMBO_DROPDOWN_DOWN);
        returnCombo.setFontPoint(new Point(5, 5));
        returnCombo.setEnabled(true);
        returnCombo.setComboFont(FontResources.COMBO);
        returnCombo.setItemFont(FontResources.DROPDOWN);
        returnCombo.setFontColors(ColorResources.BLACK, ColorResources.BLACK, ColorResources.BLACK, ColorResources.GRAY_170);
        returnCombo.setButtonRenderer((IDACustomButtonRenderer)new DACustomButtonRenderer());
        return returnCombo;
    }

    private DAToolBarCustomCombo makeDAToolBarCustomCombo(Composite parent, int whatcombo) {
        DAToolBarCustomCombo returnCombo = new DAToolBarCustomCombo(parent, 0);
        returnCombo.setComboGradation(ColorResources.WHITE, ColorResources.WHITE, ColorResources.WHITE, ColorResources.WHITE, ColorResources.WHITE, ColorResources.WHITE, ColorResources.WHITE, ColorResources.WHITE);
        returnCombo.setOutlineColors(ColorResources.GRAY_130, ColorResources.WHITE, ColorResources.GRAY_130, ColorResources.GRAY_130);
        returnCombo.setComboImages(ImageResources.DROP_ARROW_DOWN_NOR, ImageResources.DROP_ARROW_DOWN_SEL, ImageResources.DROP_ARROW_DOWN_HOVER, ImageResources.DROP_ARROW_DOWN_DIM);
        returnCombo.setComboImagePoint(new Point(130, 9));
        returnCombo.setComboButtonColor(ColorResources.WHITE, ColorResources.WHITE, ColorResources.WHITE, ColorResources.WHITE);
        returnCombo.setArrowOutlineColors(ColorResources.GRAY_220, ColorResources.GRAY_220, ColorResources.GRAY_220, ColorResources.GRAY_220);
        returnCombo.setButtonImages(ImageResources.COMBO_DROPDOWN_UP, ImageResources.COMBO_DROPDOWN_DOWN);
        returnCombo.setFontPoint(new Point(5, 5));
        returnCombo.setEnabled(true);
        returnCombo.setComboFont(FontResources.COMBO);
        returnCombo.setItemFont(FontResources.DROPDOWN);
        returnCombo.setFontColors(ColorResources.BLACK, ColorResources.BLACK, ColorResources.BLACK, ColorResources.GRAY_170);
        returnCombo.setDeviceCombo(whatcombo);
        returnCombo.setButtonRenderer((IDACustomButtonRenderer)new DACustomButtonRenderer());
        return returnCombo;
    }

    @UIMethod
    private void initDeviceCombo() {
        this.deviceCombo.initCombo();
        this.deviceCombo.setTextAndIDForce("Select Target", "da.id.dummy.select.device");
        this.deviceCombo.add("[Remote Device]");
        this.deviceCombo.select(0);
    }

    public boolean selectDevice(String newDeviceName) {
        this.applicationListTask = null;
        if (newDeviceName == null || newDeviceName.isEmpty()) {
            this.selectDummyDevice();
            return false;
        }
        if (!newDeviceName.equals("[Remote Device]")) {
            return this.selectLocalDevice(newDeviceName);
        }
        return this.selectRemoteDevice();
    }

    private boolean selectRemoteDevice() {
        DeviceInfo oldDevInfo = Global.getCurrentDeviceInfo();
        Display.getDefault().syncExec(() -> {
            Shell shell = WorkbenchUtil.getWorkbenchWindow().getShell();
            RemoteDeviceDialog pdialog = new RemoteDeviceDialog(shell);
            pdialog.open();
            String newDevice = pdialog.getAddress();
            if (newDevice == null || newDevice.isEmpty()) {
                this.showDeviceComboTitle();
            } else if (!this.selectDeviceCombo(newDevice)) {
                this.showDeviceComboTitle();
            } else {
                this.updateAppCombo(true);
                this.appCombo.setEnabled(true);
            }
        });
        return Global.getCurrentDeviceInfo() != null && !Global.getCurrentDeviceInfo().equals(oldDevInfo);
    }

    private boolean selectLocalDevice(String newDeviceName) {
        if (DeviceManager.onDeviceSelected(newDeviceName)) {
            if (DAState.isStartable()) {
                CommonAction.configure();
            }
            this.selectDeviceCombo(newDeviceName);
            this.composeAppCombo(this.oldAppList == null ? this.getAppListFromTarget() : this.oldAppList);
            this.updateAppCombo(true);
            this.appCombo.setEnabled(true);
            return true;
        }
        this.selectDummyDevice();
        return false;
    }

    private void selectDummyDevice() {
        DeviceManager.onDeviceSelected("");
        this.deviceCombo.setTextAndIDForce("Select Target", "da.id.dummy.select.device");
        this.ShowAppComboTitle();
        this.appCombo.setEnabled(false);
    }

    @UIMethod
    private boolean selectDeviceCombo(String deviceName) {
        if (deviceName == null || deviceName.isEmpty()) {
            return false;
        }
        List<String> devicelist = this.deviceCombo.getItems();
        int size = devicelist.size();
        int i = 0;
        while (i < size) {
            if (devicelist.get(i).equals(deviceName) && DeviceManager.onDeviceSelected(deviceName)) {
                this.deviceCombo.select(i);
                this.deviceCombo.setToolTipText(deviceName);
                if (flatFeatureDialog != null && flatFeatureDialog.getTargetPage() != null) {
                    flatFeatureDialog.getTargetPage().selectTarget(DeviceManager.getDeviceByName(deviceName));
                } else {
                    String targetName = DeviceManager.getDeviceByName(deviceName).getPlatformName();
                    if (!SettingDataManager.INSTANCE.getTargetListMap().containsKey(targetName)) {
                        SettingDataManager.INSTANCE.addBrandNewTarget(targetName);
                    }
                    FlatFeatureDialogTargetPage.setPredefinedTarget(targetName);
                }
                return true;
            }
            ++i;
        }
        return false;
    }

    @UIMethod
    public boolean updateDeviceCombo(String newSelectedDevice) {
        String oldSelectedDevice = "";
        DeviceInfo oldDev = Global.getCurrentDeviceInfo();
        if (oldDev != null) {
            oldSelectedDevice = oldDev.getIDevice().getSerialNumber();
        }
        if (newSelectedDevice == null) {
            newSelectedDevice = oldSelectedDevice;
            this.showDeviceComboTitle();
        }
        this.setAllControlState(false);
        List<DeviceInfo> devices = DeviceManager.getDevices();
        this.deviceCombo.initCombo();
        if (!devices.isEmpty()) {
            int numofdev = devices.size();
            int i = 0;
            while (i < numofdev) {
                this.deviceCombo.add(devices.get(i).getIDevice().getSerialNumber());
                ++i;
            }
        } else {
            this.deviceCombo.add("");
            this.showDeviceComboTitle();
        }
        this.deviceCombo.add("[Remote Device]");
        if (!this.selectDeviceCombo(newSelectedDevice)) {
            this.showDeviceComboTitle();
        }
        this.changeUIState(DAState.getCurrentState());
        String selectedFinally = this.deviceCombo.getText();
        if (selectedFinally == null) {
            return oldSelectedDevice == null || oldSelectedDevice.isEmpty();
        }
        this.showDeviceComboTitle();
        return selectedFinally.equals(oldSelectedDevice);
    }

    private List<AppInfo> getAppListFromTarget() {
        if (this.applicationListTask == null) {
            this.applicationListTask = CompletableFuture.supplyAsync(() -> this.getAppListFromTargetTask());
        }
        while (!this.applicationListTask.isDone()) {
        }
        try {
            return this.applicationListTask.get();
        }
        catch (InterruptedException | ExecutionException e) {
            Logger.error((Object)e);
            return Collections.emptyList();
        }
    }

    private List<AppInfo> getAppListFromTargetTask() {
        Map<String, PackageInfo> pkgInfos = DACommunicator.updatePkgMapFromTarget();
        ArrayList<AppInfo> appList = new ArrayList<AppInfo>();
        if (pkgInfos == null) {
            return appList;
        }
        for (Map.Entry<String, PackageInfo> entry : pkgInfos.entrySet()) {
            for (AppInfo app : entry.getValue().getAppInfos()) {
                if (ApplistManager.isInBlackList(app)) continue;
                String label = app.getLabel();
                if (label.isEmpty()) {
                    label = app.getExecFileName();
                    app.setInfo(AppInfo.PROPERTY.LABEL.index, label);
                }
                appList.add(app);
            }
        }
        Collections.sort(appList, new Comparator<AppInfo>(){

            @Override
            public int compare(AppInfo a1, AppInfo a2) {
                String o1 = a1.getLabel();
                String o2 = a2.getLabel();
                if (o1.startsWith("[") && !o2.startsWith("[")) {
                    return 1;
                }
                if (!o1.startsWith("[") && o2.startsWith("[")) {
                    return -1;
                }
                return o1.compareToIgnoreCase(o2);
            }
        });
        return appList;
    }

    private void redrawAppcombo() {
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                Toolbar.this.appCombo.redraw();
            }
        });
    }

    @UIMethod
    private void composeAppCombo(List<AppInfo> appList) {
        this.appCombo.initCombo();
        if (!appList.isEmpty()) {
            this.appCombo.add("===[App List]===", "da.id.dummy.select.applist");
            for (AppInfo app : appList) {
                if (app.getAppType().equals("webapp")) continue;
                this.appCombo.add(app.getDistinguishedLabel(), app.getAppID());
            }
        } else {
            this.ShowAppComboTitle();
        }
        this.redrawAppcombo();
    }

    @UIMethod
    private boolean selectAppCombo(int index) {
        boolean bret = false;
        List<String> appIDs = this.appCombo.getItemIDs();
        if (index > -1 && index < appIDs.size()) {
            AppInfo selectedApp;
            String appLabel = this.appCombo.getItem(index);
            String appID = appIDs.get(index);
            DeviceInfo curDev = Global.getCurrentDeviceInfo();
            if (appLabel.isEmpty()) {
                this.appCombo.select(index);
                Global.setCurrentApplication(null);
                if (curDev != null) {
                    this.onAppSelected(null);
                }
                bret = true;
            } else if (curDev != null && (selectedApp = curDev.getAppInfoByAppID(appID)) != null) {
                this.appCombo.select(index);
                Global.setCurrentApplication(selectedApp);
                this.onAppSelected(selectedApp);
                bret = true;
            }
        }
        return bret;
    }

    @UIMethod
    private boolean selectAppComboByID(String appID) {
        List<String> appIDs = this.appCombo.getItemIDs();
        int lookupIdx = appIDs.indexOf(appID);
        return this.selectAppCombo(lookupIdx);
    }

    @UIMethod
    public boolean setApplicationByID(String appID) {
        if (this.selectAppComboByID(appID)) {
            return true;
        }
        this.updateAppCombo(false);
        return false;
    }

    @UIMethod
    public void updateAppCombo(boolean deviceChanged) {
        String device = this.deviceCombo.getText();
        if (device == null || device.isEmpty() || device.equals("Select Target")) {
            this.appCombo.initCombo();
            this.selectAppCombo(0);
            this.setAppComboState(false);
            this.showDeviceComboTitle();
            return;
        }
        if (deviceChanged) {
            this.newAppList = this.getAppListFromTarget();
            this.composeAppCombo(this.newAppList);
            this.oldAppList = this.newAppList;
            this.updateNewComboThread();
            if (this.oldAppList.size() == 1) {
                this.selectAppCombo(1);
                this.setAppComboState(true);
                this.setStartButtonState(true);
                return;
            }
            this.ShowAppComboTitle();
        } else {
            AppInfo oldApp = Global.getCurrentApplication();
            String oldAppID = null;
            if (oldApp != null) {
                oldAppID = oldApp.getAppID();
            }
            this.updateNewComboThread();
            this.composeAppCombo(this.oldAppList);
            this.ShowAppComboTitle();
            if (oldAppID == null || this.appCombo.getItemIDs().indexOf(oldAppID) < 0) {
                if (this.oldAppList.size() == 1) {
                    this.selectAppCombo(1);
                    this.setAppComboState(true);
                    this.setStartButtonState(true);
                    return;
                }
                this.selectAppCombo(0);
            } else {
                int lookupIdx = this.appCombo.getItemIDs().indexOf(oldAppID);
                this.appCombo.select(lookupIdx);
                if (this.startButton.isEnabled()) {
                    this.setAppComboState(true);
                    this.setStartButtonState(true);
                    return;
                }
            }
        }
        this.setAppComboState(true);
        this.setStartButtonState(false);
    }

    private void updateNewComboThread() {
        Thread updateNewCombo = new Thread(new Runnable(){

            @Override
            public void run() {
                if (Toolbar.this.isAppListUpdated()) {
                    Toolbar.this.redrawAppcombo();
                    Toolbar.this.composeAppCombo(Toolbar.this.newAppList);
                    System.out.println("--PkgList updated--");
                    Toolbar.this.oldAppList = Toolbar.this.newAppList;
                    Toolbar.this.AppComboTitleChanged();
                }
            }
        }, "UpdateNewComboThread");
        updateNewCombo.start();
    }

    private void AppComboTitleChanged() {
        Display.getDefault().syncExec(new Runnable(){

            @Override
            public void run() {
                AppInfo oldApp = Global.getCurrentApplication();
                if (oldApp == null || Toolbar.this.appCombo.getItemIDs().indexOf(oldApp.getAppID()) < 0) {
                    Toolbar.this.selectAppCombo(0);
                } else {
                    Toolbar.this.appCombo.setTextAndID(oldApp.getDistinguishedLabel(), oldApp.getAppID());
                }
            }
        });
    }

    private void onAppSelected(AppInfo appInfo) {
        if (appInfo == null) {
            return;
        }
        if (ProgressManager.INSTANCE != null) {
            Display.getDefault().syncExec(() -> {
                this.progress = ProgressManager.INSTANCE.createProgress(false, 1, AnalyzerLabels.DLG_COPYING_BINARY, AnalyzerLabels.DLG_PLEASE_WAIT, null);
                this.progress.setValues("Getting process information", 30);
            });
        }
        List<String> binPaths = appInfo.getProcessInformation();
        if (this.progress != null) {
            Display.getDefault().syncExec(() -> this.progress.setValues("Getting binary from device", 70));
        }
        appInfo.getBinaryInformation(binPaths);
        if (this.progress != null) {
            Display.getDefault().syncExec(() -> ProgressManager.INSTANCE.stopProgress(this.progress));
        }
    }

    public boolean isAppListUpdated() {
        this.newAppList = this.getAppListFromTarget();
        if (this.newAppList.size() != this.oldAppList.size()) {
            this.oldAppList = this.newAppList;
            return true;
        }
        int i = 0;
        while (i < this.newAppList.size()) {
            String appID = this.newAppList.get(i).getAppID();
            if (appID != this.oldAppList.get(i).getAppID()) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public void startTimer() {
        this.timerClock.start();
    }

    public void stopTimer() {
        this.timerClock.stop();
    }

    @UIMethod
    public void clearTimer() {
        this.timerClock.clear();
    }

    public void setTimerAlarm(long time, IAlarm alarm) {
        this.timerClock.setAlarm(time, alarm);
    }

    public void removeTimerAlarm() {
        this.timerClock.removeAlarm();
    }

    public long getTime() {
        return this.timerClock.getTimeInMicroseconds();
    }

    public void setTime(final long time) {
        Display.getDefault().syncExec(new Runnable(){

            @Override
            public void run() {
                Toolbar.this.timerClock.setTime(time / 1000L);
            }
        });
    }

    @UIMethod
    private void initProcessCombo() {
        this.processCombo.initCombo();
        this.processCombo.add(ALL_PROCESS);
        this.processCombo.select(0);
        this.processCombo.setVisible(false);
    }

    public int getSelectedPid() {
        int index;
        String str;
        int ret = 0;
        String pid = this.processCombo.getText();
        if (pid != null && !pid.equals(ALL_PROCESS) && (str = pid.substring(0, index = pid.indexOf(PROCESS_SPLITER))) != null && !str.isEmpty()) {
            try {
                ret = Integer.parseInt(str);
            }
            catch (NumberFormatException e) {
                Logger.exception((Throwable)e);
            }
        }
        return ret;
    }

    public void resetProcessCombo() {
        Display.getDefault().syncExec(new Runnable(){

            @Override
            public void run() {
                Toolbar.this.initProcessCombo();
            }
        });
    }

    public void changeUIState(DAState state) {
        final DAState fState = state;
        Display.getDefault().syncExec(new Runnable(){

            @Override
            public void run() {
                if (fState == DAState.PREPARE_START) {
                    Toolbar.this.setAllControlState(false);
                    Toolbar.this.setScreenShotButtonEnable(false);
                } else if (fState == DAState.RUNNING) {
                    Toolbar.this.toggleStartButtonUI(true);
                    Toolbar.this.setStartButtonState(true);
                    Toolbar.this.setMajorControlState(false);
                    Toolbar.this.setMinorControlState(true);
                    Toolbar.this.setScreenShotButtonEnable(true);
                } else if (fState == DAState.PREPARE_STOP) {
                    Toolbar.this.setAllControlState(false);
                    Toolbar.this.setScreenShotButtonEnable(false);
                } else if (fState == DAState.PREPARE_CANCEL) {
                    Toolbar.this.setAllControlState(false);
                    Toolbar.this.setScreenShotButtonEnable(false);
                } else if (fState == DAState.DONE || fState == DAState.INIT) {
                    Toolbar.this.toggleStartButtonUI(false);
                    Toolbar.this.setAllControlState(true);
                    Toolbar.this.setScreenShotButtonEnable(false);
                } else {
                    Toolbar.this.setAllControlState(false);
                    Toolbar.this.setScreenShotButtonEnable(false);
                }
            }
        });
    }

    public void setAllControlState(boolean enabled) {
        final boolean fEnabled = enabled;
        Display.getDefault().syncExec(new Runnable(){

            @Override
            public void run() {
                Toolbar.this.setStartButtonState(fEnabled);
                Toolbar.this.setMajorControlState(fEnabled);
                Toolbar.this.setMinorControlState(fEnabled);
            }
        });
    }

    private void toggleStartButtonUI(boolean isStarted) {
        if (isStarted) {
            this.startButton.setImages(ImageResources.STOP, ImageResources.STOP_PUSH, ImageResources.STOP_HOVER, ImageResources.START_DISABLE);
            this.startButton.setToolTipText(ShortCutManager.STOP_TRACE);
        } else {
            this.startButton.setImages(ImageResources.START, ImageResources.START_PUSH, ImageResources.START_HOVER, ImageResources.START_DISABLE);
            this.startButton.setToolTipText(ShortCutManager.START_TRACE);
        }
    }

    private boolean checkThatConnectedCorrespondsToTarget() {
        TimelinePage tP = (TimelinePage)AnalyzerUtil.getTabPage(TimelinePage.pageID);
        DAChartBoardItem item = tP.getTimelineChartView().getChartBoard().getItemList().get(0);
        if (item == null || item.getItemCell().getItemName() == null || item.getItemCell().getItemName().isEmpty()) {
            item = new DAChartBoardItem(tP.getTimelineChartView().getChartBoard(), "");
        }
        if (SettingDataManager.INSTANCE.checkConnectedTargetType()) {
            item.getChart().setChartRenderer(new DAChartRenderer());
            tP.redraw();
            tP.update();
            return true;
        }
        Logger.debug((Object)"check failed, new error message will be added to chart");
        this.startButton.setButtonEnabled(false);
        this.appCombo.setEnabled(false);
        tP.getTimelineChartView().getChartBoard().getItemList().showAllItems(false);
        tP.getTimelineChartView().getChartBoard().getItemList().showItem(0);
        item.getChart().setChartRenderer((DAChartRenderer)new DANotificationOnChartRenderer(UserErrorWarningLabels.ERR_GUIDE_SELECT_ANOTHER_DEVICE));
        tP.redraw();
        tP.update();
        return false;
    }

    private void setAppComboState(boolean enabled) {
        DeviceInfo device;
        if (enabled && this.checkThatConnectedCorrespondsToTarget() && (device = Global.getCurrentDeviceInfo()) != null) {
            this.appCombo.setEnabled(true);
            return;
        }
        this.appCombo.setEnabled(false);
    }

    private void setStartButtonState(boolean enabled) {
        DeviceInfo device;
        if (enabled && this.checkThatConnectedCorrespondsToTarget() && (device = Global.getCurrentDeviceInfo()) != null) {
            AppInfo curApp;
            String selDev = this.deviceCombo.getText();
            String curDev = device.getIDevice().getSerialNumber();
            if (curDev != null && !curDev.isEmpty() && curDev.equals(selDev) && (curApp = Global.getCurrentApplication()) != null && curApp.isPossibleToTrace()) {
                if (curApp.getLabel().equals("[Running process]")) {
                    if (curApp.getRunningProcesses() != null) {
                        this.startButton.setButtonEnabled(true);
                        return;
                    }
                } else if (curApp.getLabel().equals("[Common executable]")) {
                    if (curApp.getExecPath() != null && !curApp.getExecPath().isEmpty()) {
                        this.startButton.setButtonEnabled(true);
                        return;
                    }
                } else {
                    this.startButton.setButtonEnabled(true);
                    return;
                }
            }
        }
        this.startButton.setButtonEnabled(false);
    }

    private void setMajorControlState(boolean enabled) {
        this.deviceCombo.setEnabled(enabled);
        this.setAppComboState(enabled);
        this.openTraceButton.setButtonEnabled(enabled);
    }

    private void setMinorControlState(boolean enabled) {
        this.processCombo.setEnabled(enabled);
        this.viewSourceButton.setButtonEnabled(enabled);
        this.configButton.setButtonEnabled(enabled);
        this.aboutButton.setButtonEnabled(enabled);
        this.searchButton.setButtonEnabled(enabled);
    }

    private void setScreenShotButtonEnable(boolean enabled) {
        this.screenshotButton.setButtonEnabled(enabled);
    }

    public boolean isSourceViewEnabled() {
        return this.viewSourceButton.isToggled();
    }

    public void toggleSourceView() {
        Display.getDefault().syncExec(new Runnable(){

            @Override
            public void run() {
                Toolbar.this.viewSourceButton.setToggled(!Toolbar.this.viewSourceButton.isToggled());
            }
        });
    }

    public boolean getButtonEnabled(int id) {
        DACustomButton button = this.buttons.get(id);
        return button.isButtonEnabled();
    }

    public void showDeviceComboTitle() {
        if (!this.deviceCombo.getItems().get(0).equals("[Remote Device]") && !this.deviceCombo.getItems().get(0).equals("")) {
            this.selectDevice(this.deviceCombo.getItems().get(0));
        } else {
            this.deviceCombo.setTextAndIDForce("Select Target", "da.id.dummy.select.device");
        }
    }

    public void ShowAppComboTitle() {
        this.appCombo.setTextAndIDForce("Select Application", "da.id.dummy.select.app");
    }

    public void setChartDragStartTime(long time) {
        this.chartDragStart = time;
    }

    public void setChartDragEndTime(long time) {
        this.chartDragEnd = time;
    }

    public long getChartDragStartTime() {
        return this.chartDragStart;
    }

    public long getChartDragEndTime() {
        return this.chartDragEnd;
    }

    public boolean getDlogSelection() {
        return this.dlogTimeSelection;
    }

    public void setDlogSelection(boolean dlogSelection) {
        this.dlogTimeSelection = dlogSelection;
    }

    public static synchronized void setFlatFeatureDialog(FlatFeatureDialog ffd) {
        flatFeatureDialog = ffd;
    }
}

