/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.dom.rewrite.changegenerator;

import org.eclipse.cdt.core.dom.ast.ASTVisitor;
import org.eclipse.cdt.core.dom.ast.IASTArrayModifier;
import org.eclipse.cdt.core.dom.ast.IASTDeclSpecifier;
import org.eclipse.cdt.core.dom.ast.IASTDeclaration;
import org.eclipse.cdt.core.dom.ast.IASTDeclarator;
import org.eclipse.cdt.core.dom.ast.IASTEnumerationSpecifier;
import org.eclipse.cdt.core.dom.ast.IASTExpression;
import org.eclipse.cdt.core.dom.ast.IASTInitializer;
import org.eclipse.cdt.core.dom.ast.IASTName;
import org.eclipse.cdt.core.dom.ast.IASTNode;
import org.eclipse.cdt.core.dom.ast.IASTParameterDeclaration;
import org.eclipse.cdt.core.dom.ast.IASTProblem;
import org.eclipse.cdt.core.dom.ast.IASTStatement;
import org.eclipse.cdt.core.dom.ast.IASTTranslationUnit;
import org.eclipse.cdt.core.dom.ast.IASTTypeId;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTCompositeTypeSpecifier;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTNamespaceDefinition;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTTemplateParameter;
import org.eclipse.cdt.internal.core.dom.rewrite.ASTModification;
import org.eclipse.cdt.internal.core.dom.rewrite.ASTModificationStore;
import org.eclipse.cdt.internal.core.dom.rewrite.astwriter.ASTWriterVisitor;
import org.eclipse.cdt.internal.core.dom.rewrite.changegenerator.ASTModificationHelper;
import org.eclipse.cdt.internal.core.dom.rewrite.changegenerator.ModificationScopeStack;
import org.eclipse.cdt.internal.core.dom.rewrite.changegenerator.ModifiedASTDeclSpecWriter;
import org.eclipse.cdt.internal.core.dom.rewrite.changegenerator.ModifiedASTDeclarationWriter;
import org.eclipse.cdt.internal.core.dom.rewrite.changegenerator.ModifiedASTDeclaratorWriter;
import org.eclipse.cdt.internal.core.dom.rewrite.changegenerator.ModifiedASTExpressionWriter;
import org.eclipse.cdt.internal.core.dom.rewrite.changegenerator.ModifiedASTStatementWriter;
import org.eclipse.cdt.internal.core.dom.rewrite.commenthandler.NodeCommentMap;

public class ChangeGeneratorWriterVisitor
extends ASTWriterVisitor {
    private static final String DEFAULT_INDENTATION = "";
    private final ASTModificationStore modificationStore;
    private final String fileScope;
    private ModificationScopeStack stack;

    public ChangeGeneratorWriterVisitor(ASTVisitor delegateVisitor, ASTModificationStore modificationStore, String fileScope, NodeCommentMap commentMap) {
        super(commentMap);
        this.modificationStore = modificationStore;
        this.fileScope = fileScope;
        this.stack = new ModificationScopeStack(modificationStore);
        this.shouldVisitExpressions = delegateVisitor.shouldVisitExpressions;
        this.shouldVisitStatements = delegateVisitor.shouldVisitStatements;
        this.shouldVisitNames = delegateVisitor.shouldVisitNames;
        this.shouldVisitDeclarations = delegateVisitor.shouldVisitDeclarators;
        this.shouldVisitDeclSpecifiers = delegateVisitor.shouldVisitDeclSpecifiers;
        this.shouldVisitDeclarators = delegateVisitor.shouldVisitDeclarators;
        this.shouldVisitInitializers = delegateVisitor.shouldVisitInitializers;
        this.shouldVisitBaseSpecifiers = delegateVisitor.shouldVisitBaseSpecifiers;
        this.shouldVisitNamespaces = delegateVisitor.shouldVisitNamespaces;
        this.shouldVisitTemplateParameters = delegateVisitor.shouldVisitTemplateParameters;
        this.shouldVisitParameterDeclarations = delegateVisitor.shouldVisitParameterDeclarations;
        this.shouldVisitTranslationUnit = delegateVisitor.shouldVisitTranslationUnit;
        this.shouldVisitProblems = delegateVisitor.shouldVisitProblems;
        this.shouldVisitTypeIds = delegateVisitor.shouldVisitTypeIds;
        this.shouldVisitArrayModifiers = delegateVisitor.shouldVisitArrayModifiers;
    }

    public ChangeGeneratorWriterVisitor(ASTModificationStore modStore, NodeCommentMap nodeMap) {
        this(modStore, DEFAULT_INDENTATION, null, nodeMap);
    }

    public ChangeGeneratorWriterVisitor(ASTModificationStore modStore, String givenIndentation, String fileScope, NodeCommentMap commentMap) {
        super(givenIndentation, commentMap);
        this.modificationStore = modStore;
        this.fileScope = fileScope;
        this.shouldVisitTranslationUnit = true;
        this.stack = new ModificationScopeStack(this.modificationStore);
        this.declaratorWriter = new ModifiedASTDeclaratorWriter(this.scribe, this, this.stack, commentMap);
        this.expWriter = new ModifiedASTExpressionWriter(this.scribe, this, this.macroHandler, this.stack, commentMap);
        this.statementWriter = new ModifiedASTStatementWriter(this.scribe, this, this.stack, commentMap);
        this.declSpecWriter = new ModifiedASTDeclSpecWriter(this.scribe, this, this.stack, commentMap);
        this.declarationWriter = new ModifiedASTDeclarationWriter(this.scribe, this, this.stack, commentMap);
    }

    protected IASTDeclarator getParameterDeclarator(IASTParameterDeclaration parameterDeclaration) {
        IASTDeclarator newDecl = parameterDeclaration.getDeclarator();
        if (this.stack.getModifiedNodes().contains(newDecl)) {
            for (ASTModification currentModification : this.stack.getModificationsForNode(newDecl)) {
                if (currentModification.getKind() != ASTModification.ModificationKind.REPLACE || currentModification.getTargetNode() != parameterDeclaration) continue;
                newDecl = (IASTDeclarator)currentModification.getNewNode();
            }
        }
        return newDecl;
    }

    protected IASTName getParameterName(IASTDeclarator declarator) {
        IASTName newName = declarator.getName();
        if (this.stack.getModifiedNodes().contains(newName)) {
            for (ASTModification currentModification : this.stack.getModificationsForNode(newName)) {
                if (currentModification.getKind() != ASTModification.ModificationKind.REPLACE || currentModification.getTargetNode() != newName) continue;
                newName = (IASTName)currentModification.getNewNode();
            }
        }
        return newName;
    }

    public int leave(ICPPASTCompositeTypeSpecifier.ICPPASTBaseSpecifier specifier) {
        super.leave(specifier);
        return 1;
    }

    public int leave(ICPPASTNamespaceDefinition namespace) {
        super.leave(namespace);
        return 1;
    }

    public int leave(ICPPASTTemplateParameter parameter) {
        super.leave(parameter);
        return 1;
    }

    public int visit(ICPPASTCompositeTypeSpecifier.ICPPASTBaseSpecifier specifier) {
        if (this.doBeforeEveryNode(specifier) == 3) {
            return super.visit(specifier);
        }
        return 1;
    }

    public int visit(ICPPASTNamespaceDefinition namespace) {
        if (this.doBeforeEveryNode(namespace) == 3) {
            return super.visit(namespace);
        }
        return 1;
    }

    public int visit(ICPPASTTemplateParameter parameter) {
        if (this.doBeforeEveryNode(parameter) == 3) {
            return super.visit(parameter);
        }
        return 1;
    }

    public int leave(IASTDeclaration declaration) {
        super.leave(declaration);
        return 1;
    }

    public int leave(IASTDeclarator declarator) {
        super.leave(declarator);
        return 1;
    }

    public int leave(IASTDeclSpecifier declSpec) {
        super.leave(declSpec);
        return 1;
    }

    public int leave(IASTEnumerationSpecifier.IASTEnumerator enumerator) {
        super.leave(enumerator);
        return 1;
    }

    public int leave(IASTExpression expression) {
        super.leave(expression);
        return 1;
    }

    public int leave(IASTInitializer initializer) {
        super.leave(initializer);
        return 1;
    }

    public int leave(IASTName name) {
        super.leave(name);
        return 1;
    }

    public int leave(IASTParameterDeclaration parameterDeclaration) {
        super.leave(parameterDeclaration);
        return 1;
    }

    public int leave(IASTProblem problem) {
        super.leave(problem);
        return 1;
    }

    public int leave(IASTStatement statement) {
        super.leave(statement);
        return 1;
    }

    public int leave(IASTTranslationUnit tu) {
        super.leave(tu);
        return 1;
    }

    public int leave(IASTTypeId typeId) {
        super.leave(typeId);
        return 1;
    }

    public int visit(IASTDeclaration declaration) {
        if (this.doBeforeEveryNode(declaration) == 3) {
            return super.visit(declaration);
        }
        return 1;
    }

    public int visit(IASTDeclarator declarator) {
        if (this.doBeforeEveryNode(declarator) == 3) {
            return super.visit(declarator);
        }
        return 1;
    }

    public int visit(IASTDeclSpecifier declSpec) {
        if (this.doBeforeEveryNode(declSpec) == 3) {
            return super.visit(declSpec);
        }
        return 1;
    }

    public int visit(IASTEnumerationSpecifier.IASTEnumerator enumerator) {
        if (this.doBeforeEveryNode(enumerator) == 3) {
            return super.visit(enumerator);
        }
        return 1;
    }

    public int visit(IASTArrayModifier arrayModifier) {
        if (this.doBeforeEveryNode(arrayModifier) == 3) {
            return super.visit(arrayModifier);
        }
        return 1;
    }

    public int visit(IASTExpression expression) {
        if (this.doBeforeEveryNode(expression) == 3) {
            return super.visit(expression);
        }
        return 1;
    }

    public int visit(IASTInitializer initializer) {
        if (this.doBeforeEveryNode(initializer) == 3) {
            return super.visit(initializer);
        }
        return 1;
    }

    public int visit(IASTName name) {
        if (this.doBeforeEveryNode(name) == 3) {
            return super.visit(name);
        }
        return 1;
    }

    public int visit(IASTParameterDeclaration parameterDeclaration) {
        if (this.doBeforeEveryNode(parameterDeclaration) == 3) {
            return super.visit(parameterDeclaration);
        }
        return 1;
    }

    public int visit(IASTProblem problem) {
        if (this.doBeforeEveryNode(problem) == 3) {
            return super.visit(problem);
        }
        return 1;
    }

    public int visit(IASTStatement statement) {
        if (this.doBeforeEveryNode(statement) == 3) {
            return super.visit(statement);
        }
        return 1;
    }

    public int visit(IASTTranslationUnit tu) {
        IASTDeclaration[] declarations;
        ASTModificationHelper helper = new ASTModificationHelper(this.stack);
        IASTDeclaration[] iASTDeclarationArray = declarations = (IASTDeclaration[])helper.createModifiedChildArray(tu, tu.getDeclarations(), IASTDeclaration.class, this.commentMap);
        int n = declarations.length;
        int n2 = 0;
        while (n2 < n) {
            IASTDeclaration currentDeclaration = iASTDeclarationArray[n2];
            currentDeclaration.accept(this);
            ++n2;
        }
        return 1;
    }

    public int visit(IASTTypeId typeId) {
        if (this.doBeforeEveryNode(typeId) == 3) {
            return super.visit(typeId);
        }
        return 1;
    }

    protected int doBeforeEveryNode(IASTNode node) {
        String file;
        this.stack.clean(node);
        if (this.fileScope != null && !this.fileScope.equals(file = this.getCorrespondingFile(node))) {
            return 1;
        }
        for (IASTNode currentModifiedNode : this.stack.getModifiedNodes()) {
            for (ASTModification currentMod : this.stack.getModificationsForNode(currentModifiedNode)) {
                if (currentMod.getNewNode() != node || currentMod.getKind() == ASTModification.ModificationKind.REPLACE) continue;
                this.stack.pushScope(currentModifiedNode);
                return 3;
            }
        }
        for (IASTNode currentModifiedNode : this.stack.getModifiedNodes()) {
            for (ASTModification currentMod : this.stack.getModificationsForNode(currentModifiedNode)) {
                if (currentMod.getTargetNode() != node || currentMod.getKind() != ASTModification.ModificationKind.REPLACE) continue;
                if (currentMod.getNewNode() != null) {
                    this.stack.pushScope(node);
                    currentMod.getNewNode().accept(this);
                    this.stack.popScope(node);
                    return 1;
                }
                return 1;
            }
        }
        return 3;
    }

    private String getCorrespondingFile(IASTNode node) {
        if (node.getFileLocation() != null) {
            return node.getFileLocation().getFileName();
        }
        if (node.getParent() != null) {
            return this.getCorrespondingFile(node.getParent());
        }
        for (IASTNode modifiedNode : this.modificationStore.getRootModifications().getModifiedNodes()) {
            for (ASTModification modification : this.modificationStore.getRootModifications().getModificationsForNode(modifiedNode)) {
                if (modification.getNewNode() != node) continue;
                return this.getCorrespondingFile(modification.getTargetNode());
            }
        }
        return null;
    }
}

